
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/inittab.new
config etc/rc.d/rc.4.new
config etc/rc.d/rc.6.new
config etc/rc.d/rc.K.new
config etc/rc.d/rc.M.new
config etc/rc.d/rc.S.new
config etc/rc.d/rc.local.new
config etc/rc.d/rc.scanluns.new
config etc/rc.d/rc.sysvinit.new

if [ -r sbin/init ]; then
  mv sbin/init sbin/init.old
fi

mv sbin/init.new sbin/init

# Add a btmp file to store login failure if one doesn't exist:
if [ ! -r var/log/btmp ]; then
  ( cd var/log ; umask 077 ; touch btmp )
fi

# Notice we use an absolute path below, rather than usr/bin/last.  This is because
# we're testing to see if we are on the bootdisk, which will not have /usr/bin/last.
# If we aren't, we will signal init to restart using the new binary.
if [ -x /usr/bin/last ]; then
  /sbin/init u
fi

( cd sbin ; rm -rf telinit )
( cd sbin ; ln -sf  init telinit )
( cd sbin ; rm -rf reboot )
( cd sbin ; ln -sf  halt reboot )
( cd etc/rc.d ; rm -rf rc.0 )
( cd etc/rc.d ; ln -sf rc.6 rc.0 )
( cd sbin ; rm -rf pidof )
( cd sbin ; ln -sf killall5 pidof )
( cd sbin ; rm -rf poweroff )
( cd sbin ; ln -sf halt poweroff )

rm -f sbin/init.old
( cd usr/bin ; rm -rf lastb )
( cd usr/bin ; ln -sf last lastb )
( cd usr/man/man1 ; rm -rf lastb.1.gz )
( cd usr/man/man1 ; ln -sf last.1.gz lastb.1.gz )
