/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import sun.awt.image.Manageable;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceManagerFactory;
import sun.java2d.loops.CompositeType;

public abstract class SurfaceManager {
    protected ImageCapabilities imageCaps;

    private static native void initIDs();

    private static native SurfaceManager getSurfaceManager(BufferedImage var0);

    private static native void setSurfaceManager(BufferedImage var0, SurfaceManager var1);

    public static SurfaceManager getManager(Image image) {
        if (image instanceof Manageable) {
            return ((Manageable)((Object)image)).getSurfaceManager();
        }
        try {
            return SurfaceManager.getManager((BufferedImage)image);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Invalid Image variant");
        }
    }

    private static SurfaceManager getManager(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceManager surfaceManager = SurfaceManager.getSurfaceManager(bufferedImage);
        if (surfaceManager != null) {
            return surfaceManager;
        }
        surfaceManager = SurfaceManagerFactory.createCachingManager(bufferedImage);
        SurfaceManager.setSurfaceManager(bufferedImage, surfaceManager);
        return surfaceManager;
    }

    public abstract SurfaceData getSourceSurfaceData(SurfaceData var1, CompositeType var2, Color var3, boolean var4);

    public abstract SurfaceData getDestSurfaceData();

    public abstract SurfaceData restoreContents();

    public void acceleratedSurfaceLost() {
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        if (this.imageCaps == null) {
            this.imageCaps = new ImageCapabilities(false);
        }
        return this.imageCaps;
    }

    public void flush() {
    }

    static {
        SurfaceManager.initIDs();
    }
}

