/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.internal.KerberosTime;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncAPRepPart {
    public KerberosTime ctime;
    public int cusec;
    EncryptionKey subKey;
    Integer seqNumber;

    public EncAPRepPart(KerberosTime kerberosTime, int n, EncryptionKey encryptionKey, Integer n2) {
        this.ctime = kerberosTime;
        this.cusec = n;
        this.subKey = encryptionKey;
        this.seqNumber = n2;
    }

    public EncAPRepPart(byte[] byArray) throws Asn1Exception, IOException {
        this.init(new DerValue(byArray));
    }

    public EncAPRepPart(DerValue derValue) throws Asn1Exception, IOException {
        this.init(derValue);
    }

    private void init(DerValue derValue) throws Asn1Exception, IOException {
        if ((derValue.getTag() & 0x1F) != 27 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.ctime = KerberosTime.parse(derValue2.getData(), (byte)0, true);
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.cusec = derValue3.getData().getBigInteger().intValue();
        if (derValue2.getData().available() > 0) {
            this.subKey = EncryptionKey.parse(derValue2.getData(), (byte)2, true);
        } else {
            this.subKey = null;
            this.seqNumber = null;
        }
        if (derValue2.getData().available() > 0) {
            derValue3 = derValue2.getData().getDerValue();
            if ((derValue3.getTag() & 0x1F) != 3) {
                throw new Asn1Exception(906);
            }
            this.seqNumber = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.seqNumber = null;
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Vector<DerValue> vector = new Vector<DerValue>();
        DerOutputStream derOutputStream = new DerOutputStream();
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)0), this.ctime.asn1Encode()));
        derOutputStream.putInteger(BigInteger.valueOf(this.cusec));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream.toByteArray()));
        if (this.subKey != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)2), this.subKey.asn1Encode()));
        }
        if (this.seqNumber != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.seqNumber);
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream.toByteArray()));
        }
        Object[] objectArray = new DerValue[vector.size()];
        vector.copyInto(objectArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence((DerValue[])objectArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, true, (byte)27), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public final EncryptionKey getSubKey() {
        return this.subKey;
    }

    public final Integer getSeqNumber() {
        return this.seqNumber;
    }
}

