/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.DistributionPoint;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLDistributionPointsExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.CRLDistributionPoints";
    public static final String NAME = "CRLDistributionPoints";
    public static final String POINTS = "points";
    private List<DistributionPoint> distributionPoints;

    public CRLDistributionPointsExtension(List<DistributionPoint> list) throws IOException {
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = false;
        this.distributionPoints = list;
        this.encodeThis();
    }

    public CRLDistributionPointsExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for CRLDistributionPointsExtension.");
        }
        this.distributionPoints = new ArrayList<DistributionPoint>();
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            DistributionPoint distributionPoint = new DistributionPoint(derValue2);
            this.distributionPoints.add(distributionPoint);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(POINTS)) {
            if (!(object instanceof List)) {
                throw new IOException("Attribute value should be of type List.");
            }
        } else {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CRLDistributionPointsExtension.");
        }
        this.distributionPoints = (List)object;
        this.encodeThis();
    }

    @Override
    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(POINTS)) {
            return this.distributionPoints;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CRLDistributionPointsExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(POINTS)) {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CRLDistributionPointsExtension.");
        }
        this.distributionPoints = new ArrayList<DistributionPoint>();
        this.encodeThis();
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(POINTS);
        return attributeNameEnumeration.elements();
    }

    private void encodeThis() throws IOException {
        if (this.distributionPoints.isEmpty()) {
            this.extensionValue = null;
        } else {
            DerOutputStream derOutputStream = new DerOutputStream();
            for (DistributionPoint distributionPoint : this.distributionPoints) {
                distributionPoint.encode(derOutputStream);
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            this.extensionValue = derOutputStream2.toByteArray();
        }
    }

    @Override
    public String toString() {
        return super.toString() + "CRLDistributionPoints [\n  " + this.distributionPoints + "]\n";
    }
}

