/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM calICalendar.idl
 */

#ifndef __gen_calICalendar_h__
#define __gen_calICalendar_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */

class calIItemBase; /* forward declaration */

class nsIVariant; /* forward declaration */

class nsISimpleEnumerator; /* forward declaration */

class calIObserver; /* forward declaration */

class calIOperationListener; /* forward declaration */

class calIRange; /* forward declaration */

class calIDateTime; /* forward declaration */


/* starting interface:    calICalendar */
#define CALICALENDAR_IID_STR "74e685e4-d863-11d9-88f2-000b7d081f44"

#define CALICALENDAR_IID \
  {0x74e685e4, 0xd863, 0x11d9, \
    { 0x88, 0xf2, 0x00, 0x0b, 0x7d, 0x08, 0x1f, 0x44 }}

class NS_NO_VTABLE calICalendar : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(CALICALENDAR_IID)

  /**
   * Name of the calendar
   * Notes: Can only be set after the calendar is registered with the calendar manager.
   */
  /* attribute AUTF8String name; */
  NS_IMETHOD GetName(nsACString & aName) = 0;
  NS_IMETHOD SetName(const nsACString & aName) = 0;

  /**
   * Type of the calendar
   *   'memory', 'storage', 'caldav', etc
   */
  /* readonly attribute AUTF8String type; */
  NS_IMETHOD GetType(nsACString & aType) = 0;

  /**
   * Setting this URI causes the calendar to be (re)loaded.
   */
  /* attribute nsIURI uri; */
  NS_IMETHOD GetUri(nsIURI * *aUri) = 0;
  NS_IMETHOD SetUri(nsIURI * aUri) = 0;

  /**
   * Is this calendar read-only?  Used by the UI to decide whether or not 
   * widgetry should allow editing.
   */
  /* attribute boolean readOnly; */
  NS_IMETHOD GetReadOnly(PRBool *aReadOnly) = 0;
  NS_IMETHOD SetReadOnly(PRBool aReadOnly) = 0;

  /** 
   * In combination with the other parameters to getItems(), these
   * constants provide for a very basic filtering mechanisms for use
   * in getting and observing items.  At some point fairly soon, we're
   * going to need to generalize this mechanism significantly (so we
   * can allow boolean logic, categories, etc.).
   *
   * When adding item filters (bits which, when not set to 1, reduce the
   * scope of the results), use bit positions <= 15, so that
   * ITEM_FILTER_ALL_ITEMS remains compatible for components that have the
   * constant compiled in.
   *
   * XXX the naming here is questionable; adding a filter (setting a bit, in
   * this case) usually _reduces_ the set of items that pass the set of
   * filters, rather than adding to it.
   */
  enum { ITEM_FILTER_COMPLETED_YES = 1U };

  enum { ITEM_FILTER_COMPLETED_NO = 2U };

  enum { ITEM_FILTER_COMPLETED_ALL = 3U };

  enum { ITEM_FILTER_TYPE_TODO = 4U };

  enum { ITEM_FILTER_TYPE_EVENT = 8U };

  enum { ITEM_FILTER_TYPE_JOURNAL = 16U };

  enum { ITEM_FILTER_TYPE_ALL = 28U };

  enum { ITEM_FILTER_ALL_ITEMS = 65535U };

  /** 
   * If set, return calIItemOccurence items, otherwise return subclasses of
   * calIItemBase.
   */
  enum { ITEM_FILTER_CLASS_OCCURRENCES = 65536U };

  /* void addObserver (in calIObserver observer); */
  NS_IMETHOD AddObserver(calIObserver *observer) = 0;

  /* void removeObserver (in calIObserver observer); */
  NS_IMETHOD RemoveObserver(calIObserver *observer) = 0;

  /**
   * The following five "Item" functions are all asynchronous, and return
   * their results to a calIOperationListener object.
   *
   */
/**
   * addItem adds the given calIItemBase to the calendar.
   *
   * @param aItem       item to add
   * @param aListener   where to call back the results
   *
   * - If aItem already has an ID, that ID is used when adding.
   * - If aItem is mutable and has no ID, the calendar is expected
   *   to generate an ID for the item.
   * - If aItem is immutable and has no ID, an error is thrown.
   *
   * The results of the operation are reported through an
   * onOperationComplete call on the listener, with the following
   * parameters:
   *
   * - aOperationType: calIOperationListener::ADD
   * - aId: the ID of the newly added item
   * - aDetail: the calIItemBase corresponding to the immutable
   *            version of the newly added item
   *
   * If an item with a given ID already exists in the calendar,
   * onOperationComplete is called with an aStatus of NS_ERROR_XXXXX,
   * and aDetail set with the calIItemBase of the internal already
   * existing item.
   */
  /* void addItem (in calIItemBase aItem, in calIOperationListener aListener); */
  NS_IMETHOD AddItem(calIItemBase *aItem, calIOperationListener *aListener) = 0;

  /**
   * modifyItem takes a modified mutable item and modifies the
   * calendar's internal version of the item to match.  The item is
   * expected to have an ID that already exists in the calendar; if it
   * doesn't, or there is no id, onOperationComplete is called with a
   * status of NS_ERROR_XXXXX.  If the item is immutable,
   * onOperationComplete is called with a status of NS_ERROR_XXXXX.
   *
   * If the generation of the given aNewItem does not match the generation
   * of the internal item (indicating that someone else modified the
   * item), onOperationComplete is called with a status of NS_ERROR_XXXXX
   * and aDetail is set to the latest-version internal immutable item.
   *
   * @param aNewItem    new version to replace the old one
   * @param aOldItem    caller's view of the item to be changed, as it is now
   * @param aListener   where to call back the results
   *
   * The results of the operation are reported through an
   * onOperationComplete call on the listener, with the following
   * parameters:
   *
   * - aOperationType: calIOperationListener::MODIFY
   * - aId: the ID of the modified item
   * - aDetail: the calIItemBase corresponding to the newly-updated
   *            immutable version of the modified item
   */
  /* void modifyItem (in calIItemBase aNewItem, in calIItemBase aOldItem, in calIOperationListener aListener); */
  NS_IMETHOD ModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem, calIOperationListener *aListener) = 0;

  /**
   * deleteItem takes an item that is to be deleted.  The item is
   * expected to have an ID that already exists in the calendar; if it
   * doesn't, or there is no id, onOperationComplete is called with
   * a status of NS_ERROR_XXXXX.
   *
   * @param aItem       item to delete
   * @param aListener   where to call back the results
   *
   * The results of the operation are reported through an
   * onOperationComplete call on the listener, with the following
   * parameters:
   *
   * - aOperationType: calIOperationListener::DELETE
   * - aId: the ID of the deleted item
   * - aDetail: the calIItemBase corresponding to the immutable version
   *            of the deleted item
   */
  /* void deleteItem (in calIItemBase aItem, in calIOperationListener aListener); */
  NS_IMETHOD DeleteItem(calIItemBase *aItem, calIOperationListener *aListener) = 0;

  /**
   * Get a single event.  The event will be typed as one of the subclasses
   * of calIItemBase (whichever concrete type is most appropriate).
   * 
   * @param aId        UID of the event
   * @param aListener  listener to which this event will be called back.
   *
   * The results of the operation are reported through the listener,
   * via zero or one onGetResult calls (with aCount set to 1)
   * followed by an onOperationComplete.
   *
   * The parameters to onOperationComplete will be:
   *
   * - aOperationType: calIOperationListener::GET
   * - aId: the ID of the requested item
   * - aDetail: null (? we can also pass the item back here as well,..)
   */
  /* void getItem (in string aId, in calIOperationListener aListener); */
  NS_IMETHOD GetItem(const char *aId, calIOperationListener *aListener) = 0;

  /**
   * XXX As mentioned above, this method isn't suitably general.  It's just
   * placeholder until it gets supplanted by something more SQL or RDF-like.
   * 
   *   Ordering: This method is currently guaranteed to return lists ordered
   *   as follows to make for the least amount of pain when
   *   migrating existing frontend code:
   *
   *     The events are sorted based on the order of their next occurence
   *     if they recur in the future or their last occurence in the past
   *     otherwise.  Here's a presentation of the sort criteria using the
   *     time axis:
   *   
   *     -----(Last occurence of Event1)---(Last occurence of Event2)----(Now)----(Next occurence of Event3)---->
   *
   *     (Note that Event1 and Event2 will not recur in the future.)
   *
   *   We should probably be able get rid of this ordering constraint
   *   at some point in the future.
   *
   * Note that the range is intended to act as a mask on the
   * occurences, not just the initial recurring items.  So if a
   * getItems() call without ITEM_FILTER_CLASS_OCCURENCES is made, all
   * events and todos which have occurrences inside the range should
   * be returned, even if some of those events or todos themselves
   * live outside the range.
   *
   * @param aItemFilter ITEM_FILTER flags, or-ed together
   * @param aCount      Maximum number of items to return, or 0 for
   *                    an unbounded query.
   * @param aRangeStart Items starting at this time or after should be 
   *                    returned.  If invalid, assume "since the beginning
   *                    of time".
   * @param aRangeEndEx Items starting before (not including) aRangeEndEx should be
   *                    returned.  If null, assume "until the end of time".
   * @param aListener   The results will be called back through this interface.
   *
   *
   * The results of the operation are reported through the listener,
   * via zero or more onGetResult calls followed by an onOperationComplete.
   *
   * The parameters to onOperationComplete will be:
   *
   * - aOperationType: calIOperationListener::GET
   * - aId: null
   * - aDetail: null
   */
  /* void getItems (in unsigned long aItemFilter, in unsigned long aCount, in calIDateTime aRangeStart, in calIDateTime aRangeEndEx, in calIOperationListener aListener); */
  NS_IMETHOD GetItems(PRUint32 aItemFilter, PRUint32 aCount, calIDateTime *aRangeStart, calIDateTime *aRangeEndEx, calIOperationListener *aListener) = 0;

  /**
   * Whether or not alarms for this calendar should be suppressed.
   */
  /* attribute boolean suppressAlarms; */
  NS_IMETHOD GetSuppressAlarms(PRBool *aSuppressAlarms) = 0;
  NS_IMETHOD SetSuppressAlarms(PRBool aSuppressAlarms) = 0;

  /**
   * Refresh the datasource, and call the observers for any changes found.
   * May call the onLoad function of the observers if the provider doesn't
   * know the details of the changes.
   */
  /* void refresh (); */
  NS_IMETHOD Refresh(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_CALICALENDAR \
  NS_IMETHOD GetName(nsACString & aName); \
  NS_IMETHOD SetName(const nsACString & aName); \
  NS_IMETHOD GetType(nsACString & aType); \
  NS_IMETHOD GetUri(nsIURI * *aUri); \
  NS_IMETHOD SetUri(nsIURI * aUri); \
  NS_IMETHOD GetReadOnly(PRBool *aReadOnly); \
  NS_IMETHOD SetReadOnly(PRBool aReadOnly); \
  NS_IMETHOD AddObserver(calIObserver *observer); \
  NS_IMETHOD RemoveObserver(calIObserver *observer); \
  NS_IMETHOD AddItem(calIItemBase *aItem, calIOperationListener *aListener); \
  NS_IMETHOD ModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem, calIOperationListener *aListener); \
  NS_IMETHOD DeleteItem(calIItemBase *aItem, calIOperationListener *aListener); \
  NS_IMETHOD GetItem(const char *aId, calIOperationListener *aListener); \
  NS_IMETHOD GetItems(PRUint32 aItemFilter, PRUint32 aCount, calIDateTime *aRangeStart, calIDateTime *aRangeEndEx, calIOperationListener *aListener); \
  NS_IMETHOD GetSuppressAlarms(PRBool *aSuppressAlarms); \
  NS_IMETHOD SetSuppressAlarms(PRBool aSuppressAlarms); \
  NS_IMETHOD Refresh(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_CALICALENDAR(_to) \
  NS_IMETHOD GetName(nsACString & aName) { return _to GetName(aName); } \
  NS_IMETHOD SetName(const nsACString & aName) { return _to SetName(aName); } \
  NS_IMETHOD GetType(nsACString & aType) { return _to GetType(aType); } \
  NS_IMETHOD GetUri(nsIURI * *aUri) { return _to GetUri(aUri); } \
  NS_IMETHOD SetUri(nsIURI * aUri) { return _to SetUri(aUri); } \
  NS_IMETHOD GetReadOnly(PRBool *aReadOnly) { return _to GetReadOnly(aReadOnly); } \
  NS_IMETHOD SetReadOnly(PRBool aReadOnly) { return _to SetReadOnly(aReadOnly); } \
  NS_IMETHOD AddObserver(calIObserver *observer) { return _to AddObserver(observer); } \
  NS_IMETHOD RemoveObserver(calIObserver *observer) { return _to RemoveObserver(observer); } \
  NS_IMETHOD AddItem(calIItemBase *aItem, calIOperationListener *aListener) { return _to AddItem(aItem, aListener); } \
  NS_IMETHOD ModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem, calIOperationListener *aListener) { return _to ModifyItem(aNewItem, aOldItem, aListener); } \
  NS_IMETHOD DeleteItem(calIItemBase *aItem, calIOperationListener *aListener) { return _to DeleteItem(aItem, aListener); } \
  NS_IMETHOD GetItem(const char *aId, calIOperationListener *aListener) { return _to GetItem(aId, aListener); } \
  NS_IMETHOD GetItems(PRUint32 aItemFilter, PRUint32 aCount, calIDateTime *aRangeStart, calIDateTime *aRangeEndEx, calIOperationListener *aListener) { return _to GetItems(aItemFilter, aCount, aRangeStart, aRangeEndEx, aListener); } \
  NS_IMETHOD GetSuppressAlarms(PRBool *aSuppressAlarms) { return _to GetSuppressAlarms(aSuppressAlarms); } \
  NS_IMETHOD SetSuppressAlarms(PRBool aSuppressAlarms) { return _to SetSuppressAlarms(aSuppressAlarms); } \
  NS_IMETHOD Refresh(void) { return _to Refresh(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_CALICALENDAR(_to) \
  NS_IMETHOD GetName(nsACString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetName(aName); } \
  NS_IMETHOD SetName(const nsACString & aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetName(aName); } \
  NS_IMETHOD GetType(nsACString & aType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetType(aType); } \
  NS_IMETHOD GetUri(nsIURI * *aUri) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUri(aUri); } \
  NS_IMETHOD SetUri(nsIURI * aUri) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUri(aUri); } \
  NS_IMETHOD GetReadOnly(PRBool *aReadOnly) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReadOnly(aReadOnly); } \
  NS_IMETHOD SetReadOnly(PRBool aReadOnly) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReadOnly(aReadOnly); } \
  NS_IMETHOD AddObserver(calIObserver *observer) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddObserver(observer); } \
  NS_IMETHOD RemoveObserver(calIObserver *observer) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveObserver(observer); } \
  NS_IMETHOD AddItem(calIItemBase *aItem, calIOperationListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddItem(aItem, aListener); } \
  NS_IMETHOD ModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem, calIOperationListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->ModifyItem(aNewItem, aOldItem, aListener); } \
  NS_IMETHOD DeleteItem(calIItemBase *aItem, calIOperationListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteItem(aItem, aListener); } \
  NS_IMETHOD GetItem(const char *aId, calIOperationListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetItem(aId, aListener); } \
  NS_IMETHOD GetItems(PRUint32 aItemFilter, PRUint32 aCount, calIDateTime *aRangeStart, calIDateTime *aRangeEndEx, calIOperationListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetItems(aItemFilter, aCount, aRangeStart, aRangeEndEx, aListener); } \
  NS_IMETHOD GetSuppressAlarms(PRBool *aSuppressAlarms) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSuppressAlarms(aSuppressAlarms); } \
  NS_IMETHOD SetSuppressAlarms(PRBool aSuppressAlarms) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSuppressAlarms(aSuppressAlarms); } \
  NS_IMETHOD Refresh(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Refresh(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public calICalendar
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CALICALENDAR

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, calICalendar)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* attribute AUTF8String name; */
NS_IMETHODIMP _MYCLASS_::GetName(nsACString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetName(const nsACString & aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AUTF8String type; */
NS_IMETHODIMP _MYCLASS_::GetType(nsACString & aType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIURI uri; */
NS_IMETHODIMP _MYCLASS_::GetUri(nsIURI * *aUri)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetUri(nsIURI * aUri)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean readOnly; */
NS_IMETHODIMP _MYCLASS_::GetReadOnly(PRBool *aReadOnly)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetReadOnly(PRBool aReadOnly)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addObserver (in calIObserver observer); */
NS_IMETHODIMP _MYCLASS_::AddObserver(calIObserver *observer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeObserver (in calIObserver observer); */
NS_IMETHODIMP _MYCLASS_::RemoveObserver(calIObserver *observer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addItem (in calIItemBase aItem, in calIOperationListener aListener); */
NS_IMETHODIMP _MYCLASS_::AddItem(calIItemBase *aItem, calIOperationListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void modifyItem (in calIItemBase aNewItem, in calIItemBase aOldItem, in calIOperationListener aListener); */
NS_IMETHODIMP _MYCLASS_::ModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem, calIOperationListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteItem (in calIItemBase aItem, in calIOperationListener aListener); */
NS_IMETHODIMP _MYCLASS_::DeleteItem(calIItemBase *aItem, calIOperationListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getItem (in string aId, in calIOperationListener aListener); */
NS_IMETHODIMP _MYCLASS_::GetItem(const char *aId, calIOperationListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getItems (in unsigned long aItemFilter, in unsigned long aCount, in calIDateTime aRangeStart, in calIDateTime aRangeEndEx, in calIOperationListener aListener); */
NS_IMETHODIMP _MYCLASS_::GetItems(PRUint32 aItemFilter, PRUint32 aCount, calIDateTime *aRangeStart, calIDateTime *aRangeEndEx, calIOperationListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean suppressAlarms; */
NS_IMETHODIMP _MYCLASS_::GetSuppressAlarms(PRBool *aSuppressAlarms)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetSuppressAlarms(PRBool aSuppressAlarms)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void refresh (); */
NS_IMETHODIMP _MYCLASS_::Refresh()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    calICompositeCalendar */
#define CALICOMPOSITECALENDAR_IID_STR "8285aa0b-594c-4f93-abe3-523df947e0ad"

#define CALICOMPOSITECALENDAR_IID \
  {0x8285aa0b, 0x594c, 0x4f93, \
    { 0xab, 0xe3, 0x52, 0x3d, 0xf9, 0x47, 0xe0, 0xad }}

/** 
 * Used to allow multiple calendars (eg work and home) to be easily queried
 * and displayed as a single unit.
 */
class NS_NO_VTABLE calICompositeCalendar : public calICalendar {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(CALICOMPOSITECALENDAR_IID)

  /**
   * Add an already created calendar to the composite
   * 
   * @param aCalendar the calendar to be added
   */
  /* void addCalendar (in calICalendar aCalendar); */
  NS_IMETHOD AddCalendar(calICalendar *aCalendar) = 0;

  /**
   * Remove a calendar from the composite
   * 
   * @param aServer  URI of the server to be removed
   */
  /* void removeCalendar (in nsIURI aServer); */
  NS_IMETHOD RemoveCalendar(nsIURI *aServer) = 0;

  /**
   * If a calendar for the given URI exists in the CompositeCalendar,
   * return it; otherwise return null.
   *
   * @param aServer  URI of the server whose calendar to return
   * @return calendar for aServer, or null if none
   */
  /* calICalendar getCalendar (in nsIURI aServer); */
  NS_IMETHOD GetCalendar(nsIURI *aServer, calICalendar **_retval) = 0;

  /**
   * An enumerator of all calICalendars that make up this composite.
   */
  /* readonly attribute nsISimpleEnumerator calendars; */
  NS_IMETHOD GetCalendars(nsISimpleEnumerator * *aCalendars) = 0;

  /**
   * In order for addItem() to be called on this object, it is first necessary
   * to set this attribute to specify which underlying calendar the item is
   * to be added to.
   */
  /* attribute calICalendar defaultCalendar; */
  NS_IMETHOD GetDefaultCalendar(calICalendar * *aDefaultCalendar) = 0;
  NS_IMETHOD SetDefaultCalendar(calICalendar * aDefaultCalendar) = 0;

  /**
   * If set, the composite will initialize itself from calICalendarManager
   * prefs keyed off of the provided prefPrefix, and update those prefs to
   * track changes in calendar membership and default calendar.
   */
  /* attribute ACString prefPrefix; */
  NS_IMETHOD GetPrefPrefix(nsACString & aPrefPrefix) = 0;
  NS_IMETHOD SetPrefPrefix(const nsACString & aPrefPrefix) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_CALICOMPOSITECALENDAR \
  NS_IMETHOD AddCalendar(calICalendar *aCalendar); \
  NS_IMETHOD RemoveCalendar(nsIURI *aServer); \
  NS_IMETHOD GetCalendar(nsIURI *aServer, calICalendar **_retval); \
  NS_IMETHOD GetCalendars(nsISimpleEnumerator * *aCalendars); \
  NS_IMETHOD GetDefaultCalendar(calICalendar * *aDefaultCalendar); \
  NS_IMETHOD SetDefaultCalendar(calICalendar * aDefaultCalendar); \
  NS_IMETHOD GetPrefPrefix(nsACString & aPrefPrefix); \
  NS_IMETHOD SetPrefPrefix(const nsACString & aPrefPrefix); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_CALICOMPOSITECALENDAR(_to) \
  NS_IMETHOD AddCalendar(calICalendar *aCalendar) { return _to AddCalendar(aCalendar); } \
  NS_IMETHOD RemoveCalendar(nsIURI *aServer) { return _to RemoveCalendar(aServer); } \
  NS_IMETHOD GetCalendar(nsIURI *aServer, calICalendar **_retval) { return _to GetCalendar(aServer, _retval); } \
  NS_IMETHOD GetCalendars(nsISimpleEnumerator * *aCalendars) { return _to GetCalendars(aCalendars); } \
  NS_IMETHOD GetDefaultCalendar(calICalendar * *aDefaultCalendar) { return _to GetDefaultCalendar(aDefaultCalendar); } \
  NS_IMETHOD SetDefaultCalendar(calICalendar * aDefaultCalendar) { return _to SetDefaultCalendar(aDefaultCalendar); } \
  NS_IMETHOD GetPrefPrefix(nsACString & aPrefPrefix) { return _to GetPrefPrefix(aPrefPrefix); } \
  NS_IMETHOD SetPrefPrefix(const nsACString & aPrefPrefix) { return _to SetPrefPrefix(aPrefPrefix); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_CALICOMPOSITECALENDAR(_to) \
  NS_IMETHOD AddCalendar(calICalendar *aCalendar) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCalendar(aCalendar); } \
  NS_IMETHOD RemoveCalendar(nsIURI *aServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveCalendar(aServer); } \
  NS_IMETHOD GetCalendar(nsIURI *aServer, calICalendar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCalendar(aServer, _retval); } \
  NS_IMETHOD GetCalendars(nsISimpleEnumerator * *aCalendars) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCalendars(aCalendars); } \
  NS_IMETHOD GetDefaultCalendar(calICalendar * *aDefaultCalendar) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultCalendar(aDefaultCalendar); } \
  NS_IMETHOD SetDefaultCalendar(calICalendar * aDefaultCalendar) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDefaultCalendar(aDefaultCalendar); } \
  NS_IMETHOD GetPrefPrefix(nsACString & aPrefPrefix) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrefPrefix(aPrefPrefix); } \
  NS_IMETHOD SetPrefPrefix(const nsACString & aPrefPrefix) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPrefPrefix(aPrefPrefix); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public calICompositeCalendar
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CALICOMPOSITECALENDAR

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, calICompositeCalendar)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* void addCalendar (in calICalendar aCalendar); */
NS_IMETHODIMP _MYCLASS_::AddCalendar(calICalendar *aCalendar)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeCalendar (in nsIURI aServer); */
NS_IMETHODIMP _MYCLASS_::RemoveCalendar(nsIURI *aServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* calICalendar getCalendar (in nsIURI aServer); */
NS_IMETHODIMP _MYCLASS_::GetCalendar(nsIURI *aServer, calICalendar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator calendars; */
NS_IMETHODIMP _MYCLASS_::GetCalendars(nsISimpleEnumerator * *aCalendars)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute calICalendar defaultCalendar; */
NS_IMETHODIMP _MYCLASS_::GetDefaultCalendar(calICalendar * *aDefaultCalendar)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetDefaultCalendar(calICalendar * aDefaultCalendar)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute ACString prefPrefix; */
NS_IMETHODIMP _MYCLASS_::GetPrefPrefix(nsACString & aPrefPrefix)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP _MYCLASS_::SetPrefPrefix(const nsACString & aPrefPrefix)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    calIObserver */
#define CALIOBSERVER_IID_STR "2953c9b2-2c73-11d9-80b6-00045ace3b8d"

#define CALIOBSERVER_IID \
  {0x2953c9b2, 0x2c73, 0x11d9, \
    { 0x80, 0xb6, 0x00, 0x04, 0x5a, 0xce, 0x3b, 0x8d }}

class NS_NO_VTABLE calIObserver : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(CALIOBSERVER_IID)

  /**
 * Make a more general nsIObserverService2 and friends to support
 * nsISupports data and use that instead?
 */
  /* void onStartBatch (); */
  NS_IMETHOD OnStartBatch(void) = 0;

  /* void onEndBatch (); */
  NS_IMETHOD OnEndBatch(void) = 0;

  /* void onLoad (); */
  NS_IMETHOD OnLoad(void) = 0;

  /* void onAddItem (in calIItemBase aItem); */
  NS_IMETHOD OnAddItem(calIItemBase *aItem) = 0;

  /* void onModifyItem (in calIItemBase aNewItem, in calIItemBase aOldItem); */
  NS_IMETHOD OnModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem) = 0;

  /* void onDeleteItem (in calIItemBase aDeletedItem); */
  NS_IMETHOD OnDeleteItem(calIItemBase *aDeletedItem) = 0;

  /* void onAlarm (in calIItemBase aAlarmItem); */
  NS_IMETHOD OnAlarm(calIItemBase *aAlarmItem) = 0;

  /* void onError (in nsresult aErrNo, in AUTF8String aMessage); */
  NS_IMETHOD OnError(nsresult aErrNo, const nsACString & aMessage) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_CALIOBSERVER \
  NS_IMETHOD OnStartBatch(void); \
  NS_IMETHOD OnEndBatch(void); \
  NS_IMETHOD OnLoad(void); \
  NS_IMETHOD OnAddItem(calIItemBase *aItem); \
  NS_IMETHOD OnModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem); \
  NS_IMETHOD OnDeleteItem(calIItemBase *aDeletedItem); \
  NS_IMETHOD OnAlarm(calIItemBase *aAlarmItem); \
  NS_IMETHOD OnError(nsresult aErrNo, const nsACString & aMessage); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_CALIOBSERVER(_to) \
  NS_IMETHOD OnStartBatch(void) { return _to OnStartBatch(); } \
  NS_IMETHOD OnEndBatch(void) { return _to OnEndBatch(); } \
  NS_IMETHOD OnLoad(void) { return _to OnLoad(); } \
  NS_IMETHOD OnAddItem(calIItemBase *aItem) { return _to OnAddItem(aItem); } \
  NS_IMETHOD OnModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem) { return _to OnModifyItem(aNewItem, aOldItem); } \
  NS_IMETHOD OnDeleteItem(calIItemBase *aDeletedItem) { return _to OnDeleteItem(aDeletedItem); } \
  NS_IMETHOD OnAlarm(calIItemBase *aAlarmItem) { return _to OnAlarm(aAlarmItem); } \
  NS_IMETHOD OnError(nsresult aErrNo, const nsACString & aMessage) { return _to OnError(aErrNo, aMessage); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_CALIOBSERVER(_to) \
  NS_IMETHOD OnStartBatch(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnStartBatch(); } \
  NS_IMETHOD OnEndBatch(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnEndBatch(); } \
  NS_IMETHOD OnLoad(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnLoad(); } \
  NS_IMETHOD OnAddItem(calIItemBase *aItem) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnAddItem(aItem); } \
  NS_IMETHOD OnModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnModifyItem(aNewItem, aOldItem); } \
  NS_IMETHOD OnDeleteItem(calIItemBase *aDeletedItem) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDeleteItem(aDeletedItem); } \
  NS_IMETHOD OnAlarm(calIItemBase *aAlarmItem) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnAlarm(aAlarmItem); } \
  NS_IMETHOD OnError(nsresult aErrNo, const nsACString & aMessage) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnError(aErrNo, aMessage); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public calIObserver
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CALIOBSERVER

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, calIObserver)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* void onStartBatch (); */
NS_IMETHODIMP _MYCLASS_::OnStartBatch()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onEndBatch (); */
NS_IMETHODIMP _MYCLASS_::OnEndBatch()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onLoad (); */
NS_IMETHODIMP _MYCLASS_::OnLoad()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onAddItem (in calIItemBase aItem); */
NS_IMETHODIMP _MYCLASS_::OnAddItem(calIItemBase *aItem)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onModifyItem (in calIItemBase aNewItem, in calIItemBase aOldItem); */
NS_IMETHODIMP _MYCLASS_::OnModifyItem(calIItemBase *aNewItem, calIItemBase *aOldItem)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDeleteItem (in calIItemBase aDeletedItem); */
NS_IMETHODIMP _MYCLASS_::OnDeleteItem(calIItemBase *aDeletedItem)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onAlarm (in calIItemBase aAlarmItem); */
NS_IMETHODIMP _MYCLASS_::OnAlarm(calIItemBase *aAlarmItem)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onError (in nsresult aErrNo, in AUTF8String aMessage); */
NS_IMETHODIMP _MYCLASS_::OnError(nsresult aErrNo, const nsACString & aMessage)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    calICompositeObserver */
#define CALICOMPOSITEOBSERVER_IID_STR "a3584c92-b8eb-4aa8-a638-e46a2e11d6a9"

#define CALICOMPOSITEOBSERVER_IID \
  {0xa3584c92, 0xb8eb, 0x4aa8, \
    { 0xa6, 0x38, 0xe4, 0x6a, 0x2e, 0x11, 0xd6, 0xa9 }}

/**
 * calICompositeObserver interface adds things to observe changes to
 * a calICompositeCalendar
 */
class NS_NO_VTABLE calICompositeObserver : public calIObserver {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(CALICOMPOSITEOBSERVER_IID)

  /* void onCalendarAdded (in calICalendar aCalendar); */
  NS_IMETHOD OnCalendarAdded(calICalendar *aCalendar) = 0;

  /* void onCalendarRemoved (in calICalendar aCalendar); */
  NS_IMETHOD OnCalendarRemoved(calICalendar *aCalendar) = 0;

  /* void onDefaultCalendarChanged (in calICalendar aNewDefaultCalendar); */
  NS_IMETHOD OnDefaultCalendarChanged(calICalendar *aNewDefaultCalendar) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_CALICOMPOSITEOBSERVER \
  NS_IMETHOD OnCalendarAdded(calICalendar *aCalendar); \
  NS_IMETHOD OnCalendarRemoved(calICalendar *aCalendar); \
  NS_IMETHOD OnDefaultCalendarChanged(calICalendar *aNewDefaultCalendar); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_CALICOMPOSITEOBSERVER(_to) \
  NS_IMETHOD OnCalendarAdded(calICalendar *aCalendar) { return _to OnCalendarAdded(aCalendar); } \
  NS_IMETHOD OnCalendarRemoved(calICalendar *aCalendar) { return _to OnCalendarRemoved(aCalendar); } \
  NS_IMETHOD OnDefaultCalendarChanged(calICalendar *aNewDefaultCalendar) { return _to OnDefaultCalendarChanged(aNewDefaultCalendar); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_CALICOMPOSITEOBSERVER(_to) \
  NS_IMETHOD OnCalendarAdded(calICalendar *aCalendar) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnCalendarAdded(aCalendar); } \
  NS_IMETHOD OnCalendarRemoved(calICalendar *aCalendar) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnCalendarRemoved(aCalendar); } \
  NS_IMETHOD OnDefaultCalendarChanged(calICalendar *aNewDefaultCalendar) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDefaultCalendarChanged(aNewDefaultCalendar); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public calICompositeObserver
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CALICOMPOSITEOBSERVER

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, calICompositeObserver)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* void onCalendarAdded (in calICalendar aCalendar); */
NS_IMETHODIMP _MYCLASS_::OnCalendarAdded(calICalendar *aCalendar)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onCalendarRemoved (in calICalendar aCalendar); */
NS_IMETHODIMP _MYCLASS_::OnCalendarRemoved(calICalendar *aCalendar)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDefaultCalendarChanged (in calICalendar aNewDefaultCalendar); */
NS_IMETHODIMP _MYCLASS_::OnDefaultCalendarChanged(calICalendar *aNewDefaultCalendar)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    calIOperationListener */
#define CALIOPERATIONLISTENER_IID_STR "ed3d87d8-2c77-11d9-8f5f-00045ace3b8d"

#define CALIOPERATIONLISTENER_IID \
  {0xed3d87d8, 0x2c77, 0x11d9, \
    { 0x8f, 0x5f, 0x00, 0x04, 0x5a, 0xce, 0x3b, 0x8d }}

class NS_NO_VTABLE calIOperationListener : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(CALIOPERATIONLISTENER_IID)

  /**
 * Async operations are called back via this interface.  If you know that your
 * object is not going to get called back for either of these methods, having
 * them return NS_ERROR_NOT_IMPLEMENTED is reasonable.
 */
/**
   * For add, modify, and delete.
   *
   * @param aCalendar       the calICalendar on which the operation took place
   * @param aStatus         status code summarizing what happened
   * @param aOperationType  type of operation that was completed
   * @param aId             UUID of element that was changed
   * @param aDetail         not yet fully specified.  If aStatus is an error
   *                        result, this will probably be an extended error
   *                        string (eg one returned by a server).
   */
  /* void onOperationComplete (in calICalendar aCalendar, in nsresult aStatus, in unsigned long aOperationType, in string aId, in nsIVariant aDetail); */
  NS_IMETHOD OnOperationComplete(calICalendar *aCalendar, nsresult aStatus, PRUint32 aOperationType, const char *aId, nsIVariant *aDetail) = 0;

  enum { ADD = 1U };

  enum { MOVE = 2U };

  enum { DELETE = 3U };

  enum { GET = 4U };

  /**
   * For getItem and getItems.
   * 
   * @param aStatus   status code summarizing what happened.
   * @param aItemType type of interface returned in the array (@see
   *                  calICalendar::GetItems).
   * @param aDetail   not yet fully specified.  If aStatus is an error
   *                  result, this will probably be an extended error
   *                  string (eg one returned by a server).
   * @param aCount    size of array returned, in items
   * @param aItems    array of immutable items
   *
   * Multiple onGetResults might be called 
   */
  /* void onGetResult (in calICalendar aCalendar, in nsresult aStatus, in nsIIDRef aItemType, in nsIVariant aDetail, in PRUint32 aCount, [array, size_is (aCount), iid_is (aItemType)] in nsQIResult aItems); */
  NS_IMETHOD OnGetResult(calICalendar *aCalendar, nsresult aStatus, const nsIID & aItemType, nsIVariant *aDetail, PRUint32 aCount, void * *aItems) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_CALIOPERATIONLISTENER \
  NS_IMETHOD OnOperationComplete(calICalendar *aCalendar, nsresult aStatus, PRUint32 aOperationType, const char *aId, nsIVariant *aDetail); \
  NS_IMETHOD OnGetResult(calICalendar *aCalendar, nsresult aStatus, const nsIID & aItemType, nsIVariant *aDetail, PRUint32 aCount, void * *aItems); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_CALIOPERATIONLISTENER(_to) \
  NS_IMETHOD OnOperationComplete(calICalendar *aCalendar, nsresult aStatus, PRUint32 aOperationType, const char *aId, nsIVariant *aDetail) { return _to OnOperationComplete(aCalendar, aStatus, aOperationType, aId, aDetail); } \
  NS_IMETHOD OnGetResult(calICalendar *aCalendar, nsresult aStatus, const nsIID & aItemType, nsIVariant *aDetail, PRUint32 aCount, void * *aItems) { return _to OnGetResult(aCalendar, aStatus, aItemType, aDetail, aCount, aItems); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_CALIOPERATIONLISTENER(_to) \
  NS_IMETHOD OnOperationComplete(calICalendar *aCalendar, nsresult aStatus, PRUint32 aOperationType, const char *aId, nsIVariant *aDetail) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnOperationComplete(aCalendar, aStatus, aOperationType, aId, aDetail); } \
  NS_IMETHOD OnGetResult(calICalendar *aCalendar, nsresult aStatus, const nsIID & aItemType, nsIVariant *aDetail, PRUint32 aCount, void * *aItems) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnGetResult(aCalendar, aStatus, aItemType, aDetail, aCount, aItems); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public calIOperationListener
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_CALIOPERATIONLISTENER

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, calIOperationListener)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* void onOperationComplete (in calICalendar aCalendar, in nsresult aStatus, in unsigned long aOperationType, in string aId, in nsIVariant aDetail); */
NS_IMETHODIMP _MYCLASS_::OnOperationComplete(calICalendar *aCalendar, nsresult aStatus, PRUint32 aOperationType, const char *aId, nsIVariant *aDetail)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onGetResult (in calICalendar aCalendar, in nsresult aStatus, in nsIIDRef aItemType, in nsIVariant aDetail, in PRUint32 aCount, [array, size_is (aCount), iid_is (aItemType)] in nsQIResult aItems); */
NS_IMETHODIMP _MYCLASS_::OnGetResult(calICalendar *aCalendar, nsresult aStatus, const nsIID & aItemType, nsIVariant *aDetail, PRUint32 aCount, void * *aItems)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_calICalendar_h__ */
