/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM mozIStorageConnection.idl
 */

#ifndef __gen_mozIStorageConnection_h__
#define __gen_mozIStorageConnection_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class mozIStorageFunction; /* forward declaration */

class mozIStorageStatement; /* forward declaration */

class nsIFile; /* forward declaration */


/* starting interface:    mozIStorageConnection */
#define MOZISTORAGECONNECTION_IID_STR "623b8b2e-c9f9-4cc3-b15a-f3c96df2cc1c"

#define MOZISTORAGECONNECTION_IID \
  {0x623b8b2e, 0xc9f9, 0x4cc3, \
    { 0xb1, 0x5a, 0xf3, 0xc9, 0x6d, 0xf2, 0xcc, 0x1c }}

class NS_NO_VTABLE mozIStorageConnection : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(MOZISTORAGECONNECTION_IID)

  /**
   * whether the database is open or not
   */
  /* readonly attribute boolean connectionReady; */
  NS_IMETHOD GetConnectionReady(PRBool *aConnectionReady) = 0;

  /**
   * the current database filename
   */
  /* readonly attribute AUTF8String databaseName; */
  NS_IMETHOD GetDatabaseName(nsACString & aDatabaseName) = 0;

  /**
   * lastInsertRowID returns the row ID from the last INSERT
   * operation.
   */
  /* readonly attribute long long lastInsertRowID; */
  NS_IMETHOD GetLastInsertRowID(PRInt64 *aLastInsertRowID) = 0;

  /**
   * lastError returns the last error code
   */
  /* readonly attribute long lastError; */
  NS_IMETHOD GetLastError(PRInt32 *aLastError) = 0;

  /**
   * lastErrorString returns the last error as a string
   */
  /* readonly attribute AUTF8String lastErrorString; */
  NS_IMETHOD GetLastErrorString(nsACString & aLastErrorString) = 0;

  /**
   * Create a mozIStorageStatement for the given SQL expression.
   * The expression may use ?0 ?1 etc. to indicate numbered arguments.
   *
   * @param aSQLStatement  The SQL statement to execute
   *
   * @returns a new mozIStorageStatement
   */
  /* mozIStorageStatement createStatement (in AUTF8String aSQLStatement); */
  NS_IMETHOD CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval) = 0;

  /**
   * Execute a SQL expression, expecting no arguments.
   *
   * @param aSQLStatement  The SQL statement to execute
   */
  /* void executeSimpleSQL (in AUTF8String aSQLStatement); */
  NS_IMETHOD ExecuteSimpleSQL(const nsACString & aSQLStatement) = 0;

  /**
   * Check if the given table exists.
   *
   * @param aTableName   The table to check
   * @returns TRUE if table exists, FALSE otherwise.
   */
  /* boolean tableExists (in AUTF8String aTableName); */
  NS_IMETHOD TableExists(const nsACString & aTableName, PRBool *_retval) = 0;

  /**
   * Returns true if a transaction is active on this connection.
   */
  /* readonly attribute boolean transactionInProgress; */
  NS_IMETHOD GetTransactionInProgress(PRBool *aTransactionInProgress) = 0;

  /**
   * Begin a new transaction.  If a transaction is active,
   * @throws NS_ERROR_STORAGE_INVALID_OPERATION.
   */
  /* void beginTransaction (); */
  NS_IMETHOD BeginTransaction(void) = 0;

  /**
   * Commits the current transaction.  If no transaction is active,
   * @throws NS_ERROR_STORAGE_NO_TRANSACTION.
   */
  /* void commitTransaction (); */
  NS_IMETHOD CommitTransaction(void) = 0;

  /**
   * Rolls back the current transaction.  If no transaction is active,
   * @throws NS_ERROR_STORAGE_NO_TRANSACTION.
   */
  /* void rollbackTransaction (); */
  NS_IMETHOD RollbackTransaction(void) = 0;

  /**
   * Create the table with the given name and schema.  If the table
   * already exists with the given schema, the non-error
   * NS_STORAGE_TABLE_EXISTS is returned.  If the table exists but with
   * a different schema, NS_ERROR_STORAGE_TABLE_CONFLICT (?) is thrown.
   *
   * @param aID the owner of this table -- XXXtodo
   *
   * @param aTableName the table name to be created, consisting of [A-Za-z0-9_], and beginning with a letter.
   *
   * @param aTableSchema the schema of the table; what would normally go between the parens in a CREATE TABLE
   *                     statement: "foo INTEGER, bar STRING".
   */
  /* void createTable (in string aTableName, in string aTableSchema); */
  NS_IMETHOD CreateTable(const char *aTableName, const char *aTableSchema) = 0;

  /**
   * Create a new SQLite function
   */
  /* void createFunction (in string aFunctionName, in long aNumArguments, in mozIStorageFunction aFunction); */
  NS_IMETHOD CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction) = 0;

  /**
   * Create a new trigger.  Note that we only support AFTER triggers here,
   * not BEFORE (so that we can support IPC notification of triggers).
   * All triggers created this way are TEMPORARY triggers, i.e. they are only
   * valid for the duration of this connection.  Without this, triggers would
   * persist between connections, even if the functions they refer to may no
   * longer be defined; this would be bad.
   *
   * aParameters is a comma-separated list of parameters, referencing
   * either "new.*" or "old.*", as appropriate for the trigger event
   * type.
   */
  enum { TRIGGER_EVENT_DELETE = 1 };

  enum { TRIGGER_EVENT_INSERT = 2 };

  enum { TRIGGER_EVENT_UPDATE = 3 };

  /* void createTrigger (in string aTriggerName, in long aTriggerType, in string aTableName, in string aTriggerFunction, in string aParameters); */
  NS_IMETHOD CreateTrigger(const char *aTriggerName, PRInt32 aTriggerType, const char *aTableName, const char *aTriggerFunction, const char *aParameters) = 0;

  /* void removeTrigger (in string aTriggerName); */
  NS_IMETHOD RemoveTrigger(const char *aTriggerName) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_MOZISTORAGECONNECTION \
  NS_IMETHOD GetConnectionReady(PRBool *aConnectionReady); \
  NS_IMETHOD GetDatabaseName(nsACString & aDatabaseName); \
  NS_IMETHOD GetLastInsertRowID(PRInt64 *aLastInsertRowID); \
  NS_IMETHOD GetLastError(PRInt32 *aLastError); \
  NS_IMETHOD GetLastErrorString(nsACString & aLastErrorString); \
  NS_IMETHOD CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval); \
  NS_IMETHOD ExecuteSimpleSQL(const nsACString & aSQLStatement); \
  NS_IMETHOD TableExists(const nsACString & aTableName, PRBool *_retval); \
  NS_IMETHOD GetTransactionInProgress(PRBool *aTransactionInProgress); \
  NS_IMETHOD BeginTransaction(void); \
  NS_IMETHOD CommitTransaction(void); \
  NS_IMETHOD RollbackTransaction(void); \
  NS_IMETHOD CreateTable(const char *aTableName, const char *aTableSchema); \
  NS_IMETHOD CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction); \
  NS_IMETHOD CreateTrigger(const char *aTriggerName, PRInt32 aTriggerType, const char *aTableName, const char *aTriggerFunction, const char *aParameters); \
  NS_IMETHOD RemoveTrigger(const char *aTriggerName); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_MOZISTORAGECONNECTION(_to) \
  NS_IMETHOD GetConnectionReady(PRBool *aConnectionReady) { return _to GetConnectionReady(aConnectionReady); } \
  NS_IMETHOD GetDatabaseName(nsACString & aDatabaseName) { return _to GetDatabaseName(aDatabaseName); } \
  NS_IMETHOD GetLastInsertRowID(PRInt64 *aLastInsertRowID) { return _to GetLastInsertRowID(aLastInsertRowID); } \
  NS_IMETHOD GetLastError(PRInt32 *aLastError) { return _to GetLastError(aLastError); } \
  NS_IMETHOD GetLastErrorString(nsACString & aLastErrorString) { return _to GetLastErrorString(aLastErrorString); } \
  NS_IMETHOD CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval) { return _to CreateStatement(aSQLStatement, _retval); } \
  NS_IMETHOD ExecuteSimpleSQL(const nsACString & aSQLStatement) { return _to ExecuteSimpleSQL(aSQLStatement); } \
  NS_IMETHOD TableExists(const nsACString & aTableName, PRBool *_retval) { return _to TableExists(aTableName, _retval); } \
  NS_IMETHOD GetTransactionInProgress(PRBool *aTransactionInProgress) { return _to GetTransactionInProgress(aTransactionInProgress); } \
  NS_IMETHOD BeginTransaction(void) { return _to BeginTransaction(); } \
  NS_IMETHOD CommitTransaction(void) { return _to CommitTransaction(); } \
  NS_IMETHOD RollbackTransaction(void) { return _to RollbackTransaction(); } \
  NS_IMETHOD CreateTable(const char *aTableName, const char *aTableSchema) { return _to CreateTable(aTableName, aTableSchema); } \
  NS_IMETHOD CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction) { return _to CreateFunction(aFunctionName, aNumArguments, aFunction); } \
  NS_IMETHOD CreateTrigger(const char *aTriggerName, PRInt32 aTriggerType, const char *aTableName, const char *aTriggerFunction, const char *aParameters) { return _to CreateTrigger(aTriggerName, aTriggerType, aTableName, aTriggerFunction, aParameters); } \
  NS_IMETHOD RemoveTrigger(const char *aTriggerName) { return _to RemoveTrigger(aTriggerName); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_MOZISTORAGECONNECTION(_to) \
  NS_IMETHOD GetConnectionReady(PRBool *aConnectionReady) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetConnectionReady(aConnectionReady); } \
  NS_IMETHOD GetDatabaseName(nsACString & aDatabaseName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDatabaseName(aDatabaseName); } \
  NS_IMETHOD GetLastInsertRowID(PRInt64 *aLastInsertRowID) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastInsertRowID(aLastInsertRowID); } \
  NS_IMETHOD GetLastError(PRInt32 *aLastError) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastError(aLastError); } \
  NS_IMETHOD GetLastErrorString(nsACString & aLastErrorString) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastErrorString(aLastErrorString); } \
  NS_IMETHOD CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateStatement(aSQLStatement, _retval); } \
  NS_IMETHOD ExecuteSimpleSQL(const nsACString & aSQLStatement) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExecuteSimpleSQL(aSQLStatement); } \
  NS_IMETHOD TableExists(const nsACString & aTableName, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->TableExists(aTableName, _retval); } \
  NS_IMETHOD GetTransactionInProgress(PRBool *aTransactionInProgress) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTransactionInProgress(aTransactionInProgress); } \
  NS_IMETHOD BeginTransaction(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->BeginTransaction(); } \
  NS_IMETHOD CommitTransaction(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CommitTransaction(); } \
  NS_IMETHOD RollbackTransaction(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RollbackTransaction(); } \
  NS_IMETHOD CreateTable(const char *aTableName, const char *aTableSchema) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTable(aTableName, aTableSchema); } \
  NS_IMETHOD CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateFunction(aFunctionName, aNumArguments, aFunction); } \
  NS_IMETHOD CreateTrigger(const char *aTriggerName, PRInt32 aTriggerType, const char *aTableName, const char *aTriggerFunction, const char *aParameters) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTrigger(aTriggerName, aTriggerType, aTableName, aTriggerFunction, aParameters); } \
  NS_IMETHOD RemoveTrigger(const char *aTriggerName) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveTrigger(aTriggerName); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public mozIStorageConnection
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MOZISTORAGECONNECTION

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, mozIStorageConnection)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute boolean connectionReady; */
NS_IMETHODIMP _MYCLASS_::GetConnectionReady(PRBool *aConnectionReady)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AUTF8String databaseName; */
NS_IMETHODIMP _MYCLASS_::GetDatabaseName(nsACString & aDatabaseName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long long lastInsertRowID; */
NS_IMETHODIMP _MYCLASS_::GetLastInsertRowID(PRInt64 *aLastInsertRowID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long lastError; */
NS_IMETHODIMP _MYCLASS_::GetLastError(PRInt32 *aLastError)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute AUTF8String lastErrorString; */
NS_IMETHODIMP _MYCLASS_::GetLastErrorString(nsACString & aLastErrorString)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* mozIStorageStatement createStatement (in AUTF8String aSQLStatement); */
NS_IMETHODIMP _MYCLASS_::CreateStatement(const nsACString & aSQLStatement, mozIStorageStatement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void executeSimpleSQL (in AUTF8String aSQLStatement); */
NS_IMETHODIMP _MYCLASS_::ExecuteSimpleSQL(const nsACString & aSQLStatement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean tableExists (in AUTF8String aTableName); */
NS_IMETHODIMP _MYCLASS_::TableExists(const nsACString & aTableName, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean transactionInProgress; */
NS_IMETHODIMP _MYCLASS_::GetTransactionInProgress(PRBool *aTransactionInProgress)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void beginTransaction (); */
NS_IMETHODIMP _MYCLASS_::BeginTransaction()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void commitTransaction (); */
NS_IMETHODIMP _MYCLASS_::CommitTransaction()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void rollbackTransaction (); */
NS_IMETHODIMP _MYCLASS_::RollbackTransaction()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createTable (in string aTableName, in string aTableSchema); */
NS_IMETHODIMP _MYCLASS_::CreateTable(const char *aTableName, const char *aTableSchema)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createFunction (in string aFunctionName, in long aNumArguments, in mozIStorageFunction aFunction); */
NS_IMETHODIMP _MYCLASS_::CreateFunction(const char *aFunctionName, PRInt32 aNumArguments, mozIStorageFunction *aFunction)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void createTrigger (in string aTriggerName, in long aTriggerType, in string aTableName, in string aTriggerFunction, in string aParameters); */
NS_IMETHODIMP _MYCLASS_::CreateTrigger(const char *aTriggerName, PRInt32 aTriggerType, const char *aTableName, const char *aTriggerFunction, const char *aParameters)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeTrigger (in string aTriggerName); */
NS_IMETHODIMP _MYCLASS_::RemoveTrigger(const char *aTriggerName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_mozIStorageConnection_h__ */
