/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.LineTable;
import gnu.classpath.jdwp.util.VariableTable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class MethodCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeLineTable(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeVariableTable(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeByteCodes(byteBuffer, dataOutputStream);
                    break;
                }
                case 4: {
                    this.executeIsObsolete(byteBuffer, dataOutputStream);
                    break;
                }
                case 5: {
                    this.executeVariableTableWithGeneric(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in Method Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private void executeLineTable(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Method method = (Method)objectId.getObject();
        LineTable lineTable = VMVirtualMachine.getLineTable(clazz, method);
        lineTable.write(dataOutputStream);
    }

    private void executeVariableTable(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Method method = (Method)objectId.getObject();
        VariableTable variableTable = VMVirtualMachine.getVarTable(clazz, method);
        variableTable.write(dataOutputStream);
    }

    private void executeByteCodes(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command ByteCodes not implemented.");
    }

    private void executeIsObsolete(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(false);
    }

    private void executeVariableTableWithGeneric(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command SourceDebugExtension not implemented.");
    }
}

