/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;

public final class Buffers {
    public static DataBuffer createBuffer(int n, Object object, int n2) {
        if (object == null) {
            return Buffers.createBuffer(n, n2, 1);
        }
        return Buffers.createBufferFromData(n, object, n2);
    }

    public static DataBuffer createBuffer(int n, int n2) {
        return Buffers.createBuffer(n, n2, 1);
    }

    public static DataBuffer createBuffer(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                return new DataBufferByte(n2, n3);
            }
            case 2: {
                return new DataBufferShort(n2, n3);
            }
            case 1: {
                return new DataBufferUShort(n2, n3);
            }
            case 3: {
                return new DataBufferInt(n2, n3);
            }
            case 4: {
                return new DataBufferFloat(n2, n3);
            }
            case 5: {
                return new DataBufferDouble(n2, n3);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static DataBuffer createBufferFromData(int n, Object object, int n2) {
        switch (n) {
            case 0: {
                return new DataBufferByte((byte[])object, n2);
            }
            case 2: {
                return new DataBufferShort((short[])object, n2);
            }
            case 1: {
                return new DataBufferUShort((short[])object, n2);
            }
            case 3: {
                return new DataBufferInt((int[])object, n2);
            }
            case 4: {
                return new DataBufferFloat((float[])object, n2);
            }
            case 5: {
                return new DataBufferDouble((double[])object, n2);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Object getData(DataBuffer dataBuffer) {
        if (dataBuffer instanceof DataBufferByte) {
            return ((DataBufferByte)dataBuffer).getData();
        }
        if (dataBuffer instanceof DataBufferShort) {
            return ((DataBufferShort)dataBuffer).getData();
        }
        if (dataBuffer instanceof DataBufferUShort) {
            return ((DataBufferUShort)dataBuffer).getData();
        }
        if (dataBuffer instanceof DataBufferInt) {
            return ((DataBufferInt)dataBuffer).getData();
        }
        if (dataBuffer instanceof DataBufferFloat) {
            return ((DataBufferFloat)dataBuffer).getData();
        }
        if (dataBuffer instanceof DataBufferDouble) {
            return ((DataBufferDouble)dataBuffer).getData();
        }
        throw new ClassCastException("Unknown data buffer type");
    }

    public static Object getData(DataBuffer dataBuffer, int n, Object object, int n2, int n3) {
        Object[] objectArray;
        if (dataBuffer instanceof DataBufferByte) {
            objectArray = ((DataBufferByte)dataBuffer).getData();
            if (object == null) {
                object = new byte[n3 + n2];
            }
        } else if (dataBuffer instanceof DataBufferShort) {
            objectArray = ((DataBufferShort)dataBuffer).getData();
            if (object == null) {
                object = new short[n3 + n2];
            }
        } else if (dataBuffer instanceof DataBufferUShort) {
            objectArray = ((DataBufferUShort)dataBuffer).getData();
            if (object == null) {
                object = new short[n3 + n2];
            }
        } else if (dataBuffer instanceof DataBufferInt) {
            objectArray = ((DataBufferInt)dataBuffer).getData();
            if (object == null) {
                object = new int[n3 + n2];
            }
        } else if (dataBuffer instanceof DataBufferFloat) {
            objectArray = ((DataBufferFloat)dataBuffer).getData();
            if (object == null) {
                object = new float[n3 + n2];
            }
        } else if (dataBuffer instanceof DataBufferDouble) {
            objectArray = ((DataBufferDouble)dataBuffer).getData();
            if (object == null) {
                object = new double[n3 + n2];
            }
        } else {
            throw new ClassCastException("Unknown data buffer type");
        }
        System.arraycopy(objectArray, n, object, n2, n3);
        return object;
    }

    public static int smallestAppropriateTransferType(int n) {
        if (n <= 8) {
            return 0;
        }
        if (n <= 16) {
            return 1;
        }
        if (n <= 32) {
            return 3;
        }
        return 32;
    }
}

