/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineInputStream
extends FilterInputStream {
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private String encoding;
    private boolean eof;
    private final boolean blockReads;

    public LineInputStream(InputStream inputStream) {
        this(inputStream, "US-ASCII");
    }

    public LineInputStream(InputStream inputStream, String string) {
        super(inputStream);
        this.encoding = string;
        this.eof = false;
        this.blockReads = !(inputStream instanceof BufferedInputStream) && inputStream.markSupported();
    }

    public String readLine() throws IOException {
        if (this.eof) {
            return null;
        }
        while (true) {
            int n;
            if (this.blockReads) {
                n = 1024;
                int n2 = this.in.available();
                if (n2 == 0 || n2 > n) {
                    n2 = n;
                }
                byte[] byArray = new byte[n2];
                this.in.mark(n2);
                n2 = this.in.read(byArray, 0, n2);
                if (n2 == -1) {
                    this.eof = true;
                    if (this.buf.size() == 0) {
                        return null;
                    }
                    return this.buf.toString(this.encoding);
                }
                int n3 = this.indexOf(byArray, n2, (byte)10);
                if (n3 != -1) {
                    this.buf.write(byArray, 0, n3);
                    this.in.reset();
                    ++n3;
                    while (n3 > 0) {
                        n2 = this.in.read(byArray, 0, n3);
                        n3 = n2 == -1 ? -1 : n3 - n2;
                    }
                    String string = this.buf.toString(this.encoding);
                    this.buf.reset();
                    return string;
                }
                this.buf.write(byArray, 0, n2);
                continue;
            }
            n = this.in.read();
            switch (n) {
                case -1: {
                    this.eof = true;
                    if (this.buf.size() == 0) {
                        return null;
                    }
                }
                case 10: {
                    String string = this.buf.toString(this.encoding);
                    this.buf.reset();
                    return string;
                }
            }
            this.buf.write(n);
        }
    }

    private int indexOf(byte[] byArray, int n, byte by) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }
}

