/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.file;

import gnu.classpath.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Connection
extends URLConnection {
    private static final String DEFAULT_PERMISSION = "read";
    private File file;
    private byte[] directoryListing;
    private InputStream inputStream;
    private OutputStream outputStream;
    private FilePermission permission = new FilePermission(this.getURL().getFile(), "read");

    public Connection(URL uRL) {
        super(uRL);
    }

    public static String unquote(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        byte[] byArray = new byte[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                throw new MalformedURLException(string + " : Invalid character");
            }
            if (c == '%') {
                int n2;
                if (i + 2 >= string.length()) {
                    throw new MalformedURLException(string + " : Invalid quoted character");
                }
                int n3 = Character.digit(string.charAt(++i), 16);
                if ((n2 = Character.digit(string.charAt(++i), 16)) < 0 || n3 < 0) {
                    throw new MalformedURLException(string + " : Invalid quoted character");
                }
                byArray[n++] = (byte)(n3 * 16) + (byte)n2;
                continue;
            }
            byArray[n++] = (byte)c;
        }
        try {
            return new String(byArray, 0, n, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw (Error)new InternalError().initCause(unsupportedEncodingException);
        }
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.file = new File(Connection.unquote(this.getURL().getFile()));
        if (!this.file.isDirectory()) {
            if (this.doInput) {
                this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
            }
            if (this.doOutput) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            }
        } else {
            if (this.doInput) {
                this.inputStream = new ByteArrayInputStream(this.getDirectoryListing());
            }
            if (this.doOutput) {
                throw new ProtocolException("file: protocol does not support output on directories");
            }
        }
        this.connected = true;
    }

    byte[] getDirectoryListing() throws IOException {
        if (this.directoryListing == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            String[] stringArray = this.file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                outputStreamWriter.write(stringArray[i]);
                outputStreamWriter.write(StaticData.lineSeparator);
            }
            this.directoryListing = byteArrayOutputStream.toByteArray();
        }
        return this.directoryListing;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("Can't open OutputStream if doOutput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.outputStream;
    }

    public long getLastModified() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.file.lastModified();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public String getHeaderField(String string) {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (string.equals("content-type")) {
                return URLConnection.guessContentTypeFromName(this.file.getName());
            }
            if (string.equals("content-length")) {
                if (this.file.isDirectory()) {
                    return Integer.toString(this.getContentLength());
                }
                return Long.toString(this.file.length());
            }
            if (string.equals("last-modified")) {
                SimpleDateFormat simpleDateFormat = StaticData.dateFormat;
                synchronized (simpleDateFormat) {
                    try {
                        String string2 = StaticData.dateFormat.format(new Date(this.file.lastModified()));
                        Object var4_5 = null;
                        return string2;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        throw throwable;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string3 = null;
        return string3;
    }

    public int getContentLength() {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (this.file.isDirectory()) {
                return this.getDirectoryListing().length;
            }
            return (int)this.file.length();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public Permission getPermission() throws IOException {
        return this.permission;
    }

    private static class StaticData {
        static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'", new Locale("En", "Us", "Unix"));
        static String lineSeparator = SystemProperties.getProperty("line.separator");

        StaticData() {
        }
    }
}

