/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.LineInputStream;
import gnu.java.net.protocol.http.HTTPDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Headers
extends LinkedHashMap {
    static final DateFormat dateFormat = new HTTPDateFormat();

    public boolean containsKey(Object object) {
        return super.containsKey(new Header((String)object));
    }

    public Object get(Object object) {
        return super.get(new Header((String)object));
    }

    public String getValue(String string) {
        return (String)super.get(new Header(string));
    }

    public int getIntValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public long getLongValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public Date getDateValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return dateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Object put(Object object, Object object2) {
        return super.put(new Header((String)object), object2);
    }

    public Object remove(Object object) {
        return super.remove(new Header((String)object));
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            this.put(string, string2);
        }
    }

    public Set keySet() {
        Set set = super.keySet();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            linkedHashSet.add(((Header)iterator.next()).name);
        }
        return linkedHashSet;
    }

    public Set entrySet() {
        Set set = super.entrySet();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            linkedHashSet.add(new HeaderEntry(entry));
        }
        return linkedHashSet;
    }

    public void parse(InputStream inputStream) throws IOException {
        LineInputStream lineInputStream = inputStream instanceof LineInputStream ? (LineInputStream)inputStream : new LineInputStream(inputStream);
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            String string2;
            if ((string2 = lineInputStream.readLine()) == null) {
                if (string == null) break;
                this.addValue(string, stringBuilder.toString());
                break;
            }
            int n2 = string2.length();
            if (n2 < 2) {
                if (string == null) break;
                this.addValue(string, stringBuilder.toString());
                break;
            }
            char c = string2.charAt(0);
            if (c == ' ' || c == '\t') {
                n = n2 - 1;
                if (string2.charAt(n) != '\r') {
                    ++n;
                }
                stringBuilder.append(string2.substring(0, n));
                continue;
            }
            if (string != null) {
                this.addValue(string, stringBuilder.toString());
            }
            n = string2.indexOf(58);
            string = string2.substring(0, n);
            stringBuilder.setLength(0);
            while (++n < n2 && string2.charAt(n) == ' ') {
            }
            int n3 = n2 - 1;
            if (string2.charAt(n3) != '\r') {
                ++n3;
            }
            stringBuilder.append(string2.substring(n, n3));
        }
    }

    private void addValue(String string, String string2) {
        Header header = new Header(string);
        String string3 = (String)super.get(header);
        if (string3 == null) {
            super.put(header, string2);
        } else {
            super.put(header, string3 + ", " + string2);
        }
    }

    static class HeaderEntry
    implements Map.Entry {
        final Map.Entry entry;

        HeaderEntry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return ((Header)this.entry.getKey()).name;
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object object) {
            return this.entry.setValue(object);
        }

        public int hashCode() {
            return this.entry.hashCode();
        }

        public boolean equals(Object object) {
            return this.entry.equals(object);
        }

        public String toString() {
            return this.getKey().toString() + "=" + this.getValue();
        }
    }

    static class Header {
        final String name;

        Header(String string) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException(string);
            }
            this.name = string;
        }

        public int hashCode() {
            return this.name.toLowerCase().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Header) {
                return ((Header)object).name.equalsIgnoreCase(this.name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

