/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.der;

import gnu.java.security.der.DER;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERValue
implements DER {
    private final int tagClass;
    private final boolean constructed;
    private final int tag;
    private int length;
    private final Object value;
    private byte[] encoded;

    public DERValue(int n, int n2, Object object, byte[] byArray) {
        this.tagClass = n & 0xC0;
        this.tag = n & 0x1F;
        this.constructed = (n & 0x20) == 32;
        this.length = n2;
        this.value = object;
        if (byArray != null) {
            this.encoded = (byte[])byArray.clone();
        }
    }

    public DERValue(int n, Object object) {
        this(n, 0, object, null);
    }

    public int getExternalTag() {
        return this.tagClass | this.tag | (this.constructed ? 32 : 0);
    }

    public int getTag() {
        return this.tag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public int getLength() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.length = DERWriter.write(byteArrayOutputStream, this);
                this.encoded = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                this.encoded = new byte[0];
            }
        }
        return this.length;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValueAs(int n) throws IOException {
        byte[] byArray = this.getEncoded();
        byArray[0] = (byte)n;
        return DERReader.read(byArray).getValue();
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.length = DERWriter.write(byteArrayOutputStream, this);
                this.encoded = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                this.encoded = new byte[0];
            }
        }
        return (byte[])this.encoded.clone();
    }

    public int getEncodedLength() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.length = DERWriter.write(byteArrayOutputStream, this);
                this.encoded = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                this.encoded = new byte[0];
            }
        }
        return this.encoded.length;
    }

    public String toString() {
        return "DERValue [ tag=" + this.tag + ", class=" + this.tagClass + ", constructed=" + this.constructed + ", value=" + this.value + " ]";
    }
}

