/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.provider.GnuDSAPrivateKey;
import gnu.java.security.provider.GnuDSAPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class DSAKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof DSAPrivateKeySpec)) {
            throw new InvalidKeySpecException();
        }
        return new GnuDSAPrivateKey(((DSAPrivateKeySpec)keySpec).getX(), ((DSAPrivateKeySpec)keySpec).getP(), ((DSAPrivateKeySpec)keySpec).getQ(), ((DSAPrivateKeySpec)keySpec).getG());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof DSAPublicKeySpec)) {
            throw new InvalidKeySpecException();
        }
        return new GnuDSAPublicKey(((DSAPublicKeySpec)keySpec).getY(), ((DSAPublicKeySpec)keySpec).getP(), ((DSAPublicKeySpec)keySpec).getQ(), ((DSAPublicKeySpec)keySpec).getG());
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof DSAPublicKey && clazz.isAssignableFrom(DSAKeyFactory.class$("java.security.spec.DSAPublicKeySpec"))) {
            return new DSAPublicKeySpec(((DSAPublicKey)key).getY(), ((DSAPublicKey)key).getParams().getP(), ((DSAPublicKey)key).getParams().getQ(), ((DSAPublicKey)key).getParams().getG());
        }
        if (key instanceof DSAPrivateKey && clazz.isAssignableFrom(DSAKeyFactory.class$("java.security.spec.DSAPrivateKeySpec"))) {
            return new DSAPrivateKeySpec(((DSAPrivateKey)key).getX(), ((DSAPrivateKey)key).getParams().getP(), ((DSAPrivateKey)key).getParams().getQ(), ((DSAPrivateKey)key).getParams().getG());
        }
        throw new InvalidKeySpecException();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof GnuDSAPublicKey || key instanceof GnuDSAPrivateKey) {
            return key;
        }
        if (key instanceof DSAPublicKey) {
            return new GnuDSAPublicKey(((DSAPublicKey)key).getY(), ((DSAPublicKey)key).getParams().getP(), ((DSAPublicKey)key).getParams().getQ(), ((DSAPublicKey)key).getParams().getG());
        }
        if (key instanceof DSAPrivateKey) {
            return new GnuDSAPrivateKey(((DSAPrivateKey)key).getX(), ((DSAPrivateKey)key).getParams().getP(), ((DSAPrivateKey)key).getParams().getQ(), ((DSAPrivateKey)key).getParams().getG());
        }
        throw new InvalidKeyException();
    }
}

