/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.provider.GnuDHPublicKey;
import gnu.java.security.provider.GnuDSAPrivateKey;
import gnu.java.security.provider.GnuDSAPublicKey;
import gnu.java.security.provider.GnuRSAPrivateKey;
import gnu.java.security.provider.GnuRSAPublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;

public class EncodedKeyFactory
extends KeyFactorySpi {
    private static final OID ID_DSA = new OID("1.2.840.10040.4.1");
    private static final OID ID_RSA = new OID("1.2.840.113549.1.1.1");
    private static final OID ID_DH = new OID("1.2.840.10046.2.1");

    public PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof X509EncodedKeySpec)) {
            throw new InvalidKeySpecException("only supports X.509 key specs");
        }
        DERReader dERReader = new DERReader(((X509EncodedKeySpec)keySpec).getEncoded());
        try {
            DERValue dERValue = dERReader.read();
            if (!dERValue.isConstructed()) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            DERValue dERValue2 = dERReader.read();
            if (!dERValue2.isConstructed()) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            DERValue dERValue3 = dERReader.read();
            if (!(dERValue3.getValue() instanceof OID)) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            OID oID = (OID)dERValue3.getValue();
            byte[] byArray = null;
            if (dERValue2.getLength() > dERValue3.getEncodedLength()) {
                dERValue3 = dERReader.read();
                byArray = dERValue3.getEncoded();
                if (dERValue3.isConstructed()) {
                    dERReader.skip(dERValue3.getLength());
                }
            }
            if (!((dERValue3 = dERReader.read()).getValue() instanceof BitString)) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            byte[] byArray2 = ((BitString)dERValue3.getValue()).toByteArray();
            if (oID.equals(ID_DSA)) {
                DERReader dERReader2;
                BigInteger bigInteger = null;
                BigInteger bigInteger2 = null;
                BigInteger bigInteger3 = null;
                if (byArray != null) {
                    dERReader2 = new DERReader(byArray);
                    dERValue3 = dERReader2.read();
                    if (!dERValue3.isConstructed()) {
                        throw new InvalidKeySpecException("malformed DSA parameters");
                    }
                    dERValue3 = dERReader2.read();
                    if (!(dERValue3.getValue() instanceof BigInteger)) {
                        throw new InvalidKeySpecException("malformed DSA parameters");
                    }
                    bigInteger = (BigInteger)dERValue3.getValue();
                    dERValue3 = dERReader2.read();
                    if (!(dERValue3.getValue() instanceof BigInteger)) {
                        throw new InvalidKeySpecException("malformed DSA parameters");
                    }
                    bigInteger3 = (BigInteger)dERValue3.getValue();
                    dERValue3 = dERReader2.read();
                    if (!(dERValue3.getValue() instanceof BigInteger)) {
                        throw new InvalidKeySpecException("malformed DSA parameters");
                    }
                    bigInteger2 = (BigInteger)dERValue3.getValue();
                }
                if (!((dERValue3 = (dERReader2 = new DERReader(byArray2)).read()).getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DSA parameters");
                }
                BigInteger bigInteger4 = (BigInteger)dERValue3.getValue();
                return new GnuDSAPublicKey(bigInteger4, bigInteger, bigInteger3, bigInteger2);
            }
            if (oID.equals(ID_RSA)) {
                DERReader dERReader3 = new DERReader(byArray2);
                if (!dERReader3.read().isConstructed()) {
                    throw new InvalidKeySpecException("malformed encoded key");
                }
                return new GnuRSAPublicKey(new RSAPublicKeySpec((BigInteger)dERReader3.read().getValue(), (BigInteger)dERReader3.read().getValue()));
            }
            if (oID.equals(ID_DH)) {
                if (byArray == null) {
                    throw new InvalidKeySpecException("missing DH parameters");
                }
                DERReader dERReader4 = new DERReader(byArray);
                dERValue3 = dERReader4.read();
                if (!dERValue3.isConstructed()) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                dERValue3 = dERReader4.read();
                if (!(dERValue3.getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                BigInteger bigInteger = (BigInteger)dERValue3.getValue();
                dERValue3 = dERReader4.read();
                if (!(dERValue3.getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                BigInteger bigInteger5 = (BigInteger)dERValue3.getValue();
                dERValue3 = dERReader4.read();
                if (!(dERValue3.getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                BigInteger bigInteger6 = (BigInteger)dERValue3.getValue();
                DERReader dERReader5 = new DERReader(byArray2);
                dERValue3 = dERReader5.read();
                if (!(dERValue3.getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                BigInteger bigInteger7 = (BigInteger)dERValue3.getValue();
                return new GnuDHPublicKey(new DHParameterSpec(bigInteger, bigInteger5), bigInteger7, bigInteger6);
            }
            throw new InvalidKeySpecException("unknown algorithm: " + oID);
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(iOException.getMessage());
        }
    }

    public PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PKCS8EncodedKeySpec)) {
            throw new InvalidKeySpecException("only supports PKCS8 key specs");
        }
        DERReader dERReader = new DERReader(((PKCS8EncodedKeySpec)keySpec).getEncoded());
        try {
            DERValue dERValue = dERReader.read();
            if (!dERValue.isConstructed()) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            DERValue dERValue2 = dERReader.read();
            if (!(dERValue2.getValue() instanceof BigInteger)) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            DERValue dERValue3 = dERReader.read();
            if (!dERValue3.isConstructed()) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            dERValue2 = dERReader.read();
            if (!(dERValue2.getValue() instanceof OID)) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            OID oID = (OID)dERValue2.getValue();
            byte[] byArray = null;
            if (dERValue3.getLength() > dERValue2.getEncodedLength()) {
                dERValue2 = dERReader.read();
                byArray = dERValue2.getEncoded();
                if (dERValue2.isConstructed()) {
                    dERReader.skip(dERValue2.getLength());
                }
            }
            byte[] byArray2 = (byte[])dERReader.read().getValue();
            if (oID.equals(ID_DSA)) {
                if (byArray == null) {
                    throw new InvalidKeySpecException("missing DSA parameters");
                }
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DSA");
                algorithmParameters.init(byArray);
                DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(EncodedKeyFactory.class$("java.security.spec.DSAParameterSpec"));
                DERReader dERReader2 = new DERReader(byArray2);
                return new GnuDSAPrivateKey((BigInteger)dERReader2.read().getValue(), dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG());
            }
            if (oID.equals(ID_RSA)) {
                DERReader dERReader3 = new DERReader(byArray2);
                if (!dERReader3.read().isConstructed()) {
                    throw new InvalidKeySpecException("malformed encoded key");
                }
                return new GnuRSAPrivateKey(new RSAPrivateCrtKeySpec((BigInteger)dERReader3.read().getValue(), (BigInteger)dERReader3.read().getValue(), (BigInteger)dERReader3.read().getValue(), (BigInteger)dERReader3.read().getValue(), (BigInteger)dERReader3.read().getValue(), (BigInteger)dERReader3.read().getValue(), (BigInteger)dERReader3.read().getValue(), (BigInteger)dERReader3.read().getValue()));
            }
            throw new InvalidKeySpecException("unknown algorithm: " + oID);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeySpecException(noSuchAlgorithmException.getMessage());
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException(iOException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof PrivateKey && key.getFormat().equals("PKCS#8") && clazz.isAssignableFrom(EncodedKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec"))) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (key instanceof PublicKey && key.getFormat().equals("X.509") && clazz.isAssignableFrom(EncodedKeyFactory.class$("java.security.spec.X509EncodedKeySpec"))) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        throw new InvalidKeySpecException();
    }

    public Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("translating keys not supported");
    }
}

