/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERValue;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class GnuDHPublicKey
implements DHPublicKey {
    private byte[] encoded;
    private final DHParameterSpec params;
    private final BigInteger Y;
    private final BigInteger q;

    public GnuDHPublicKey(DHParameterSpec dHParameterSpec, BigInteger bigInteger, BigInteger bigInteger2) {
        this.params = dHParameterSpec;
        this.Y = bigInteger;
        this.q = bigInteger2;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public DHParameterSpec getParams() {
        return this.params;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        ArrayList arrayList = new ArrayList(2);
        ArrayList arrayList2 = new ArrayList(2);
        arrayList2.add(new DERValue(6, new OID("1.2.840.10046.2.1")));
        ArrayList arrayList3 = new ArrayList(3);
        arrayList3.add(new DERValue(2, this.params.getP()));
        arrayList3.add(new DERValue(2, this.params.getG()));
        arrayList3.add(new DERValue(2, this.q));
        arrayList2.add(new DERValue(48, arrayList3));
        arrayList.add(new DERValue(48, arrayList2));
        arrayList.add(new DERValue(3, new BitString(this.Y.toByteArray())));
        this.encoded = new DERValue(48, arrayList).getEncoded();
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        return null;
    }
}

