/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;

public abstract class RSA
extends SignatureSpi
implements Cloneable {
    protected static final OID DIGEST_ALGORITHM = new OID("1.2.840.113549.2");
    protected final OID digestAlgorithm;
    protected final MessageDigest md;
    protected RSAPrivateKey signerKey;
    protected RSAPublicKey verifierKey;

    protected RSA(MessageDigest messageDigest, OID oID) {
        this.md = messageDigest;
        this.digestAlgorithm = oID;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("deprecated");
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("deprecated");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.verifierKey = null;
        this.signerKey = (RSAPrivateKey)privateKey;
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.signerKey = null;
        this.verifierKey = (RSAPublicKey)publicKey;
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.signerKey == null && this.verifierKey == null) {
            throw new SignatureException("not initialized");
        }
        this.md.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.signerKey == null && this.verifierKey == null) {
            throw new SignatureException("not initialized");
        }
        this.md.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.signerKey == null) {
            throw new SignatureException("not initialized for signing");
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new DERValue(6, this.digestAlgorithm));
        arrayList.add(new DERValue(5, null));
        ArrayList arrayList2 = new ArrayList(2);
        arrayList2.add(new DERValue(16, arrayList));
        arrayList2.add(new DERValue(4, this.md.digest()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DERWriter.write(byteArrayOutputStream, new DERValue(16, arrayList2));
        }
        catch (IOException iOException) {
            throw new SignatureException(iOException.toString());
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.md.reset();
        int n = this.signerKey.getModulus().bitLength();
        n = (n >>> 3) + ((n & 7) == 0 ? 0 : 1);
        if (byArray.length < n - 3) {
            throw new SignatureException("RSA modulus too small");
        }
        byte[] byArray2 = new byte[n];
        byArray2[1] = 1;
        for (int i = 2; i < n - byArray.length - 1; ++i) {
            byArray2[i] = -1;
        }
        System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        BigInteger bigInteger = new BigInteger(byArray2);
        byte[] byArray3 = bigInteger.modPow(this.signerKey.getPrivateExponent(), this.signerKey.getModulus()).toByteArray();
        if (byArray3.length < n) {
            byte[] byArray4 = new byte[n];
            System.arraycopy(bigInteger, 0, byArray4, n - byArray3.length, byArray3.length);
            byArray3 = byArray4;
        } else if (byArray3.length > n) {
            if (byArray3.length != n + 1) {
                throw new SignatureException("modPow result is larger than the modulus");
            }
            byte[] byArray5 = new byte[n];
            System.arraycopy(byArray3, 1, byArray5, 0, n);
            byArray3 = byArray5;
        }
        return byArray3;
    }

    protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        if (byArray == null || n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new SignatureException("illegal output argument");
        }
        byte[] byArray2 = this.engineSign();
        if (byArray2.length > n2) {
            throw new SignatureException("not enough space for signature");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        int n;
        if (this.verifierKey == null) {
            throw new SignatureException("not initialized for verifying");
        }
        if (byArray == null) {
            throw new SignatureException("no signature specified");
        }
        if (byArray.length != (n = (n >>> 3) + (((n = this.verifierKey.getModulus().bitLength()) & 7) == 0 ? 0 : 1))) {
            throw new SignatureException("signature is the wrong size (expecting " + n + " bytes, got " + byArray.length + ")");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        byte[] byArray2 = bigInteger.modPow(this.verifierKey.getPublicExponent(), this.verifierKey.getModulus()).toByteArray();
        int n2 = 0;
        if (byArray2[0] == 0) {
            for (n2 = 1; n2 < byArray2.length && byArray2[n2] == 0; ++n2) {
            }
            if (n2 == 1) {
                throw new SignatureException("wrong RSA padding");
            }
            --n2;
        } else if (byArray2[0] == 1) {
            for (n2 = 1; n2 < byArray2.length && byArray2[n2] != 0; ++n2) {
                if (byArray2[n2] == -1) continue;
                throw new IllegalArgumentException("wrong RSA padding");
            }
        } else {
            throw new SignatureException("wrong RSA padding type");
        }
        byte[] byArray3 = new byte[byArray2.length - n2 - 1];
        System.arraycopy(byArray2, n2 + 1, byArray3, 0, byArray2.length - n2 - 1);
        DERReader dERReader = new DERReader(byArray3);
        try {
            DERValue dERValue = dERReader.read();
            if (dERValue.getTag() != 16) {
                throw new SignatureException("failed to parse DigestInfo");
            }
            dERValue = dERReader.read();
            if (dERValue.getTag() != 16) {
                throw new SignatureException("failed to parse DigestAlgorithmIdentifier");
            }
            boolean bl = dERValue.getLength() == 0;
            dERValue = dERReader.read();
            if (dERValue.getTag() != 6) {
                throw new SignatureException("failed to parse object identifier");
            }
            if (!dERValue.getValue().equals(this.digestAlgorithm)) {
                throw new SignatureException("digest algorithms do not match");
            }
            dERValue = dERReader.read();
            if (dERValue.getTag() != 5) {
                throw new SignatureException("cannot handle digest parameters");
            }
            if (bl) {
                dERReader.skip(1);
            }
            if ((dERValue = dERReader.read()).getTag() != 4) {
                throw new SignatureException("failed to parse Digest");
            }
            return MessageDigest.isEqual(this.md.digest(), (byte[])dERValue.getValue());
        }
        catch (IOException iOException) {
            throw new SignatureException(iOException.toString());
        }
    }

    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        if (byArray == null || n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new SignatureException("illegal parameter");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.engineVerify(byArray2);
    }
}

