/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.provider.EncodedKeyFactory;
import gnu.java.security.provider.GnuRSAPrivateKey;
import gnu.java.security.provider.GnuRSAPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        EncodedKeyFactory encodedKeyFactory;
        PrivateKey privateKey;
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new GnuRSAPrivateKey((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new GnuRSAPrivateKey(new RSAPrivateCrtKeySpec(((RSAPrivateKeySpec)keySpec).getModulus(), null, ((RSAPrivateKeySpec)keySpec).getPrivateExponent(), null, null, null, null, null));
        }
        if (keySpec instanceof PKCS8EncodedKeySpec && (privateKey = (encodedKeyFactory = new EncodedKeyFactory()).engineGeneratePrivate(keySpec)) instanceof RSAPrivateKey) {
            return privateKey;
        }
        throw new InvalidKeySpecException();
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        EncodedKeyFactory encodedKeyFactory;
        PublicKey publicKey;
        if (keySpec instanceof RSAPublicKeySpec) {
            return new GnuRSAPublicKey((RSAPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec && (publicKey = (encodedKeyFactory = new EncodedKeyFactory()).engineGeneratePublic(keySpec)) instanceof RSAPublicKey) {
            return publicKey;
        }
        throw new InvalidKeySpecException();
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(RSAKeyFactory.class$("java.security.spec.RSAPrivateCrtKeySpec")) && key instanceof RSAPrivateCrtKey) {
            return new RSAPrivateCrtKeySpec(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient());
        }
        if (clazz.isAssignableFrom(RSAKeyFactory.class$("java.security.spec.RSAPrivateKeySpec")) && key instanceof RSAPrivateKey) {
            return new RSAPrivateKeySpec(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPrivateExponent());
        }
        if (clazz.isAssignableFrom(RSAKeyFactory.class$("java.security.spec.RSAPublicKeySpec")) && key instanceof RSAPublicKey) {
            return new RSAPublicKeySpec(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent());
        }
        if (clazz.isAssignableFrom(RSAKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")) && key.getFormat().equalsIgnoreCase("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.isAssignableFrom(RSAKeyFactory.class$("java.security.spec.X509EncodedKeySpec")) && key.getFormat().equalsIgnoreCase("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        throw new InvalidKeySpecException();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPrivateCrtKey) {
            return new GnuRSAPrivateKey(new RSAPrivateCrtKeySpec(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent(), ((RSAPrivateCrtKey)key).getPrivateExponent(), ((RSAPrivateCrtKey)key).getPrimeP(), ((RSAPrivateCrtKey)key).getPrimeQ(), ((RSAPrivateCrtKey)key).getPrimeExponentP(), ((RSAPrivateCrtKey)key).getPrimeExponentQ(), ((RSAPrivateCrtKey)key).getCrtCoefficient()));
        }
        if (key instanceof RSAPrivateKey) {
            return new GnuRSAPrivateKey(new RSAPrivateCrtKeySpec(((RSAPrivateKey)key).getModulus(), null, ((RSAPrivateKey)key).getPrivateExponent(), null, null, null, null, null));
        }
        if (key instanceof RSAPublicKey) {
            return new GnuRSAPublicKey(new RSAPublicKeySpec(((RSAPrivateCrtKey)key).getModulus(), ((RSAPrivateCrtKey)key).getPublicExponent()));
        }
        throw new InvalidKeyException();
    }
}

