/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;
import java.util.Random;

public class SHA1PRNG
extends SecureRandomSpi
implements Serializable {
    MessageDigest digest;
    byte[] seed;
    byte[] data;
    int seedpos;
    int datapos;
    private boolean seeded;
    private static final int SEED_SIZE = 20;
    private static final int DATA_SIZE = 40;

    private /* synthetic */ void finit$() {
        this.seeded = false;
    }

    public SHA1PRNG() {
        this.finit$();
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("no SHA implementation found");
        }
        this.seed = new byte[20];
        this.seedpos = 0;
        this.data = new byte[40];
        this.datapos = 20;
    }

    public void engineSetSeed(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = this.seedpos++ % 20;
            this.seed[n] = this.seed[n] ^ byArray[i];
        }
        this.seedpos %= 20;
    }

    public void engineNextBytes(byte[] byArray) {
        this.ensureIsSeeded();
        int n = 0;
        while (n < byArray.length) {
            int n2 = Math.min(byArray.length - n, 20 - this.datapos);
            if (n2 > 0) {
                System.arraycopy(this.data, this.datapos, byArray, n, n2);
                this.datapos += n2;
                n += n2;
                continue;
            }
            System.arraycopy(this.seed, 0, this.data, 20, 20);
            byte[] byArray2 = this.digest.digest(this.data);
            System.arraycopy(byArray2, 0, this.data, 0, 20);
            this.datapos = 0;
        }
    }

    public byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }

    private void ensureIsSeeded() {
        if (!this.seeded) {
            new Random(0L).nextBytes(this.seed);
            byte[] byArray = this.digest.digest(this.data);
            System.arraycopy(byArray, 0, this.data, 0, 20);
            this.seeded = true;
        }
    }
}

