/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class DiffieHellmanImpl
extends KeyAgreementSpi {
    private DHPrivateKey key = null;
    private BigInteger result = null;
    private boolean last_phase_done = false;

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException {
        if (this.key == null) {
            throw new IllegalStateException("not initialized");
        }
        if (this.last_phase_done) {
            throw new IllegalStateException("last phase already done");
        }
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("expecting javax.crypto.interfaces.DHPublicKey");
        }
        DHPublicKey dHPublicKey = (DHPublicKey)key;
        DHParameterSpec dHParameterSpec = this.key.getParams();
        DHParameterSpec dHParameterSpec2 = dHPublicKey.getParams();
        if (!dHParameterSpec.getG().equals(dHParameterSpec2.getG()) || !dHParameterSpec.getP().equals(dHParameterSpec2.getP()) || dHParameterSpec.getL() != dHParameterSpec2.getL()) {
            throw new InvalidKeyException("supplied key is not compatible");
        }
        this.result = dHPublicKey.getY().modPow(this.key.getX(), dHParameterSpec.getP());
        if (bl) {
            this.last_phase_done = true;
            return null;
        }
        throw new IllegalArgumentException("only supports two-party Diffie Hellman");
    }

    protected byte[] engineGenerateSecret() {
        if (this.result == null || !this.last_phase_done) {
            throw new IllegalStateException("not finished");
        }
        byte[] byArray = this.result.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    protected int engineGenerateSecret(byte[] byArray, int n) {
        byte[] byArray2 = this.engineGenerateSecret();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected SecretKey engineGenerateSecret(String string) throws InvalidKeyException {
        byte[] byArray = this.engineGenerateSecret();
        return new SecretKeySpec(byArray, string);
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("not a javax.crypto.interfaces.DHPrivateKey");
        }
        this.key = (DHPrivateKey)key;
        this.result = null;
        this.last_phase_done = false;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(key, secureRandom);
    }
}

