/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class BMPImageReaderSpi
extends ImageReaderSpi {
    static final String vendorName = "GNU";
    static final String version = "0.1";
    static final String readerClassName = "gnu.javax.imageio.bmp.BMPImageReader";
    static final String[] names;
    static final String[] suffixes;
    static final String[] MIMETypes;
    static final String[] writerSpiNames;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName;
    static final String nativeImageMetadataFormatClassName;
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;

    public BMPImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public String getDescription(Locale locale) {
        return "Microsoft BMP v3";
    }

    public boolean canDecodeInput(Object object) throws IOException {
        boolean bl;
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            new BMPFileHeader(imageInputStream);
            bl = true;
        }
        catch (BMPException bMPException) {
            bl = false;
        }
        imageInputStream.reset();
        return bl;
    }

    public ImageReader createReaderInstance(Object object) {
        return new BMPImageReader(this);
    }

    static {
        vendorName = vendorName;
        version = version;
        readerClassName = readerClassName;
        names = new String[]{"Microsoft Windows BMP"};
        suffixes = new String[]{".bmp", ".bm"};
        MIMETypes = new String[]{"image/bmp", "image/x-windows-bmp"};
        writerSpiNames = null;
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = null;
        extraStreamMetadataFormatClassNames = null;
        nativeImageMetadataFormatName = null;
        nativeImageMetadataFormatClassName = null;
        extraImageMetadataFormatNames = null;
        extraImageMetadataFormatClassNames = null;
    }
}

