/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import java.io.Serializable;

class CharIndexedString
implements CharIndexed,
Serializable {
    private String s;
    private int anchor;
    private int len;

    CharIndexedString(String string, int n) {
        this.s = string;
        this.len = this.s.length();
        this.anchor = n;
    }

    public char charAt(int n) {
        int n2 = this.anchor + n;
        if (n2 < this.len && n2 >= 0) {
            return this.s.charAt(n2);
        }
        return '\uffff';
    }

    public boolean isValid() {
        return this.anchor < this.len;
    }

    public boolean move(int n) {
        return (this.anchor += n) < this.len;
    }

    public CharIndexed lookBehind(int n, int n2) {
        if (n2 > this.anchor + n) {
            n2 = this.anchor + n;
        }
        return new CharIndexedString(this.s, this.anchor + n - n2);
    }

    public int length() {
        return this.len - this.anchor;
    }
}

