/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.CharIndexedCharArray;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import gnu.regexp.RETokenPOSIX;

final class RETokenNamedProperty
extends REToken {
    String name;
    boolean insens;
    boolean negate;
    Handler handler;
    static final byte[] LETTER = new byte[]{2, 1, 3, 4, 5};
    static final byte[] MARK = new byte[]{6, 8, 7};
    static final byte[] SEPARATOR = new byte[]{12, 13, 14};
    static final byte[] SYMBOL = new byte[]{25, 26, 27, 28};
    static final byte[] NUMBER = new byte[]{9, 10, 11};
    static final byte[] PUNCTUATION = new byte[]{20, 21, 22, 23, 24, 29, 30};
    static final byte[] OTHER = new byte[]{15, 16, 18, 19, 0};

    RETokenNamedProperty(int n, String string, boolean bl, boolean bl2) throws REException {
        super(n);
        this.name = string;
        this.insens = bl;
        this.negate = bl2;
        this.handler = this.getHandler(string);
    }

    int getMinimumLength() {
        return 1;
    }

    int getMaximumLength() {
        return 1;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        char c = charIndexed.charAt(rEMatch.index);
        if (c == '\uffff') {
            return false;
        }
        boolean bl = this.handler.includes(c);
        if (this.insens) {
            boolean bl2 = bl = bl || this.handler.includes(Character.toUpperCase(c)) || this.handler.includes(Character.toLowerCase(c));
        }
        if (this.negate) {
            bl ^= true;
        }
        if (bl) {
            ++rEMatch.index;
            return this.next(charIndexed, rEMatch);
        }
        return false;
    }

    void dump(StringBuffer stringBuffer) {
        stringBuffer.append("\\").append(this.negate ? "P" : "p").append("{" + this.name + "}");
    }

    private Handler getHandler(String string) throws REException {
        if (string.equals("Lower") || string.equals("Upper") || string.equals("Alpha") || string.equals("Digit") || string.equals("Alnum") || string.equals("Punct") || string.equals("Graph") || string.equals("Print") || string.equals("Blank") || string.equals("Cntrl") || string.equals("XDigit") || string.equals("Space")) {
            return new POSIXHandler(string);
        }
        if (string.startsWith("In")) {
            try {
                string = string.substring(2);
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.forName(string);
                return new UnicodeBlockHandler(unicodeBlock);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new REException("Invalid Unicode block name: " + string, 10, 0);
            }
        }
        if (string.startsWith("Is")) {
            string = string.substring(2);
        }
        if (string.equals("L")) {
            return new UnicodeCategoriesHandler(LETTER);
        }
        if (string.equals("M")) {
            return new UnicodeCategoriesHandler(MARK);
        }
        if (string.equals("Z")) {
            return new UnicodeCategoriesHandler(SEPARATOR);
        }
        if (string.equals("S")) {
            return new UnicodeCategoriesHandler(SYMBOL);
        }
        if (string.equals("N")) {
            return new UnicodeCategoriesHandler(NUMBER);
        }
        if (string.equals("P")) {
            return new UnicodeCategoriesHandler(PUNCTUATION);
        }
        if (string.equals("C")) {
            return new UnicodeCategoriesHandler(OTHER);
        }
        if (string.equals("Mc")) {
            return new UnicodeCategoryHandler(8);
        }
        if (string.equals("Pc")) {
            return new UnicodeCategoryHandler(23);
        }
        if (string.equals("Cc")) {
            return new UnicodeCategoryHandler(15);
        }
        if (string.equals("Sc")) {
            return new UnicodeCategoryHandler(26);
        }
        if (string.equals("Pd")) {
            return new UnicodeCategoryHandler(20);
        }
        if (string.equals("Nd")) {
            return new UnicodeCategoryHandler(9);
        }
        if (string.equals("Me")) {
            return new UnicodeCategoryHandler(7);
        }
        if (string.equals("Pe")) {
            return new UnicodeCategoryHandler(22);
        }
        if (string.equals("Pf")) {
            return new UnicodeCategoryHandler(30);
        }
        if (string.equals("Cf")) {
            return new UnicodeCategoryHandler(16);
        }
        if (string.equals("Pi")) {
            return new UnicodeCategoryHandler(29);
        }
        if (string.equals("Nl")) {
            return new UnicodeCategoryHandler(10);
        }
        if (string.equals("Zl")) {
            return new UnicodeCategoryHandler(13);
        }
        if (string.equals("Ll")) {
            return new UnicodeCategoryHandler(2);
        }
        if (string.equals("Sm")) {
            return new UnicodeCategoryHandler(25);
        }
        if (string.equals("Lm")) {
            return new UnicodeCategoryHandler(4);
        }
        if (string.equals("Sk")) {
            return new UnicodeCategoryHandler(27);
        }
        if (string.equals("Mn")) {
            return new UnicodeCategoryHandler(6);
        }
        if (string.equals("Lo")) {
            return new UnicodeCategoryHandler(5);
        }
        if (string.equals("No")) {
            return new UnicodeCategoryHandler(11);
        }
        if (string.equals("Po")) {
            return new UnicodeCategoryHandler(24);
        }
        if (string.equals("So")) {
            return new UnicodeCategoryHandler(28);
        }
        if (string.equals("Zp")) {
            return new UnicodeCategoryHandler(14);
        }
        if (string.equals("Co")) {
            return new UnicodeCategoryHandler(18);
        }
        if (string.equals("Zs")) {
            return new UnicodeCategoryHandler(12);
        }
        if (string.equals("Ps")) {
            return new UnicodeCategoryHandler(21);
        }
        if (string.equals("Cs")) {
            return new UnicodeCategoryHandler(19);
        }
        if (string.equals("Lt")) {
            return new UnicodeCategoryHandler(3);
        }
        if (string.equals("Cn")) {
            return new UnicodeCategoryHandler(0);
        }
        if (string.equals("Lu")) {
            return new UnicodeCategoryHandler(1);
        }
        throw new REException("unsupported name " + string, 10, 0);
    }

    private static class UnicodeBlockHandler
    extends Handler {
        private Character.UnicodeBlock block;

        public UnicodeBlockHandler(Character.UnicodeBlock unicodeBlock) {
            this.block = unicodeBlock;
        }

        public boolean includes(char c) {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
            return unicodeBlock != null && unicodeBlock.equals(this.block);
        }
    }

    private static class UnicodeCategoriesHandler
    extends Handler {
        private byte[] categories;

        public UnicodeCategoriesHandler(byte[] byArray) {
            this.categories = byArray;
        }

        public boolean includes(char c) {
            int n = Character.getType(c);
            for (int i = 0; i < this.categories.length; ++i) {
                if (n != this.categories[i]) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnicodeCategoryHandler
    extends Handler {
        private int category;

        public UnicodeCategoryHandler(byte by) {
            this.category = by;
        }

        public boolean includes(char c) {
            return Character.getType(c) == this.category;
        }
    }

    private static class POSIXHandler
    extends Handler {
        private RETokenPOSIX retoken;
        private REMatch mymatch;
        private char[] chars;
        private CharIndexedCharArray ca;

        private /* synthetic */ void finit$() {
            this.mymatch = new REMatch(0, 0, 0);
            this.chars = new char[1];
            this.ca = new CharIndexedCharArray(this.chars, 0);
        }

        public POSIXHandler(String string) {
            this.finit$();
            int n = RETokenPOSIX.intValue(string.toLowerCase());
            if (n == -1) {
                throw new RuntimeException("Unknown posix ID: " + string);
            }
            this.retoken = new RETokenPOSIX(0, n, false, false);
        }

        public boolean includes(char c) {
            this.chars[0] = c;
            this.mymatch.index = 0;
            return this.retoken.match(this.ca, this.mymatch);
        }
    }

    private static abstract class Handler {
        public abstract boolean includes(char var1);

        Handler() {
        }
    }
}

