/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class RETokenPOSIX
extends REToken {
    int type;
    boolean insens;
    boolean negated;
    static final int ALNUM = 0;
    static final int ALPHA = 1;
    static final int BLANK = 2;
    static final int CNTRL = 3;
    static final int DIGIT = 4;
    static final int GRAPH = 5;
    static final int LOWER = 6;
    static final int PRINT = 7;
    static final int PUNCT = 8;
    static final int SPACE = 9;
    static final int UPPER = 10;
    static final int XDIGIT = 11;
    static final String[] s_nameTable = new String[]{"alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit"};

    static int intValue(String string) {
        for (int i = 0; i < s_nameTable.length; ++i) {
            if (!s_nameTable[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    RETokenPOSIX(int n, int n2, boolean bl, boolean bl2) {
        super(n);
        this.type = n2;
        this.insens = bl;
        this.negated = bl2;
    }

    int getMinimumLength() {
        return 1;
    }

    int getMaximumLength() {
        return 1;
    }

    boolean match(CharIndexed charIndexed, REMatch rEMatch) {
        char c = charIndexed.charAt(rEMatch.index);
        if (c == '\uffff') {
            return false;
        }
        boolean bl = false;
        switch (this.type) {
            case 0: {
                bl = Character.isLetterOrDigit(c) || c == '_';
                break;
            }
            case 1: {
                bl = Character.isLetter(c);
                break;
            }
            case 2: {
                bl = c == ' ' || c == '\t';
                break;
            }
            case 3: {
                bl = Character.isISOControl(c);
                break;
            }
            case 4: {
                bl = Character.isDigit(c);
                break;
            }
            case 5: {
                bl = !Character.isWhitespace(c) && !Character.isISOControl(c);
                break;
            }
            case 6: {
                bl = this.insens && Character.isLetter(c) || Character.isLowerCase(c);
                break;
            }
            case 7: {
                bl = !Character.isWhitespace(c) && !Character.isISOControl(c) || c == ' ';
                break;
            }
            case 8: {
                bl = "`~!@#$%^&*()-_=+[]{}\\|;:'\"/?,.<>".indexOf(c) != -1;
                break;
            }
            case 9: {
                bl = Character.isWhitespace(c);
                break;
            }
            case 10: {
                bl = this.insens && Character.isLetter(c) || Character.isUpperCase(c);
                break;
            }
            case 11: {
                boolean bl2 = bl = Character.isDigit(c) || "abcdefABCDEF".indexOf(c) != -1;
            }
        }
        if (this.negated) {
            bl ^= true;
        }
        if (bl) {
            ++rEMatch.index;
            return this.next(charIndexed, rEMatch);
        }
        return false;
    }

    void dump(StringBuffer stringBuffer) {
        if (this.negated) {
            stringBuffer.append('^');
        }
        stringBuffer.append("[:" + s_nameTable[this.type] + ":]");
    }
}

