/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.aelfred2;

import gnu.xml.aelfred2.ContentHandler2;
import gnu.xml.aelfred2.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public final class SAXDriver
implements Locator,
Attributes2,
XMLReader,
Parser,
AttributeList {
    private final DefaultHandler2 base;
    private XmlParser parser;
    private EntityResolver entityResolver;
    private EntityResolver2 resolver2;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;
    private DeclHandler declHandler;
    private LexicalHandler lexicalHandler;
    private String elementName;
    private Stack entityStack;
    private List attributesList;
    private boolean namespaces;
    private boolean xmlNames;
    private boolean extGE;
    private boolean extPE;
    private boolean resolveAll;
    private boolean useResolver2;
    boolean stringInterning;
    private int attributeCount;
    private boolean attributes;
    private String[] nsTemp;
    private NamespaceSupport prefixStack;
    static final String FEATURE = "http://xml.org/sax/features/";
    static final String PROPERTY = "http://xml.org/sax/properties/";

    private /* synthetic */ void finit$() {
        this.base = new DefaultHandler2();
        this.entityResolver = this.base;
        this.resolver2 = null;
        this.contentHandler = this.base;
        this.dtdHandler = this.base;
        this.errorHandler = this.base;
        this.declHandler = this.base;
        this.lexicalHandler = this.base;
        this.namespaces = true;
        this.xmlNames = false;
        this.extGE = true;
        this.extPE = true;
        this.resolveAll = true;
        this.useResolver2 = true;
        this.stringInterning = true;
    }

    public SAXDriver() {
        this.finit$();
        this.reset();
    }

    private void reset() {
        this.elementName = null;
        this.entityStack = new Stack();
        this.attributesList = Collections.synchronizedList(new ArrayList());
        this.attributeCount = 0;
        this.attributes = false;
        this.nsTemp = new String[3];
        this.prefixStack = null;
    }

    public void setLocale(Locale locale) throws SAXException {
        if ("en".equals(locale.getLanguage())) {
            return;
        }
        throw new SAXException("AElfred2 only supports English locales.");
    }

    public EntityResolver getEntityResolver() {
        if (this.entityResolver == this.base) {
            return null;
        }
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver2 = entityResolver instanceof EntityResolver2 ? (EntityResolver2)entityResolver : null;
        if (entityResolver == null) {
            entityResolver = this.base;
        }
        this.entityResolver = entityResolver;
    }

    public DTDHandler getDTDHandler() {
        if (this.dtdHandler == this.base) {
            return null;
        }
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        if (dTDHandler == null) {
            dTDHandler = this.base;
        }
        this.dtdHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.contentHandler = new Adapter(documentHandler);
        this.xmlNames = true;
    }

    public ContentHandler getContentHandler() {
        if (this.contentHandler == this.base) {
            return null;
        }
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            contentHandler = this.base;
        }
        this.contentHandler = contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = this.base;
        }
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        if (this.errorHandler == this.base) {
            return null;
        }
        return this.errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        DefaultHandler2 defaultHandler2 = this.base;
        synchronized (defaultHandler2) {
            try {
                Reader reader;
                this.parser = new XmlParser();
                if (this.namespaces) {
                    this.prefixStack = new NamespaceSupport();
                } else if (!this.xmlNames) {
                    throw new IllegalStateException();
                }
                this.parser.setHandler(this);
                try {
                    try {
                        reader = inputSource.getCharacterStream();
                        InputStream inputStream = inputSource.getByteStream();
                        this.parser.doParse(inputSource.getSystemId(), inputSource.getPublicId(), reader, inputStream, inputSource.getEncoding());
                    }
                    catch (SAXException sAXException) {
                        throw sAXException;
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new SAXParseException(exception.getMessage(), this, exception);
                    }
                    reader = null;
                }
                catch (Throwable throwable) {
                    Object var3_8 = null;
                    this.contentHandler.endDocument();
                    this.reset();
                    throw throwable;
                }
                this.contentHandler.endDocument();
                this.reset();
                reader = null;
            }
            catch (Throwable throwable) {
                Object var3_9 = null;
                throw throwable;
            }
        }
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(string)) {
            return this.extGE;
        }
        if ("http://xml.org/sax/features/external-parameter-entities".equals(string)) {
            return this.extPE;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return this.xmlNames;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return this.namespaces;
        }
        if ("http://xml.org/sax/features/lexical-handler/parameter-entities".equals(string)) {
            return true;
        }
        if ("http://xml.org/sax/features/string-interning".equals(string)) {
            return this.stringInterning;
        }
        if ("http://xml.org/sax/features/use-attributes2".equals(string)) {
            return true;
        }
        if ("http://xml.org/sax/features/is-standalone".equals(string)) {
            if (this.parser == null) {
                throw new SAXNotSupportedException(string);
            }
            return this.parser.isStandalone();
        }
        if ("http://xml.org/sax/features/resolve-dtd-uris".equals(string)) {
            return this.resolveAll;
        }
        if ("http://xml.org/sax/features/use-entity-resolver2".equals(string)) {
            return this.useResolver2;
        }
        throw new SAXNotRecognizedException(string);
    }

    DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    boolean resolveURIs() {
        return this.resolveAll;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            if (this.declHandler != this.base) {
                return this.declHandler;
            }
            return null;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            if (this.lexicalHandler != this.base) {
                return this.lexicalHandler;
            }
            return null;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean bl2 = this.getFeature(string);
        if (bl2 == bl) {
            return;
        }
        if (this.parser != null) {
            throw new SAXNotSupportedException("not while parsing");
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            this.xmlNames = bl;
            if (!this.xmlNames) {
                this.namespaces = true;
            }
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            this.namespaces = bl;
            if (!this.namespaces) {
                this.xmlNames = true;
            }
            return;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(string)) {
            this.extGE = bl;
            return;
        }
        if ("http://xml.org/sax/features/external-parameter-entities".equals(string)) {
            this.extPE = bl;
            return;
        }
        if ("http://xml.org/sax/features/resolve-dtd-uris".equals(string)) {
            this.resolveAll = bl;
            return;
        }
        if ("http://xml.org/sax/features/use-entity-resolver2".equals(string)) {
            this.useResolver2 = bl;
            return;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.getProperty(string);
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            if (object == null) {
                this.declHandler = this.base;
            } else {
                if (!(object instanceof DeclHandler)) {
                    throw new SAXNotSupportedException(string);
                }
                this.declHandler = (DeclHandler)object;
            }
            return;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            if (object == null) {
                this.lexicalHandler = this.base;
            } else {
                if (!(object instanceof LexicalHandler)) {
                    throw new SAXNotSupportedException(string);
                }
                this.lexicalHandler = (LexicalHandler)object;
            }
            return;
        }
        throw new SAXNotSupportedException(string);
    }

    void startDocument() throws SAXException {
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
        this.attributesList.clear();
    }

    void xmlDecl(String string, String string2, boolean bl, String string3) throws SAXException {
        if (this.contentHandler instanceof ContentHandler2) {
            ((ContentHandler2)this.contentHandler).xmlDecl(string, string2, bl, string3);
        }
    }

    void skippedEntity(String string) throws SAXException {
        this.contentHandler.skippedEntity(string);
    }

    InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        if (this.resolver2 == null || !this.useResolver2 || !this.extPE) {
            return null;
        }
        return this.resolver2.getExternalSubset(string, string2);
    }

    InputSource resolveEntity(boolean bl, String string, InputSource inputSource, String string2) throws SAXException, IOException {
        InputSource inputSource2;
        if (bl && !this.extPE) {
            return null;
        }
        if (!bl && !this.extGE) {
            return null;
        }
        this.lexicalHandler.startEntity(string);
        if (this.resolver2 != null && this.useResolver2) {
            inputSource2 = this.resolver2.resolveEntity(string, inputSource.getPublicId(), string2, inputSource.getSystemId());
            if (inputSource2 == null) {
                inputSource.setSystemId(this.absolutize(string2, inputSource.getSystemId(), false));
                inputSource2 = inputSource;
            }
        } else {
            inputSource.setSystemId(this.absolutize(string2, inputSource.getSystemId(), this.entityResolver != this.base));
            inputSource2 = this.entityResolver.resolveEntity(inputSource.getPublicId(), inputSource.getSystemId());
            if (inputSource2 == null) {
                inputSource2 = inputSource;
            }
        }
        this.startExternalEntity(string, inputSource2.getSystemId(), true);
        return inputSource2;
    }

    String absolutize(String string, String string2, boolean bl) throws MalformedURLException, SAXException {
        try {
            if (string == null) {
                if (XmlParser.uriWarnings) {
                    this.warn("No base URI; hope this SYSTEM id is absolute: " + string2);
                }
                return new URL(string2).toString();
            }
            return new URL(new URL(string), string2).toString();
        }
        catch (MalformedURLException malformedURLException) {
            if (!bl) {
                throw malformedURLException;
            }
            this.warn("Can't absolutize SYSTEM id: " + malformedURLException.getMessage());
            return string2;
        }
    }

    void startExternalEntity(String string, String string2, boolean bl) throws SAXException {
        if (!bl) {
            this.lexicalHandler.startEntity(string);
        }
        this.entityStack.push(string2);
    }

    void endExternalEntity(String string) throws SAXException {
        if (!"[document]".equals(string)) {
            this.lexicalHandler.endEntity(string);
        }
        this.entityStack.pop();
    }

    void startInternalEntity(String string) throws SAXException {
        this.lexicalHandler.startEntity(string);
    }

    void endInternalEntity(String string) throws SAXException {
        this.lexicalHandler.endEntity(string);
    }

    void doctypeDecl(String string, String string2, String string3) throws SAXException {
        this.lexicalHandler.startDTD(string, string2, string3);
    }

    void notationDecl(String string, String string2, String string3, String string4) throws SAXException {
        try {
            this.dtdHandler.notationDecl(string, string2, this.resolveAll && string3 != null ? this.absolutize(string4, string3, true) : string3);
        }
        catch (IOException iOException) {
            throw new SAXParseException(iOException.getMessage(), this, iOException);
        }
    }

    void unparsedEntityDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        try {
            this.dtdHandler.unparsedEntityDecl(string, string2, this.resolveAll ? this.absolutize(string4, string3, true) : string3, string5);
        }
        catch (IOException iOException) {
            throw new SAXParseException(iOException.getMessage(), this, iOException);
        }
    }

    void endDoctype() throws SAXException {
        this.lexicalHandler.endDTD();
    }

    private void declarePrefix(String string, String string2) throws SAXException {
        int n = string2.indexOf(58);
        if (n < 1 && string2.length() != 0) {
            this.warn("relative URI for namespace: " + string2);
        }
        boolean bl = string.equals("xml");
        boolean bl2 = string2.equals("http://www.w3.org/XML/1998/namespace");
        if (!(!bl && !bl2 || bl && bl2)) {
            this.fatal("xml is by definition bound to the namespace name http://www.w3.org/XML/1998/namespace");
        }
        if (bl && bl2) {
            return;
        }
        bl = string.equals("xmlns");
        bl2 = string2.equals("http://www.w3.org/2000/xmlns/");
        if (!(!bl && !bl2 || bl && bl2)) {
            this.fatal("http://www.w3.org/2000/xmlns/ is by definition bound to prefix xmlns");
        }
        if (bl && bl2) {
            this.fatal("declaring the xmlns prefix is illegal");
        }
        string2 = string2.intern();
        this.prefixStack.declarePrefix(string, string2);
        this.contentHandler.startPrefixMapping(string, string2);
    }

    void attribute(String string, String string2, boolean bl) throws SAXException {
        if (!this.attributes) {
            this.attributes = true;
            if (this.namespaces) {
                this.prefixStack.pushContext();
            }
        }
        if (this.namespaces) {
            if (this.stringInterning) {
                if ("xmlns" == string) {
                    this.declarePrefix("", string2);
                    if (!this.xmlNames) {
                        return;
                    }
                } else {
                    int n = string.indexOf(58);
                    if (n == 5 && string.startsWith("xmlns")) {
                        String string3 = string.substring(6);
                        if (string3.equals("")) {
                            this.fatal("missing prefix in namespace declaration attribute");
                        }
                        if (string2.length() == 0) {
                            this.verror("missing URI in namespace declaration attribute: " + string);
                        } else {
                            this.declarePrefix(string3, string2);
                        }
                        if (!this.xmlNames) {
                            return;
                        }
                    }
                }
            } else if ("xmlns".equals(string)) {
                this.declarePrefix("", string2);
                if (!this.xmlNames) {
                    return;
                }
            } else {
                int n = string.indexOf(58);
                if (n == 5 && string.startsWith("xmlns")) {
                    String string4 = string.substring(6);
                    if (string2.length() == 0) {
                        this.verror("missing URI in namespace decl attribute: " + string);
                    } else {
                        this.declarePrefix(string4, string2);
                    }
                    if (!this.xmlNames) {
                        return;
                    }
                }
            }
        }
        ++this.attributeCount;
        this.attributesList.add(new Attribute(string, string2, bl));
    }

    void startElement(String string) throws SAXException {
        ContentHandler contentHandler = this.contentHandler;
        if (!this.attributes) {
            if (this.namespaces) {
                this.prefixStack.pushContext();
            }
        } else if (this.namespaces) {
            Iterator iterator = this.attributesList.iterator();
            while (iterator.hasNext()) {
                int n;
                Attribute attribute = (Attribute)iterator.next();
                String string2 = attribute.name;
                if (!this.stringInterning ? "xmlns".equals(string2) : "xmlns" == string2) continue;
                if (string2.equals(":")) {
                    this.fatal("namespace names consisting of a single colon character are invalid");
                }
                if ((n = string2.indexOf(58)) == 5 && string2.startsWith("xmlns")) continue;
                if (this.prefixStack.processName(string2, this.nsTemp, true) == null) {
                    this.fatal("undeclared attribute prefix in: " + string2);
                    continue;
                }
                attribute.nameSpace = this.nsTemp[0];
                attribute.localName = this.nsTemp[1];
            }
        }
        this.elementName = string;
        if (this.namespaces) {
            if (this.prefixStack.processName(string, this.nsTemp, false) == null) {
                this.fatal("undeclared element prefix in: " + string);
                this.nsTemp[1] = "";
                this.nsTemp[0] = "";
            }
            contentHandler.startElement(this.nsTemp[0], this.nsTemp[1], string, this);
        } else {
            contentHandler.startElement("", "", string, this);
        }
        if (this.attributes) {
            this.attributesList.clear();
            this.attributeCount = 0;
            this.attributes = false;
        }
    }

    void endElement(String string) throws SAXException {
        ContentHandler contentHandler = this.contentHandler;
        if (!this.namespaces) {
            contentHandler.endElement("", "", string);
            return;
        }
        this.prefixStack.processName(string, this.nsTemp, false);
        contentHandler.endElement(this.nsTemp[0], this.nsTemp[1], string);
        Enumeration enumeration = this.prefixStack.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            contentHandler.endPrefixMapping((String)enumeration.nextElement());
        }
        this.prefixStack.popContext();
    }

    void startCDATA() throws SAXException {
        this.lexicalHandler.startCDATA();
    }

    void charData(char[] cArray, int n, int n2) throws SAXException {
        this.contentHandler.characters(cArray, n, n2);
    }

    void endCDATA() throws SAXException {
        this.lexicalHandler.endCDATA();
    }

    void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.contentHandler.ignorableWhitespace(cArray, n, n2);
    }

    void processingInstruction(String string, String string2) throws SAXException {
        this.contentHandler.processingInstruction(string, string2);
    }

    void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.lexicalHandler != this.base) {
            this.lexicalHandler.comment(cArray, n, n2);
        }
    }

    void fatal(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this);
        this.errorHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }

    void verror(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this);
        this.errorHandler.error(sAXParseException);
    }

    void warn(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this);
        this.errorHandler.warning(sAXParseException);
    }

    public int getLength() {
        return this.attributesList.size();
    }

    public String getURI(int n) {
        if (n < 0 || n >= this.attributesList.size()) {
            return null;
        }
        return ((Attribute)this.attributesList.get((int)n)).nameSpace;
    }

    public String getLocalName(int n) {
        if (n < 0 || n >= this.attributesList.size()) {
            return null;
        }
        Attribute attribute = (Attribute)this.attributesList.get(n);
        if (this.namespaces && attribute.localName == null) {
            int n2 = attribute.name.indexOf(58);
            String string = attribute.localName = n2 == -1 ? attribute.name : attribute.name.substring(n2 + 1);
        }
        if (attribute.localName == null) {
            return "";
        }
        return attribute.localName;
    }

    public String getQName(int n) {
        if (n < 0 || n >= this.attributesList.size()) {
            return null;
        }
        Attribute attribute = (Attribute)this.attributesList.get(n);
        if (attribute.name == null) {
            return "";
        }
        return attribute.name;
    }

    public String getName(int n) {
        return this.getQName(n);
    }

    public String getType(int n) {
        if (n < 0 || n >= this.attributesList.size()) {
            return null;
        }
        String string = this.parser.getAttributeType(this.elementName, this.getQName(n));
        if (string == null) {
            return "CDATA";
        }
        if (string == "ENUMERATION") {
            return "NMTOKEN";
        }
        return string;
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.attributesList.size()) {
            return null;
        }
        return ((Attribute)this.attributesList.get((int)n)).value;
    }

    public int getIndex(String string, String string2) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            if (!this.getURI(i).equals(string) || !this.getLocalName(i).equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String string) {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            if (!this.getQName(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return this.getType(n);
    }

    public String getType(String string) {
        int n = this.getIndex(string);
        if (n < 0) {
            return null;
        }
        return this.getType(n);
    }

    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        if (n < 0) {
            return null;
        }
        return this.getValue(n);
    }

    public String getValue(String string) {
        int n = this.getIndex(string);
        if (n < 0) {
            return null;
        }
        return this.getValue(n);
    }

    public boolean isDeclared(int n) {
        if (n < 0 || n >= this.attributeCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String string = this.parser.getAttributeType(this.elementName, this.getQName(n));
        return string != null;
    }

    public boolean isDeclared(String string) {
        int n = this.getIndex(string);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        String string2 = this.parser.getAttributeType(this.elementName, string);
        return string2 != null;
    }

    public boolean isDeclared(String string, String string2) {
        int n = this.getIndex(string, string2);
        return this.isDeclared(n);
    }

    public boolean isSpecified(int n) {
        return ((Attribute)this.attributesList.get((int)n)).specified;
    }

    public boolean isSpecified(String string, String string2) {
        int n = this.getIndex(string, string2);
        return this.isSpecified(n);
    }

    public boolean isSpecified(String string) {
        int n = this.getIndex(string);
        return this.isSpecified(n);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        if (this.entityStack.empty()) {
            return null;
        }
        return (String)this.entityStack.peek();
    }

    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    public int getColumnNumber() {
        return this.parser.getColumnNumber();
    }

    private static class Attribute {
        String name;
        String value;
        String nameSpace;
        String localName;
        boolean specified;

        Attribute(String string, String string2, boolean bl) {
            this.name = string;
            this.value = string2;
            this.nameSpace = "";
            this.specified = bl;
        }
    }

    private static class Adapter
    implements ContentHandler {
        private DocumentHandler docHandler;

        Adapter(DocumentHandler documentHandler) {
            this.docHandler = documentHandler;
        }

        public void setDocumentLocator(Locator locator) {
            this.docHandler.setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            this.docHandler.startDocument();
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.docHandler.processingInstruction(string, string2);
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.docHandler.startElement(string3, (AttributeList)((Object)attributes));
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.docHandler.characters(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.docHandler.ignorableWhitespace(cArray, n, n2);
        }

        public void skippedEntity(String string) {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.docHandler.endElement(string3);
        }

        public void endPrefixMapping(String string) {
        }

        public void endDocument() throws SAXException {
            this.docHandler.endDocument();
        }
    }
}

