/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public final class DomIterator
implements NodeIterator,
EventListener {
    private Node reference;
    private boolean right;
    private boolean done;
    private final Node root;
    private final int whatToShow;
    private final NodeFilter filter;
    private final boolean expandEntityReferences;

    protected DomIterator(Node node2, int n, NodeFilter nodeFilter, boolean bl) {
        if (!node2.isSupported("MutationEvents", "2.0")) {
            throw new DomDOMException(9, "Iterator needs mutation events", node2, 0);
        }
        this.root = node2;
        this.whatToShow = n;
        this.filter = nodeFilter;
        this.expandEntityReferences = bl;
        this.reference = null;
        this.right = true;
        EventTarget eventTarget = (EventTarget)((Object)node2);
        eventTarget.addEventListener("DOMNodeRemoved", this, false);
    }

    public void detach() {
        EventTarget eventTarget = (EventTarget)((Object)this.root);
        eventTarget.removeEventListener("DOMNodeRemoved", this, false);
        this.done = true;
    }

    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public Node nextNode() {
        if (this.done) {
            throw new DomDOMException(11);
        }
        this.right = true;
        return this.walk(true);
    }

    public Node previousNode() {
        if (this.done) {
            throw new DomDOMException(11);
        }
        Node node2 = this.reference;
        this.right = false;
        this.walk(false);
        return node2;
    }

    private boolean shouldShow(Node node2) {
        if ((this.whatToShow & 1 << (node2.getNodeType() - 1 & 0x1F)) == 0) {
            return false;
        }
        if (this.filter == null) {
            return true;
        }
        return this.filter.acceptNode(node2) == 1;
    }

    private Node walk(boolean bl) {
        Node node2 = this.reference;
        while ((node2 = this.successor(node2, bl)) != null && !this.shouldShow(node2)) {
        }
        if (node2 != null || !bl) {
            this.reference = node2;
        }
        return node2;
    }

    private boolean isLeaf(Node node2) {
        boolean bl = node2.hasChildNodes() ^ true;
        if (!bl && !this.expandEntityReferences) {
            bl = node2.getNodeType() == 5;
        }
        return bl;
    }

    private Node successor(Node node2, boolean bl) {
        Node node3;
        if (node2 == null) {
            if (bl) {
                return this.root;
            }
            return null;
        }
        if (bl && !this.isLeaf(node2)) {
            return node2.getFirstChild();
        }
        if (bl) {
            node3 = node2.getNextSibling();
            if (node3 != null) {
                return node3;
            }
        } else {
            node3 = node2.getPreviousSibling();
            if (node3 != null) {
                if (this.isLeaf(node3)) {
                    return node3;
                }
                node3 = node3.getLastChild();
                while (!this.isLeaf(node3)) {
                    node3 = node3.getLastChild();
                }
                return node3;
            }
        }
        if (!bl) {
            return node3;
        }
        Node node4 = null;
        for (node3 = node2.getParentNode(); node3 != null && node3 != this.root && (node4 = node3.getNextSibling()) == null; node3 = node3.getParentNode()) {
        }
        if (node3 == this.root) {
            return null;
        }
        return node4;
    }

    public void handleEvent(Event event) {
        Node node2;
        Node node3;
        if (this.reference == null || !"DOMNodeRemoved".equals(event.getType()) || event.getEventPhase() != 3) {
            return;
        }
        MutationEvent mutationEvent = (MutationEvent)event;
        Node node4 = (Node)((Object)mutationEvent.getTarget());
        for (node3 = this.reference; node3 != null && node3 != this.root && node3 != node4; node3 = node3.getParentNode()) {
        }
        if (node3 != node4) {
            return;
        }
        block1: while ((node2 = this.walk(this.right ^ true)) != null) {
            for (node3 = node2; node3 != null && node3 != this.root; node3 = node3.getParentNode()) {
                if (node3 == node4) continue block1;
            }
            return;
        }
    }
}

