/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.DomLSException;
import gnu.xml.dom.ls.DomLSInput;
import gnu.xml.dom.ls.FilteredSAXEventSink;
import gnu.xml.dom.ls.SAXEventSink;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSParserFilter;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class DomLSParser
implements LSParser,
DOMConfiguration,
DOMStringList,
ErrorHandler {
    private static final List SUPPORTED_PARAMETERS = Arrays.asList(new String[]{"cdata-sections", "comments", "element-content-whitespace", "namespaces", "expand-entity-references", "coalescing", "validating", "xinclude-aware", "entity-resolver", "error-handler"});
    private LSParserFilter filter;
    private final boolean async;
    private String schemaType;
    private SAXEventSink eventSink;
    private SAXParserFactory factory;
    private XMLReader reader;
    private boolean namespaceAware;
    private boolean ignoreWhitespace;
    private boolean expandEntityReferences;
    private boolean ignoreComments;
    private boolean coalescing;
    private boolean validating;
    private boolean xIncludeAware;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;

    private /* synthetic */ void finit$() {
        this.namespaceAware = true;
    }

    public DomLSParser(short s, String string) throws DOMException {
        this.finit$();
        switch (s) {
            case 2: {
                this.async = true;
                break;
            }
            case 1: {
                this.async = false;
                break;
            }
            default: {
                throw new DomDOMException(9);
            }
        }
        this.schemaType = string;
        this.factory = SAXParserFactory.newInstance();
    }

    public DOMConfiguration getDomConfig() {
        return this;
    }

    public LSParserFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LSParserFilter lSParserFilter) {
        this.filter = lSParserFilter;
    }

    public boolean getAsync() {
        return this.async;
    }

    public boolean getBusy() {
        return this.eventSink != null;
    }

    public Document parse(LSInput lSInput) throws DOMException, LSException {
        if (this.async) {
            return this.doParse(lSInput);
        }
        DomLSParser domLSParser = this;
        synchronized (domLSParser) {
            try {
                Document document = this.doParse(lSInput);
                Object var4_4 = null;
                return document;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public Document parseURI(String string) throws DOMException, LSException {
        DomLSInput domLSInput = new DomLSInput();
        domLSInput.setSystemId(string);
        return this.parse(domLSInput);
    }

    public Node parseWithContext(LSInput lSInput, Node node2, short s) throws DOMException, LSException {
        Document document = node2.getNodeType() == 9 ? (Document)node2 : node2.getOwnerDocument();
        lSInput.setBaseURI(document.getDocumentURI());
        Document document2 = this.parse(lSInput);
        Node node3 = document2.getDocumentElement();
        node3 = document.adoptNode(node3);
        switch (s) {
            case 1: {
                node2.appendChild(node3);
                break;
            }
            case 2: {
                Node node4 = node2.getFirstChild();
                while (node4 != null) {
                    Node node5 = node4.getNextSibling();
                    node2.removeChild(node4);
                    node4 = node5;
                }
                node2.appendChild(node3);
                break;
            }
            case 3: {
                Node node6 = node2.getParentNode();
                node6.insertBefore(node3, node2);
                break;
            }
            case 4: {
                Node node7 = node2.getParentNode();
                Node node8 = node2.getNextSibling();
                if (node8 == null) {
                    node7.appendChild(node3);
                    break;
                }
                node7.insertBefore(node3, node8);
                break;
            }
            case 5: {
                Node node9 = node2.getParentNode();
                Node node10 = node2.getNextSibling();
                node9.removeChild(node2);
                if (node10 == null) {
                    node9.appendChild(node3);
                    break;
                }
                node9.insertBefore(node3, node10);
            }
        }
        return node3;
    }

    public void abort() {
        if (this.eventSink != null) {
            this.eventSink.interrupt();
        }
    }

    private Document doParse(LSInput lSInput) throws DOMException, LSException {
        if (this.eventSink != null) {
            throw new LSException(81, "parse in progress");
        }
        InputSource inputSource = this.getInputSource(lSInput);
        this.eventSink = this.filter == null ? new SAXEventSink() : new FilteredSAXEventSink(this.filter);
        this.eventSink.namespaceAware = this.namespaceAware;
        this.eventSink.ignoreWhitespace = this.ignoreWhitespace;
        this.eventSink.expandEntityReferences = this.expandEntityReferences;
        this.eventSink.ignoreComments = this.ignoreComments;
        this.eventSink.coalescing = this.coalescing;
        XMLReader xMLReader = this.getXMLReader();
        try {
            xMLReader.setContentHandler(this.eventSink);
            xMLReader.setDTDHandler(this.eventSink);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.eventSink);
            xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", this.eventSink);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", this.namespaceAware);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", this.validating);
            try {
                xMLReader.setFeature("http://xml.org/sax/features/use-attributes2", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            xMLReader.setEntityResolver(this.entityResolver);
            xMLReader.setErrorHandler(this.errorHandler);
            xMLReader.parse(inputSource);
        }
        catch (DOMException dOMException) {
            xMLReader = null;
            this.eventSink = null;
            throw dOMException;
        }
        catch (SAXException sAXException) {
            xMLReader = null;
            this.eventSink = null;
            throw new DomLSException(81, sAXException);
        }
        catch (IOException iOException) {
            xMLReader = null;
            this.eventSink = null;
            throw new DomLSException(81, iOException);
        }
        DomDocument domDocument = this.eventSink.doc;
        String string = lSInput.getSystemId();
        if (string != null && domDocument instanceof DomDocument) {
            domDocument.setDocumentURI(string);
        }
        this.eventSink = null;
        return domDocument;
    }

    private XMLReader getXMLReader() throws LSException {
        if (this.reader == null) {
            this.factory.setNamespaceAware(this.namespaceAware);
            this.factory.setValidating(this.validating);
            this.factory.setXIncludeAware(this.xIncludeAware);
            try {
                SAXParser sAXParser = this.factory.newSAXParser();
                this.reader = sAXParser.getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new DomLSException(81, parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new DomLSException(81, sAXException);
            }
        }
        return this.reader;
    }

    private InputSource getInputSource(LSInput lSInput) throws LSException {
        Object object;
        InputSource inputSource = null;
        String string = lSInput.getSystemId();
        InputStream inputStream = lSInput.getByteStream();
        if (inputStream != null) {
            inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string);
        }
        if (inputSource == null && this.entityResolver != null) {
            object = lSInput.getPublicId();
            try {
                inputSource = this.entityResolver.resolveEntity((String)object, string);
            }
            catch (SAXException sAXException) {
                throw new DomLSException(81, sAXException);
            }
            catch (IOException iOException) {
                throw new DomLSException(81, iOException);
            }
        }
        if (inputSource == null) {
            object = null;
            String string2 = lSInput.getBaseURI();
            try {
                try {
                    URL uRL = string2 == null ? null : new URL(string2);
                    object = uRL == null ? new URL(string) : new URL(uRL, string);
                }
                catch (MalformedURLException malformedURLException) {
                    File file = string2 == null ? null : new File(string2);
                    object = file == null ? new File(string).toURL() : new File(file, string).toURL();
                }
                inputStream = ((URL)object).openStream();
                string = ((URL)object).toString();
                inputSource = new InputSource(inputStream);
                inputSource.setSystemId(string);
            }
            catch (IOException iOException) {
                throw new DomLSException(81, iOException);
            }
        }
        return inputSource;
    }

    public void setParameter(String string, Object object) throws DOMException {
        if ("cdata-sections".equals(string = string.toLowerCase())) {
            this.coalescing = (Boolean)object ^ true;
        } else if ("comments".equals(string)) {
            this.ignoreComments = (Boolean)object ^ true;
        } else if ("element-content-whitespace".equals(string)) {
            this.ignoreWhitespace = (Boolean)object ^ true;
        } else if ("namespaces".equals(string)) {
            this.namespaceAware = (Boolean)object;
        } else if ("expand-entity-references".equals(string)) {
            this.expandEntityReferences = (Boolean)object;
        } else if ("coalescing".equals(string)) {
            this.coalescing = (Boolean)object;
        } else if ("validating".equals(string)) {
            this.validating = (Boolean)object;
        } else if ("xinclude-aware".equals(string)) {
            this.xIncludeAware = (Boolean)object;
        } else if ("entity-resolver".equals(string)) {
            this.entityResolver = (EntityResolver)object;
        } else if ("error-handler".equals(string)) {
            this.errorHandler = (ErrorHandler)object;
        } else {
            throw new DomDOMException(9);
        }
        this.reader = null;
    }

    public Object getParameter(String string) throws DOMException {
        if ("cdata-sections".equals(string = string.toLowerCase())) {
            return this.coalescing ? Boolean.FALSE : Boolean.TRUE;
        }
        if ("comments".equals(string)) {
            return this.ignoreComments ? Boolean.FALSE : Boolean.TRUE;
        }
        if ("element-content-whitespace".equals(string)) {
            return this.ignoreWhitespace ? Boolean.FALSE : Boolean.TRUE;
        }
        if ("namespaces".equals(string)) {
            return this.namespaceAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("expand-entity-references".equals(string)) {
            return this.expandEntityReferences ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("coalescing".equals(string)) {
            return this.coalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("validating".equals(string)) {
            return this.validating ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("xinclude-aware".equals(string)) {
            return this.xIncludeAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("entity-resolver".equals(string)) {
            return this.entityResolver;
        }
        if ("error-handler".equals(string)) {
            return this.errorHandler;
        }
        throw new DomDOMException(9);
    }

    public boolean canSetParameter(String string, Object object) {
        return this.contains(string);
    }

    public DOMStringList getParameterNames() {
        return this;
    }

    public String item(int n) {
        return (String)SUPPORTED_PARAMETERS.get(n);
    }

    public int getLength() {
        return SUPPORTED_PARAMETERS.size();
    }

    public boolean contains(String string) {
        return SUPPORTED_PARAMETERS.contains(string);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(sAXParseException);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(sAXParseException);
        }
        this.abort();
    }
}

