/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import gnu.xml.aelfred2.ContentHandler2;
import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class SAXEventSink
implements ContentHandler2,
LexicalHandler,
DTDHandler,
DeclHandler {
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String XMLNS_PREFIX = "xmlns";
    boolean namespaceAware;
    boolean ignoreWhitespace;
    boolean expandEntityReferences;
    boolean ignoreComments;
    boolean coalescing;
    DomDocument doc;
    Node ctx;
    LinkedList entityCtx;
    List pending;
    Locator locator;
    boolean inCDATA;
    boolean inDTD;
    boolean interrupted;

    void interrupt() {
        this.interrupted = true;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.namespaceAware) {
            this.pending = new LinkedList();
        }
        this.doc = new DomDocument();
        this.doc.setStrictErrorChecking(false);
        this.doc.setBuilding(true);
        this.ctx = this.doc;
    }

    public void xmlDecl(String string, String string2, boolean bl, String string3) throws SAXException {
        if (this.interrupted) {
            return;
        }
        this.doc.setXmlVersion(string);
        this.doc.setXmlEncoding(string2);
        this.doc.setXmlStandalone(bl);
        this.doc.setInputEncoding(string3);
    }

    public void endDocument() throws SAXException {
        this.doc.setStrictErrorChecking(true);
        this.doc.setBuilding(false);
        DomDoctype domDoctype = (DomDoctype)this.doc.getDoctype();
        if (domDoctype != null) {
            domDoctype.makeReadonly();
        }
        this.ctx = null;
        this.locator = null;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.namespaceAware) {
            String string3 = string != null && string.length() > 0 ? "xmlns:" + string : XMLNS_PREFIX;
            DomAttr domAttr = (DomAttr)this.doc.createAttributeNS(XMLNS_URI, string3);
            domAttr.setNodeValue(string2);
            if (this.ctx.getNodeType() == 2) {
                Element element = ((Attr)this.ctx).getOwnerElement();
                element.getAttributes().setNamedItemNS(domAttr);
            } else {
                this.pending.add(domAttr);
            }
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.interrupted) {
            return;
        }
        Element element = this.createElement(string, string2, string3, attributes);
        this.ctx.appendChild(element);
        this.ctx = element;
    }

    protected Element createElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Element element = this.namespaceAware ? this.doc.createElementNS(string, string3) : this.doc.createElement(string3);
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (this.namespaceAware && !this.pending.isEmpty()) {
            Iterator iterator = this.pending.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                namedNodeMap.setNamedItemNS(node2);
            }
            this.pending.clear();
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = this.createAttr(attributes, i);
            if (attr == null) continue;
            if (this.namespaceAware) {
                namedNodeMap.setNamedItemNS(attr);
                continue;
            }
            namedNodeMap.setNamedItem(attr);
        }
        return element;
    }

    protected Attr createAttr(Attributes attributes, int n) {
        DomAttr domAttr;
        Object object;
        if (this.namespaceAware) {
            object = attributes.getURI(n);
            String string = attributes.getQName(n);
            domAttr = (DomAttr)this.doc.createAttributeNS((String)object, string);
        } else {
            object = attributes.getQName(n);
            domAttr = (DomAttr)this.doc.createAttribute((String)object);
        }
        domAttr.setNodeValue(attributes.getValue(n));
        if (attributes instanceof Attributes2) {
            object = (Attributes2)attributes;
            domAttr.setSpecified(object.isSpecified(n));
        }
        return domAttr;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (this.namespaceAware) {
            this.pending.clear();
        }
        this.ctx = this.ctx.getParentNode();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.interrupted) {
            return;
        }
        this.ctx.appendChild(this.createText(cArray, n, n2));
    }

    protected Text createText(char[] cArray, int n, int n2) throws SAXException {
        Text text = this.inCDATA && !this.coalescing ? this.doc.createCDATASection(new String(cArray, n, n2)) : this.doc.createTextNode(new String(cArray, n, n2));
        return text;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.ignoreWhitespace) {
            this.characters(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            Node node2 = this.createProcessingInstruction(string, string2);
            this.ctx.appendChild(node2);
        }
    }

    protected Node createProcessingInstruction(String string, String string2) {
        return this.doc.createProcessingInstruction(string, string2);
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.interrupted) {
            return;
        }
        Node node2 = this.createDocumentType(string, string2, string3);
        this.doc.appendChild(node2);
        this.ctx = node2;
        this.inDTD = true;
    }

    protected Node createDocumentType(String string, String string2, String string3) {
        return new DomDoctype(this.doc, string, string2, string3);
    }

    public void endDTD() throws SAXException {
        if (this.interrupted) {
            return;
        }
        this.inDTD = false;
        this.ctx = this.ctx.getParentNode();
    }

    public void startEntity(String string) throws SAXException {
        DocumentType documentType = this.doc.getDoctype();
        if (documentType == null) {
            throw new SAXException("SAX parser error: reference to entity in undeclared doctype");
        }
        if ("[dtd]".equals(string) || string.charAt(0) == '%') {
            this.ctx = documentType;
            return;
        }
        if ("lt".equals(string) || "gt".equals(string) || "amp".equals(string) || "apos".equals(string) || "quot".equals(string)) {
            return;
        }
        NamedNodeMap namedNodeMap = documentType.getEntities();
        Entity entity = (Entity)namedNodeMap.getNamedItem(string);
        if (entity == null) {
            throw new SAXException("SAX parser error: reference to undeclared entity: " + string);
        }
        this.pushEntity(entity);
    }

    public void endEntity(String string) throws SAXException {
        if ("[dtd]".equals(string) || string.charAt(0) == '%') {
            return;
        }
        if ("lt".equals(string) || "gt".equals(string) || "amp".equals(string) || "apos".equals(string) || "quot".equals(string)) {
            return;
        }
        Entity entity = this.popEntity();
        if (this.expandEntityReferences) {
            for (Node node2 = entity.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                this.ctx.appendChild(node2);
            }
        } else {
            EntityReference entityReference = this.doc.createEntityReference(string);
            this.ctx.appendChild(entityReference);
        }
    }

    void pushEntity(Node node2) {
        if (this.entityCtx == null) {
            this.entityCtx = new LinkedList();
        }
        this.entityCtx.addLast(this.ctx);
        this.ctx = node2;
    }

    Entity popEntity() {
        Entity entity = (Entity)this.ctx;
        this.ctx = (Node)this.entityCtx.removeLast();
        return entity;
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            Node node2 = this.createComment(cArray, n, n2);
            this.ctx.appendChild(node2);
        }
    }

    protected Node createComment(char[] cArray, int n, int n2) {
        return this.doc.createComment(new String(cArray, n, n2));
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype domDoctype = (DomDoctype)this.ctx;
        domDoctype.declareNotation(string, string2, string3);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype domDoctype = (DomDoctype)this.ctx;
        Entity entity = domDoctype.declareEntity(string, string2, string3, string4);
    }

    public void elementDecl(String string, String string2) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!(this.ctx instanceof DomDoctype)) {
            return;
        }
        DomDoctype domDoctype = (DomDoctype)this.ctx;
        domDoctype.elementDecl(string, string2);
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype domDoctype = (DomDoctype)this.ctx;
        domDoctype.attributeDecl(string, string2, string3, string4, string5);
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype domDoctype = (DomDoctype)this.ctx;
        Entity entity = domDoctype.declareEntity(string, null, null, null);
        if (entity != null) {
            Text text = this.doc.createTextNode(string2);
            entity.appendChild(text);
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype domDoctype = (DomDoctype)this.ctx;
        Entity entity = domDoctype.declareEntity(string, string2, string3, null);
    }

    SAXEventSink() {
    }
}

