/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.FilteredEventReader;
import gnu.xml.stream.FilteredStreamReader;
import gnu.xml.stream.XMLEventAllocatorImpl;
import gnu.xml.stream.XMLEventReaderImpl;
import gnu.xml.stream.XMLStreamReaderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XMLInputFactoryImpl
extends XMLInputFactory {
    protected XMLResolver resolver;
    protected XMLReporter reporter;
    protected XMLEventAllocator allocator;
    protected boolean validating;
    protected boolean namespaceAware;
    protected boolean coalescing;
    protected boolean replacingEntityReferences;
    protected boolean externalEntities;
    protected boolean supportDTD;

    private /* synthetic */ void finit$() {
        this.namespaceAware = true;
        this.replacingEntityReferences = true;
        this.externalEntities = true;
        this.supportDTD = true;
    }

    public XMLInputFactoryImpl() {
        this.finit$();
        this.allocator = new XMLEventAllocatorImpl();
    }

    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return new XMLStreamReaderImpl(reader, null, null, this.resolver, this.reporter, this.validating, this.namespaceAware, this.coalescing, this.replacingEntityReferences, this.externalEntities, this.supportDTD);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        String string = source.getSystemId();
        InputStream inputStream = this.getInputStream(source);
        return new XMLStreamReaderImpl(inputStream, null, string, this.resolver, this.reporter, this.validating, this.namespaceAware, this.coalescing, this.replacingEntityReferences, this.externalEntities, this.supportDTD);
    }

    public XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return new XMLStreamReaderImpl(inputStream, null, null, this.resolver, this.reporter, this.validating, this.namespaceAware, this.coalescing, this.replacingEntityReferences, this.externalEntities, this.supportDTD);
    }

    public XMLStreamReader createXMLStreamReader(InputStream inputStream, String string) throws XMLStreamException {
        return this.createXMLStreamReader(inputStream);
    }

    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        XMLStreamReader xMLStreamReader = this.createXMLStreamReader(reader);
        return new XMLEventReaderImpl(xMLStreamReader, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        return new XMLEventReaderImpl(xMLStreamReader, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        XMLStreamReader xMLStreamReader = this.createXMLStreamReader(source);
        return new XMLEventReaderImpl(xMLStreamReader, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(InputStream inputStream) throws XMLStreamException {
        XMLStreamReader xMLStreamReader = this.createXMLStreamReader(inputStream);
        return new XMLEventReaderImpl(xMLStreamReader, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(InputStream inputStream, String string) throws XMLStreamException {
        XMLStreamReader xMLStreamReader = this.createXMLStreamReader(inputStream, string);
        return new XMLEventReaderImpl(xMLStreamReader, this.allocator, null);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader xMLStreamReader, StreamFilter streamFilter) throws XMLStreamException {
        return new FilteredStreamReader(xMLStreamReader, streamFilter);
    }

    public XMLEventReader createFilteredReader(XMLEventReader xMLEventReader, EventFilter eventFilter) throws XMLStreamException {
        return new FilteredEventReader(xMLEventReader, eventFilter);
    }

    public XMLResolver getXMLResolver() {
        return this.resolver;
    }

    public void setXMLResolver(XMLResolver xMLResolver) {
        this.resolver = xMLResolver;
    }

    public XMLReporter getXMLReporter() {
        return this.reporter;
    }

    public void setXMLReporter(XMLReporter xMLReporter) {
        this.reporter = xMLReporter;
    }

    public void setProperty(String string, Object object) throws IllegalArgumentException {
        if (string.equals("javax.xml.stream.isNamespaceAware")) {
            this.namespaceAware = (Boolean)object;
        } else if (string.equals("javax.xml.stream.isValidating")) {
            this.validating = (Boolean)object;
        } else if (string.equals("javax.xml.stream.isCoalescing")) {
            this.coalescing = (Boolean)object;
        } else if (string.equals("javax.xml.stream.isReplacingEntityReferences")) {
            this.replacingEntityReferences = (Boolean)object;
        } else if (string.equals("javax.xml.stream.isSupportingExternalEntities")) {
            this.externalEntities = (Boolean)object;
        } else if (string.equals("javax.xml.stream.supportDTD")) {
            this.supportDTD = (Boolean)object;
        } else if (string.equals("javax.xml.stream.reporter")) {
            this.reporter = (XMLReporter)object;
        } else if (string.equals("javax.xml.stream.resolver")) {
            this.resolver = (XMLResolver)object;
        } else if (string.equals("javax.xml.stream.allocator")) {
            this.allocator = (XMLEventAllocator)object;
        } else {
            throw new IllegalArgumentException(string);
        }
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string.equals("javax.xml.stream.isNamespaceAware")) {
            return this.namespaceAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("javax.xml.stream.isValidating")) {
            return this.validating ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("javax.xml.stream.isCoalescing")) {
            return this.coalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("javax.xml.stream.isReplacingEntityReferences")) {
            return this.replacingEntityReferences ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("javax.xml.stream.isSupportingExternalEntities")) {
            return this.externalEntities ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("javax.xml.stream.supportDTD")) {
            return this.supportDTD ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equals("javax.xml.stream.reporter")) {
            return this.reporter;
        }
        if (string.equals("javax.xml.stream.resolver")) {
            return this.resolver;
        }
        if (string.equals("javax.xml.stream.allocator")) {
            return this.allocator;
        }
        throw new IllegalArgumentException(string);
    }

    public boolean isPropertySupported(String string) {
        return string.equals("javax.xml.stream.isNamespaceAware") || string.equals("javax.xml.stream.isValidating") || string.equals("javax.xml.stream.isCoalescing") || string.equals("javax.xml.stream.isReplacingEntityReferences") || string.equals("javax.xml.stream.isSupportingExternalEntities") || string.equals("javax.xml.stream.supportDTD") || string.equals("javax.xml.stream.reporter") || string.equals("javax.xml.stream.resolver") || string.equals("javax.xml.stream.allocator");
    }

    public void setEventAllocator(XMLEventAllocator xMLEventAllocator) {
        this.allocator = xMLEventAllocator;
    }

    public XMLEventAllocator getEventAllocator() {
        return this.allocator;
    }

    public void setCoalescing(boolean bl) {
        this.coalescing = bl;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    protected InputStream getInputStream(Source source) throws XMLStreamException {
        Object object;
        InputStream inputStream = null;
        if (source instanceof StreamSource) {
            object = (StreamSource)source;
            inputStream = ((StreamSource)object).getInputStream();
        }
        if (inputStream == null) {
            object = source.getSystemId();
            try {
                URL uRL = new URL((String)object);
                try {
                    inputStream = uRL.openStream();
                }
                catch (IOException iOException) {
                    XMLStreamException xMLStreamException = new XMLStreamException(iOException);
                    xMLStreamException.initCause(iOException);
                    throw xMLStreamException;
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (File.separatorChar != '/') {
                    object = ((String)object).replace('/', File.separatorChar);
                }
                try {
                    inputStream = new FileInputStream((String)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    XMLStreamException xMLStreamException = new XMLStreamException(fileNotFoundException);
                    xMLStreamException.initCause(fileNotFoundException);
                    throw xMLStreamException;
                }
            }
        }
        return inputStream;
    }
}

