/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.AttributeImpl;
import gnu.xml.stream.CharactersImpl;
import gnu.xml.stream.CommentImpl;
import gnu.xml.stream.DTDImpl;
import gnu.xml.stream.EndDocumentImpl;
import gnu.xml.stream.EndElementImpl;
import gnu.xml.stream.EndEntityImpl;
import gnu.xml.stream.EntityDeclarationImpl;
import gnu.xml.stream.LocationImpl;
import gnu.xml.stream.NamespaceImpl;
import gnu.xml.stream.NotationDeclarationImpl;
import gnu.xml.stream.ProcessingInstructionImpl;
import gnu.xml.stream.StartDocumentImpl;
import gnu.xml.stream.StartElementImpl;
import gnu.xml.stream.StartEntityImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLStreamReaderImpl
implements XMLStreamReader,
NamespaceContext {
    private LinkedList events;
    private XMLEvent currentEvent;
    private int eventType;
    private NamespaceSupport namespaces;
    protected String publicId;
    protected String systemId;
    protected XMLResolver resolver;
    protected XMLReporter reporter;
    protected boolean validating;
    protected boolean namespaceAware;
    protected boolean coalescing;
    protected boolean replacingEntityReferences;
    protected boolean externalEntities;
    protected boolean supportDTD;

    static /* synthetic */ LinkedList access$1(XMLStreamReaderImpl xMLStreamReaderImpl, LinkedList linkedList) {
        xMLStreamReaderImpl.events = linkedList;
        return xMLStreamReaderImpl.events;
    }

    protected XMLStreamReaderImpl(InputStream inputStream, String string, String string2, XMLResolver xMLResolver, XMLReporter xMLReporter, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws XMLStreamException {
        this.publicId = string;
        this.systemId = string2;
        this.resolver = xMLResolver;
        this.reporter = xMLReporter;
        this.validating = bl;
        this.namespaceAware = bl2;
        this.coalescing = bl3;
        this.replacingEntityReferences = bl4;
        this.externalEntities = bl5;
        this.supportDTD = bl6;
        this.namespaces = new NamespaceSupport();
        this.events = new LinkedList();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(bl2);
            sAXParserFactory.setValidating(bl);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            CallbackHandler callbackHandler = new CallbackHandler(this, xMLReader);
            xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", bl5);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", bl2);
            xMLReader.setContentHandler(callbackHandler);
            xMLReader.setDTDHandler(callbackHandler);
            xMLReader.setEntityResolver(callbackHandler);
            xMLReader.setErrorHandler(callbackHandler);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", callbackHandler);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string2);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            this.events.add(sAXException);
        }
        catch (IOException iOException) {
            this.events.add(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            XMLStreamException xMLStreamException = new XMLStreamException(parserConfigurationException);
            xMLStreamException.initCause(parserConfigurationException);
            throw xMLStreamException;
        }
    }

    protected XMLStreamReaderImpl(Reader reader, String string, String string2, XMLResolver xMLResolver, XMLReporter xMLReporter, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws XMLStreamException {
        this.publicId = string;
        this.systemId = string2;
        this.resolver = xMLResolver;
        this.reporter = xMLReporter;
        this.validating = bl;
        this.namespaceAware = bl2;
        this.coalescing = bl3;
        this.replacingEntityReferences = bl4;
        this.externalEntities = bl5;
        this.supportDTD = bl6;
        this.namespaces = new NamespaceSupport();
        this.events = new LinkedList();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(bl2);
            sAXParserFactory.setValidating(bl);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            CallbackHandler callbackHandler = new CallbackHandler(this, xMLReader);
            xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", bl5);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", bl2);
            xMLReader.setContentHandler(callbackHandler);
            xMLReader.setDTDHandler(callbackHandler);
            xMLReader.setEntityResolver(callbackHandler);
            xMLReader.setErrorHandler(callbackHandler);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", callbackHandler);
            InputSource inputSource = new InputSource(reader);
            inputSource.setSystemId(string2);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            this.events.add(sAXException);
        }
        catch (IOException iOException) {
            this.events.add(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            XMLStreamException xMLStreamException = new XMLStreamException(parserConfigurationException);
            xMLStreamException.initCause(parserConfigurationException);
            throw xMLStreamException;
        }
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    public int next() throws XMLStreamException {
        if (this.events.isEmpty()) {
            throw new XMLStreamException("EOF");
        }
        Object object = this.events.removeFirst();
        if (object instanceof Exception) {
            Exception exception = (Exception)object;
            XMLStreamException xMLStreamException = new XMLStreamException(exception);
            xMLStreamException.initCause(exception);
            throw xMLStreamException;
        }
        this.currentEvent = (XMLEvent)object;
        this.eventType = this.currentEvent.getEventType();
        return this.eventType;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public String getElementText() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public int nextTag() throws XMLStreamException {
        int n;
        while ((n = this.next()) != 1 && n != 2) {
        }
        return n;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.events.isEmpty() ^ true;
    }

    public void close() throws XMLStreamException {
    }

    public String getNamespaceURI(String string) {
        return this.namespaces.getURI(string);
    }

    public String getPrefix(String string) {
        return this.namespaces.getPrefix(string);
    }

    public Iterator getPrefixes(String string) {
        LinkedList linkedList = new LinkedList();
        Enumeration enumeration = this.namespaces.getPrefixes(string);
        while (enumeration.hasMoreElements()) {
            linkedList.add(enumeration.nextElement());
        }
        return linkedList.iterator();
    }

    public boolean isStartElement() {
        return this.eventType == 1;
    }

    public boolean isEndElement() {
        return this.eventType == 2;
    }

    public boolean isCharacters() {
        return this.eventType == 4 || this.eventType == 12;
    }

    public boolean isWhiteSpace() {
        return this.eventType == 6;
    }

    public String getAttributeValue(String string, String string2) {
        StartElement startElement = (StartElement)this.currentEvent;
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            QName qName = attribute.getName();
            if (string != null && !string.equals(qName.getNamespaceURI()) || !string2.equals(qName.getLocalPart())) continue;
            return attribute.getValue();
        }
        return null;
    }

    public int getAttributeCount() {
        StartElement startElement = (StartElement)this.currentEvent;
        int n = 0;
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public QName getAttributeQName(int n) {
        StartElement startElement = (StartElement)this.currentEvent;
        int n2 = 0;
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (n == n2) {
                return attribute.getName();
            }
            ++n2;
        }
        return null;
    }

    public String getAttributeNamespace(int n) {
        QName qName = this.getAttributeQName(n);
        if (qName == null) {
            return null;
        }
        return qName.getNamespaceURI();
    }

    public String getAttributeName(int n) {
        QName qName = this.getAttributeQName(n);
        if (qName == null) {
            return null;
        }
        return qName.getLocalPart();
    }

    public String getAttributePrefix(int n) {
        QName qName = this.getAttributeQName(n);
        if (qName == null) {
            return null;
        }
        return qName.getPrefix();
    }

    public String getAttributeType(int n) {
        StartElement startElement = (StartElement)this.currentEvent;
        int n2 = 0;
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (n == n2) {
                QName qName = attribute.getDTDType();
                if (qName == null) {
                    return "CDATA";
                }
                return qName.toString();
            }
            ++n2;
        }
        return null;
    }

    public String getAttributeValue(int n) {
        StartElement startElement = (StartElement)this.currentEvent;
        int n2 = 0;
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (n == n2) {
                return attribute.getValue();
            }
            ++n2;
        }
        return null;
    }

    public boolean isAttributeSpecified(int n) {
        StartElement startElement = (StartElement)this.currentEvent;
        int n2 = 0;
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (n == n2) {
                return attribute.isSpecified();
            }
            ++n2;
        }
        return false;
    }

    public int getNamespaceCount() {
        Iterator iterator = null;
        switch (this.eventType) {
            case 1: {
                iterator = ((StartElement)this.currentEvent).getNamespaces();
                break;
            }
            case 2: {
                iterator = ((EndElement)this.currentEvent).getNamespaces();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public String getNamespacePrefix(int n) {
        Iterator iterator = null;
        switch (this.eventType) {
            case 1: {
                iterator = ((StartElement)this.currentEvent).getNamespaces();
                break;
            }
            case 2: {
                iterator = ((EndElement)this.currentEvent).getNamespaces();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            Namespace namespace = (Namespace)iterator.next();
            if (n == n2) {
                return namespace.getPrefix();
            }
            ++n2;
        }
        return null;
    }

    public String getNamespaceURI(int n) {
        Iterator iterator = null;
        switch (this.eventType) {
            case 1: {
                iterator = ((StartElement)this.currentEvent).getNamespaces();
                break;
            }
            case 2: {
                iterator = ((EndElement)this.currentEvent).getNamespaces();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            Namespace namespace = (Namespace)iterator.next();
            if (n == n2) {
                return namespace.getNamespaceURI();
            }
            ++n2;
        }
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return this;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getText() {
        switch (this.eventType) {
            case 4: 
            case 6: 
            case 12: {
                return ((Characters)this.currentEvent).getData();
            }
            case 5: {
                return ((Comment)this.currentEvent).getText();
            }
            case 9: {
                return ((EntityReference)this.currentEvent).getReplacementText();
            }
            case 11: {
                return ((DTD)this.currentEvent).getDocumentTypeDeclaration();
            }
        }
        return null;
    }

    public char[] getTextCharacters() {
        String string = this.getText();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        char[] cArray2 = this.getTextCharacters();
        int n4 = Math.min(cArray2.length, n3);
        System.arraycopy(cArray2, n, cArray, n2, n4);
        return n4;
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        String string = this.getText();
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public String getEncoding() {
        return null;
    }

    public boolean hasText() {
        return this.eventType == 4 || this.eventType == 11 || this.eventType == 6 || this.eventType == 9 || this.eventType == 5 || this.eventType == 11;
    }

    public Location getLocation() {
        return this.currentEvent.getLocation();
    }

    public QName getName() {
        switch (this.eventType) {
            case 1: {
                return ((StartElement)this.currentEvent).getName();
            }
            case 2: {
                return ((EndElement)this.currentEvent).getName();
            }
            case 10: {
                return ((Attribute)this.currentEvent).getName();
            }
        }
        return null;
    }

    public String getLocalName() {
        QName qName = this.getName();
        if (qName == null) {
            return null;
        }
        return qName.getLocalPart();
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public String getNamespaceURI() {
        QName qName = this.getName();
        if (qName == null) {
            return null;
        }
        return qName.getNamespaceURI();
    }

    public String getPrefix() {
        QName qName = this.getName();
        if (qName == null) {
            return null;
        }
        return qName.getPrefix();
    }

    public String getVersion() {
        StartDocument startDocument = (StartDocument)this.currentEvent;
        return startDocument.getVersion();
    }

    public boolean isStandalone() {
        StartDocument startDocument = (StartDocument)this.currentEvent;
        return startDocument.isStandalone();
    }

    public boolean standaloneSet() {
        StartDocument startDocument = (StartDocument)this.currentEvent;
        return startDocument.standaloneSet();
    }

    public String getCharacterEncodingScheme() {
        StartDocument startDocument = (StartDocument)this.currentEvent;
        return startDocument.getCharacterEncodingScheme();
    }

    public String getPITarget() {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)this.currentEvent;
        return processingInstruction.getTarget();
    }

    public String getPIData() {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)this.currentEvent;
        return processingInstruction.getData();
    }

    class CallbackHandler
    implements ContentHandler,
    DTDHandler,
    LexicalHandler,
    DeclHandler,
    EntityResolver,
    ErrorHandler {
        private /* synthetic */ XMLStreamReaderImpl this$0;
        XMLReader reader;
        Locator locator;
        Location location;
        private boolean inCDATA;
        private LinkedList namespaces;
        private LinkedList notations;
        private LinkedList entities;

        private /* synthetic */ void finit$() {
            this.namespaces = new LinkedList();
        }

        CallbackHandler(XMLStreamReaderImpl xMLStreamReaderImpl, XMLReader xMLReader) {
            this.this$0 = xMLStreamReaderImpl;
            this.finit$();
            this.reader = xMLReader;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            this.location = new LocationImpl(-1, locator.getColumnNumber(), locator.getLineNumber(), locator.getSystemId());
        }

        public void startDocument() throws SAXException {
            boolean bl;
            String string = this.locator instanceof Locator2 ? ((Locator2)this.locator).getXMLVersion() : null;
            String string2 = this.locator instanceof Locator2 ? ((Locator2)this.locator).getEncoding() : null;
            boolean bl2 = bl = this.reader.getFeature("http://xml.org/sax/features/is-standalone");
            boolean bl3 = string2 != null;
            this.this$0.events.add(new StartDocumentImpl(this.location, this.location.getLocationURI(), string2, string, bl, bl2, bl3));
        }

        public void endDocument() throws SAXException {
            this.this$0.events.add(new EndDocumentImpl(this.location));
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.namespaces.add(new NamespaceImpl(this.location, string, string2));
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            LinkedList linkedList = this.namespaces;
            this.namespaces = new LinkedList();
            int n = string3.indexOf(58);
            String string4 = null;
            string2 = string3;
            if (n != -1) {
                string4 = string3.substring(0, n);
                string2 = string3.substring(n + 1);
            }
            QName qName = new QName(string, string2, string4);
            LinkedList linkedList2 = new LinkedList();
            StartElementImpl startElementImpl = new StartElementImpl(this.location, qName, linkedList2, linkedList, null);
            this.this$0.events.add(startElementImpl);
            int n2 = attributes.getLength();
            for (int i = 0; i < n2; ++i) {
                String string5 = attributes.getURI(i);
                String string6 = attributes.getQName(i);
                String string7 = attributes.getValue(i);
                QName qName2 = QName.valueOf(attributes.getType(i));
                boolean bl = attributes instanceof Attributes2 && ((Attributes2)attributes).isSpecified(i);
                n = string6.indexOf(58);
                String string8 = null;
                String string9 = string6;
                if (n != -1) {
                    string8 = string6.substring(0, n);
                    string9 = string6.substring(n + 1);
                }
                if ("xmlns".equals(string8) || "xmlns".equals(string6)) continue;
                QName qName3 = new QName(string5, string9, string8);
                AttributeImpl attributeImpl = new AttributeImpl(this.location, qName3, string7, qName2, bl);
                linkedList2.add(attributeImpl);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            int n = string3.indexOf(58);
            String string4 = null;
            string2 = string3;
            if (n != -1) {
                string4 = string3.substring(0, n);
                string2 = string3.substring(n + 1);
            }
            QName qName = new QName(string, string2, string4);
            this.this$0.events.add(new EndElementImpl(this.location, qName, new LinkedList()));
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            boolean bl = this.isWhitespace(cArray, n, n2);
            this.this$0.events.add(new CharactersImpl(this.location, new String(cArray, n, n2), bl, this.inCDATA, false));
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            boolean bl = this.isWhitespace(cArray, n, n2);
            this.this$0.events.add(new CharactersImpl(this.location, new String(cArray, n, n2), bl, this.inCDATA, true));
        }

        boolean isWhitespace(char[] cArray, int n, int n2) {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                char c = cArray[i];
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                return false;
            }
            return true;
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.this$0.events.add(new ProcessingInstructionImpl(this.location, string, string2));
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.notations = new LinkedList();
            this.entities = new LinkedList();
            this.this$0.events.add(new DTDImpl(this.location, null, null, this.notations, this.entities));
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String string) throws SAXException {
            this.this$0.events.add(new StartEntityImpl(this.location, string));
        }

        public void endEntity(String string) throws SAXException {
            this.this$0.events.add(new EndEntityImpl(this.location, string));
        }

        public void startCDATA() throws SAXException {
            this.inCDATA = true;
        }

        public void endCDATA() throws SAXException {
            this.inCDATA = false;
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
            this.this$0.events.add(new CommentImpl(this.location, new String(cArray, n, n2)));
        }

        public void notationDecl(String string, String string2, String string3) throws SAXException {
            NotationDeclarationImpl notationDeclarationImpl = new NotationDeclarationImpl(this.location, string, string2, string3);
            this.notations.add(notationDeclarationImpl);
        }

        public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
            EntityDeclarationImpl entityDeclarationImpl = new EntityDeclarationImpl(this.location, string2, string3, string, string4, null, null);
            this.entities.add(entityDeclarationImpl);
        }

        public void elementDecl(String string, String string2) throws SAXException {
        }

        public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        }

        public void internalEntityDecl(String string, String string2) throws SAXException {
            EntityDeclarationImpl entityDeclarationImpl = new EntityDeclarationImpl(this.location, null, null, string, null, string2, null);
            this.entities.add(entityDeclarationImpl);
        }

        public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
            EntityDeclarationImpl entityDeclarationImpl = new EntityDeclarationImpl(this.location, string2, string3, string, null, null, null);
            this.entities.add(entityDeclarationImpl);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.this$0.reporter != null) {
                try {
                    this.this$0.reporter.report(sAXParseException.getMessage(), "warning", sAXParseException, this.location);
                }
                catch (XMLStreamException xMLStreamException) {
                    SAXException sAXException = new SAXException(xMLStreamException.getMessage());
                    sAXException.initCause(xMLStreamException);
                    throw sAXException;
                }
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.this$0.reporter != null) {
                try {
                    this.this$0.reporter.report(sAXParseException.getMessage(), "error", sAXParseException, this.location);
                }
                catch (XMLStreamException xMLStreamException) {
                    SAXException sAXException = new SAXException(xMLStreamException.getMessage());
                    sAXException.initCause(xMLStreamException);
                    throw sAXException;
                }
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            if (this.this$0.reporter != null) {
                try {
                    this.this$0.reporter.report(sAXParseException.getMessage(), "fatal-error", sAXParseException, this.location);
                }
                catch (XMLStreamException xMLStreamException) {
                    SAXException sAXException = new SAXException(xMLStreamException.getMessage());
                    sAXException.initCause(xMLStreamException);
                    throw sAXException;
                }
            }
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (this.this$0.resolver != null) {
                try {
                    InputStream inputStream = this.this$0.resolver.resolve(string2);
                    if (inputStream != null) {
                        InputSource inputSource = new InputSource(inputStream);
                        inputSource.setPublicId(string);
                        inputSource.setSystemId(string2);
                        return inputSource;
                    }
                }
                catch (XMLStreamException xMLStreamException) {
                    SAXException sAXException = new SAXException(xMLStreamException.getMessage());
                    sAXException.initCause(xMLStreamException);
                    throw sAXException;
                }
            }
            return null;
        }
    }
}

