/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Key;
import gnu.xml.transform.SortKey;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.Template;
import gnu.xml.transform.TemplateNode;
import gnu.xml.transform.XSLComparator;
import gnu.xml.xpath.Expr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

final class ForEachNode
extends TemplateNode {
    final Expr select;
    final List sortKeys;

    ForEachNode(Expr expr, List list2) {
        this.select = expr;
        this.sortKeys = list2;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        int n = this.sortKeys.size();
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(((Key)this.sortKeys.get(i)).clone(stylesheet));
        }
        ForEachNode forEachNode = new ForEachNode(this.select.clone(stylesheet), arrayList);
        if (this.children != null) {
            forEachNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            forEachNode.next = this.next.clone(stylesheet);
        }
        return forEachNode;
    }

    void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        if (this.children != null) {
            Template template = stylesheet.currentTemplate;
            stylesheet.currentTemplate = null;
            Object object = this.select.evaluate(node2, n, n2);
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                ArrayList arrayList = new ArrayList(collection);
                if (this.sortKeys != null) {
                    Iterator iterator = this.sortKeys.iterator();
                    while (iterator.hasNext()) {
                        SortKey sortKey = (SortKey)iterator.next();
                        sortKey.init(stylesheet, qName, node2, n, n2, node3, node4);
                    }
                    Collections.sort(arrayList, new XSLComparator(this.sortKeys));
                } else {
                    Collections.sort(arrayList, TemplateNode.documentOrderComparator);
                }
                int n3 = arrayList.size();
                int n4 = 1;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Node node5;
                    stylesheet.current = node5 = (Node)iterator.next();
                    this.children.apply(stylesheet, qName, node5, n4++, n3, node3, node4);
                }
            }
            stylesheet.currentTemplate = template;
        }
        if (this.next != null) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    public boolean references(QName qName) {
        if (this.select != null && this.select.references(qName)) {
            return true;
        }
        if (this.sortKeys != null) {
            Iterator iterator = this.sortKeys.iterator();
            while (iterator.hasNext()) {
                if (!((SortKey)iterator.next()).references(qName)) continue;
                return true;
            }
        }
        return super.references(qName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("select=");
        stringBuffer.append(this.select);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

