/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StreamSerializer {
    static final int SPACE = 32;
    static final int BANG = 33;
    static final int APOS = 39;
    static final int SLASH = 47;
    static final int BRA = 60;
    static final int KET = 62;
    static final int EQ = 61;
    static final Map HTML_BOOLEAN_ATTRIBUTES = new HashMap();
    protected final String encoding;
    final Charset charset;
    final CharsetEncoder encoder;
    final int mode;
    final Map namespaces;
    protected String eol;
    Collection cdataSectionElements;
    protected boolean discardDefaultContent;
    protected boolean xmlDeclaration;

    private /* synthetic */ void finit$() {
        this.cdataSectionElements = Collections.EMPTY_SET;
        this.xmlDeclaration = true;
    }

    public StreamSerializer() {
        this(0, null, null);
    }

    public StreamSerializer(String string) {
        this(0, string, null);
    }

    public StreamSerializer(int n, String string, String string2) {
        this.finit$();
        this.mode = n;
        if (string == null) {
            string = "UTF-8";
        }
        this.encoding = string.intern();
        this.charset = Charset.forName(this.encoding);
        this.encoder = this.charset.newEncoder();
        this.eol = string2 != null ? string2 : System.getProperty("line.separator");
        this.namespaces = new HashMap();
    }

    void setCdataSectionElements(Collection collection) {
        this.cdataSectionElements = collection;
    }

    public void serialize(Node node2, OutputStream outputStream) throws IOException {
        this.serialize(node2, outputStream, false);
    }

    void serialize(Node node2, OutputStream outputStream, boolean bl) throws IOException {
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            this.doSerialize(node2, outputStream, bl);
            node2 = node3;
        }
    }

    private void doSerialize(Node node2, OutputStream outputStream, boolean bl) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("no output stream");
        }
        String string = node2.getNamespaceURI();
        boolean bl2 = false;
        int n = node2.getNodeType();
        if (bl && n == 3) {
            n = 4;
        }
        switch (n) {
            case 2: {
                String string2;
                String string3;
                String string4 = node2.getPrefix();
                if (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(string) || XMLConstants.XMLNS_ATTRIBUTE.equals(string4) || string4 != null && string4.startsWith("xmlns:")) {
                    string3 = node2.getNodeValue();
                    if (this.isDefined(string3)) break;
                    string2 = node2.getLocalName();
                    if (string2 == null) {
                        string2 = node2.getNodeName();
                    }
                    this.define(string3, string2);
                } else if (string != null && !this.isDefined(string)) {
                    string3 = (string4 = this.define(string, string4)) == null ? "xmlns" : "xmlns:" + string4;
                    outputStream.write(32);
                    outputStream.write(this.encodeText(string3));
                    outputStream.write(61);
                    string2 = "'" + this.encode(string, true, true) + "'";
                    outputStream.write(string2.getBytes(this.encoding));
                    bl2 = true;
                }
                outputStream.write(32);
                string3 = node2.getNodeName();
                outputStream.write(this.encodeText(string3));
                string2 = node2.getNodeValue();
                if (this.mode == 1 && string3.equals(string2) && this.isHTMLBoolean((Attr)node2, string3)) break;
                outputStream.write(61);
                String string5 = "'" + this.encode(string2, true, true) + "'";
                outputStream.write(this.encodeText(string5));
                break;
            }
            case 1: {
                Object object;
                String string6 = node2.getNodeName();
                outputStream.write(60);
                outputStream.write(this.encodeText(string6));
                if (string != null && !this.isDefined(string)) {
                    String string7 = this.define(string, node2.getPrefix());
                    object = string7 == null ? "xmlns" : "xmlns:" + string7;
                    outputStream.write(32);
                    outputStream.write(this.encodeText((String)object));
                    outputStream.write(61);
                    String string8 = "'" + this.encode(string, true, true) + "'";
                    outputStream.write(this.encodeText(string8));
                    bl2 = true;
                }
                if ((object = node2.getAttributes()) != null) {
                    int n2 = object.getLength();
                    for (int i = 0; i < n2; ++i) {
                        Attr attr = (Attr)object.item(i);
                        if (this.discardDefaultContent && !attr.getSpecified()) continue;
                        this.serialize(attr, outputStream, false);
                    }
                }
                bl = this.cdataSectionElements.contains(string6);
                Node node3 = node2.getFirstChild();
                if (node3 == null) {
                    outputStream.write(47);
                    outputStream.write(62);
                    break;
                }
                outputStream.write(62);
                this.serialize(node3, outputStream, bl);
                outputStream.write(60);
                outputStream.write(47);
                outputStream.write(this.encodeText(string6));
                outputStream.write(62);
                break;
            }
            case 3: {
                String string9 = node2.getNodeValue();
                if (!"yes".equals(node2.getUserData("disable-output-escaping"))) {
                    string9 = this.encode(string9, false, false);
                }
                outputStream.write(this.encodeText(string9));
                break;
            }
            case 4: {
                String string10 = "<![CDATA[" + node2.getNodeValue() + "]]>";
                outputStream.write(this.encodeText(string10));
                break;
            }
            case 8: {
                String string11 = "<!--" + node2.getNodeValue() + "-->";
                outputStream.write(this.encodeText(string11));
                Node node4 = node2.getParentNode();
                if (node4 == null || node4.getNodeType() != 9) break;
                outputStream.write(this.encodeText(this.eol));
                break;
            }
            case 9: 
            case 11: {
                if (this.mode == 0) {
                    if ("UTF-16".equalsIgnoreCase(this.encoding)) {
                        outputStream.write(254);
                        outputStream.write(255);
                    }
                    if (!"yes".equals(node2.getUserData("omit-xml-declaration")) && this.xmlDeclaration) {
                        String string12;
                        Document document = node2 instanceof Document ? (Document)node2 : null;
                        String string13 = string12 = document != null ? document.getXmlVersion() : null;
                        if (string12 == null) {
                            string12 = (String)node2.getUserData("version");
                        }
                        if (string12 == null) {
                            string12 = "1.0";
                        }
                        outputStream.write(60);
                        outputStream.write(63);
                        outputStream.write("xml version='".getBytes("US-ASCII"));
                        outputStream.write(string12.getBytes("US-ASCII"));
                        outputStream.write(39);
                        if (!"UTF-8".equalsIgnoreCase(this.encoding)) {
                            outputStream.write(" encoding='".getBytes("US-ASCII"));
                            outputStream.write(this.encoding.getBytes("US-ASCII"));
                            outputStream.write(39);
                        }
                        if (document != null && document.getXmlStandalone() || "yes".equals(node2.getUserData("standalone"))) {
                            outputStream.write(" standalone='yes'".getBytes("US-ASCII"));
                        }
                        outputStream.write(63);
                        outputStream.write(62);
                        outputStream.write(this.encodeText(this.eol));
                    }
                } else if (this.mode == 1) {
                    Object object;
                    Node node5;
                    Object object2;
                    Object object3;
                    Node node6;
                    String string14 = (String)node2.getUserData("media-type");
                    if (string14 == null) {
                        string14 = "text/html";
                    }
                    String string15 = string14 + "; charset=" + (this.encoding.indexOf(32) != -1 ? "\"" + this.encoding + "\"" : this.encoding);
                    Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
                    Node node7 = null;
                    for (node6 = node2.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                        if (node6.getNodeType() != 1) continue;
                        node7 = node6;
                        break;
                    }
                    if (node7 == null) {
                        node7 = document.createElement("html");
                        node2.appendChild(node7);
                    }
                    node6 = null;
                    for (object3 = node7.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
                        if (object3.getNodeType() != 1) continue;
                        object2 = object3.getLocalName();
                        if (object2 == null) {
                            object2 = object3.getNodeName();
                        }
                        if (!"head".equalsIgnoreCase((String)object2)) continue;
                        node6 = object3;
                        break;
                    }
                    if (node6 == null) {
                        node6 = document.createElement("head");
                        object3 = null;
                        for (object2 = node7.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                            if (object2.getNodeType() != 1) continue;
                            object3 = object2;
                            break;
                        }
                        if (object3 != null) {
                            node7.insertBefore(node6, (Node)object3);
                        } else {
                            node7.appendChild(node6);
                        }
                    }
                    object3 = null;
                    object2 = null;
                    for (node5 = node6.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                        if (node5.getNodeType() != 1) continue;
                        object = node5.getLocalName();
                        if (object == null) {
                            object = node5.getNodeName();
                        }
                        if (!"meta".equalsIgnoreCase((String)object)) continue;
                        NamedNodeMap namedNodeMap = node5.getAttributes();
                        int n3 = namedNodeMap.getLength();
                        String string16 = null;
                        Node node8 = null;
                        for (int i = 0; i < n3; ++i) {
                            Node node9 = namedNodeMap.item(i);
                            String string17 = node9.getNodeName();
                            if ("http-equiv".equalsIgnoreCase(string17)) {
                                string16 = node9.getNodeValue();
                                continue;
                            }
                            if (!"content".equalsIgnoreCase(string17)) continue;
                            node8 = node9;
                        }
                        if (!"Content-Type".equalsIgnoreCase(string16)) continue;
                        object3 = node5;
                        object2 = node8;
                        break;
                    }
                    if (object3 == null) {
                        object3 = document.createElement("meta");
                        node5 = node6.getFirstChild();
                        if (node5 == null) {
                            node6.appendChild((Node)object3);
                        } else {
                            node6.insertBefore((Node)object3, node5);
                        }
                        object = document.createAttribute("http-equiv");
                        object3.getAttributes().setNamedItem((Node)object);
                        object.setNodeValue("Content-Type");
                    }
                    if (object2 == null) {
                        object2 = document.createAttribute("content");
                        object3.getAttributes().setNamedItem((Node)object2);
                    }
                    object2.setNodeValue(string15);
                }
                Node node10 = node2.getFirstChild();
                if (node10 == null) break;
                this.serialize(node10, outputStream, bl);
                break;
            }
            case 10: {
                String string18;
                String string19;
                DocumentType documentType = (DocumentType)node2;
                outputStream.write(60);
                outputStream.write(33);
                outputStream.write(this.encodeText("DOCTYPE "));
                String string20 = documentType.getNodeName();
                outputStream.write(this.encodeText(string20));
                String string21 = documentType.getPublicId();
                if (string21 != null) {
                    outputStream.write(this.encodeText(" PUBLIC "));
                    outputStream.write(39);
                    outputStream.write(this.encodeText(string21));
                    outputStream.write(39);
                }
                if ((string19 = documentType.getSystemId()) != null) {
                    outputStream.write(this.encodeText(" SYSTEM "));
                    outputStream.write(39);
                    outputStream.write(this.encodeText(string19));
                    outputStream.write(39);
                }
                if ((string18 = documentType.getInternalSubset()) != null) {
                    outputStream.write(this.encodeText(string18));
                }
                outputStream.write(62);
                outputStream.write(this.eol.getBytes(this.encoding));
                break;
            }
            case 5: {
                String string22 = "&" + node2.getNodeValue() + ";";
                outputStream.write(this.encodeText(string22));
                break;
            }
            case 7: {
                String string23 = "<?" + node2.getNodeName() + " " + node2.getNodeValue() + "?>";
                outputStream.write(this.encodeText(string23));
                Node node11 = node2.getParentNode();
                if (node11 == null || node11.getNodeType() != 9) break;
                outputStream.write(this.encodeText(this.eol));
            }
        }
        if (bl2) {
            this.undefine(string);
        }
    }

    boolean isDefined(String string) {
        return XMLConstants.XML_NS_URI.equals(string) || XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(string) || this.namespaces.containsKey(string);
    }

    String define(String string, String string2) {
        while (this.namespaces.containsValue(string2)) {
            string2 = string2 + "_";
        }
        this.namespaces.put(string, string2);
        return string2;
    }

    void undefine(String string) {
        this.namespaces.remove(string);
    }

    final byte[] encodeText(String string) throws IOException {
        int n;
        Object object;
        this.encoder.reset();
        if (!this.encoder.canEncode(string)) {
            object = new StringBuffer();
            n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (this.encoder.canEncode(c)) {
                    ((StringBuffer)object).append(c);
                    continue;
                }
                String string2 = Integer.toHexString(c);
                ((StringBuffer)object).append("&#x");
                ((StringBuffer)object).append(string2);
                ((StringBuffer)object).append(';');
            }
            string = ((StringBuffer)object).toString();
        }
        object = this.encoder.encode(CharBuffer.wrap(string));
        n = ((Buffer)object).limit() - ((Buffer)object).position();
        if (((ByteBuffer)object).hasArray()) {
            byte[] byArray = ((ByteBuffer)object).array();
            if (byArray.length > n) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray = byArray2;
            }
            return byArray;
        }
        ((Buffer)object).flip();
        byte[] byArray = new byte[n];
        ((ByteBuffer)object).get(byArray, 0, n);
        return byArray;
    }

    String encode(String string, boolean bl, boolean bl2) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                if (this.mode == 1 && i + 1 < n && string.charAt(i + 1) == '{') {
                    if (stringBuffer == null) continue;
                    stringBuffer.append(c);
                    continue;
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\'' && bl2) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                if (this.mode == 1) {
                    stringBuffer.append("&#x27;");
                    continue;
                }
                stringBuffer.append("&apos;");
                continue;
            }
            if (c == '\"' && bl2) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                stringBuffer.append("&quot;");
                continue;
            }
            if (bl) {
                if (c < ' ') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.substring(0, i));
                    }
                    stringBuffer.append('&');
                    stringBuffer.append('#');
                    stringBuffer.append((int)c);
                    stringBuffer.append(';');
                    continue;
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(c);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        if (stringBuffer == null) {
            return string;
        }
        return stringBuffer.toString();
    }

    String toString(Node node2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.serialize(node2, byteArrayOutputStream);
            return new String(byteArrayOutputStream.toByteArray(), this.encoding);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    boolean isHTMLBoolean(Attr attr, String string) {
        Collection collection;
        string = string.toLowerCase();
        Element element = attr.getOwnerElement();
        String string2 = element.getLocalName();
        if (string2 == null) {
            string2 = element.getNodeName();
        }
        return (collection = (Collection)HTML_BOOLEAN_ATTRIBUTES.get(string2 = string2.toLowerCase())) != null && collection.contains(string);
    }

    static {
        HashSet hashSet = new HashSet();
        hashSet.add("nohref");
        HTML_BOOLEAN_ATTRIBUTES.put("area", hashSet);
        hashSet = new HashSet();
        hashSet.add("ismap");
        HTML_BOOLEAN_ATTRIBUTES.put("img", hashSet);
        hashSet = new HashSet();
        hashSet.add("declare");
        HTML_BOOLEAN_ATTRIBUTES.put("object", hashSet);
        hashSet = new HashSet();
        hashSet.add("noshade");
        HTML_BOOLEAN_ATTRIBUTES.put("hr", hashSet);
        hashSet = new HashSet();
        hashSet.add("compact");
        HTML_BOOLEAN_ATTRIBUTES.put("dl", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("ol", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("ul", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("dir", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("menu", hashSet);
        hashSet = new HashSet();
        hashSet.add("checked");
        hashSet.add("disabled");
        hashSet.add("readonly");
        hashSet.add("ismap");
        HTML_BOOLEAN_ATTRIBUTES.put("input", hashSet);
        hashSet = new HashSet();
        hashSet.add("multiple");
        hashSet.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("select", hashSet);
        hashSet = new HashSet();
        hashSet.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("optgroup", hashSet);
        hashSet = new HashSet();
        hashSet.add("selected");
        hashSet.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("option", hashSet);
        hashSet = new HashSet();
        hashSet.add("disabled");
        hashSet.add("readonly");
        HTML_BOOLEAN_ATTRIBUTES.put("textarea", hashSet);
        hashSet = new HashSet();
        hashSet.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("button", hashSet);
        hashSet = new HashSet();
        hashSet.add("nowrap");
        HTML_BOOLEAN_ATTRIBUTES.put("th", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("td", hashSet);
        hashSet = new HashSet();
        hashSet.add("noresize");
        HTML_BOOLEAN_ATTRIBUTES.put("frame", hashSet);
        hashSet = new HashSet();
        hashSet.add("defer");
        HTML_BOOLEAN_ATTRIBUTES.put("script", hashSet);
    }
}

