/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Test;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public final class NodeTypeTest
extends Test {
    final short type;
    final String data;

    public NodeTypeTest(short s) {
        this(s, null);
    }

    public NodeTypeTest(short s, String string) {
        this.type = s;
        this.data = string;
    }

    public short getNodeType() {
        return this.type;
    }

    public String getData() {
        return this.data;
    }

    public boolean matches(Node node2, int n, int n2) {
        short s = node2.getNodeType();
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                if (this.type > 0) {
                    if (s != this.type) {
                        return false;
                    }
                    if (this.data != null && !this.data.equals(node2.getNodeValue())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public Test clone(Object object) {
        return new NodeTypeTest(this.type, this.data);
    }

    public boolean references(QName qName) {
        return false;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "node()";
            }
            case 3: {
                return "text()";
            }
            case 8: {
                return "comment()";
            }
            case 7: {
                if (this.data != null) {
                    return "processing-instruction('" + this.data + "')";
                }
                return "processing-instruction()";
            }
        }
        throw new IllegalStateException();
    }
}

