/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String PAGE_START = "First";
    public static final String PAGE_END = "Last";
    public static final String LINE_START = "Before";
    public static final String LINE_END = "After";
    private static final long serialVersionUID = -8658291919501921765L;
    private Component north;
    private Component south;
    private Component east;
    private Component west;
    private Component center;
    private Component firstLine;
    private Component lastLine;
    private Component firstItem;
    private Component lastItem;
    private int hgap;
    private int vgap;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int PREF = 2;

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("Constraint must be a string");
        }
        this.addLayoutComponent((String)object, component);
    }

    public void addLayoutComponent(String string, Component component) {
        String string2 = string;
        if (string2 == null || string2.equals(CENTER)) {
            this.center = component;
        } else if (string2.equals(NORTH)) {
            this.north = component;
        } else if (string2.equals(SOUTH)) {
            this.south = component;
        } else if (string2.equals(EAST)) {
            this.east = component;
        } else if (string2.equals(WEST)) {
            this.west = component;
        } else if (string2.equals("First")) {
            this.firstLine = component;
        } else if (string2.equals("Last")) {
            this.lastLine = component;
        } else if (string2.equals("Before")) {
            this.firstItem = component;
        } else if (string2.equals("After")) {
            this.lastItem = component;
        } else {
            throw new IllegalArgumentException("Constraint value not valid: " + string2);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (this.north == component) {
            this.north = null;
        }
        if (this.south == component) {
            this.south = null;
        }
        if (this.east == component) {
            this.east = null;
        }
        if (this.west == component) {
            this.west = null;
        }
        if (this.center == component) {
            this.center = null;
        }
        if (this.firstItem == component) {
            this.firstItem = null;
        }
        if (this.lastItem == component) {
            this.lastItem = null;
        }
        if (this.firstLine == component) {
            this.firstLine = null;
        }
        if (this.lastLine == component) {
            this.lastLine = null;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calcSize(container, 0);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calcSize(container, 2);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.calcSize(container, 1);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets;
            try {
                insets = container.getInsets();
                ComponentOrientation componentOrientation = container.getComponentOrientation();
                boolean bl = componentOrientation.isLeftToRight();
                Component component = this.north;
                Component component2 = this.east;
                Component component3 = this.south;
                Component component4 = this.west;
                if (this.firstLine != null) {
                    component = this.firstLine;
                }
                if (this.lastLine != null) {
                    component3 = this.lastLine;
                }
                if (this.firstItem != null) {
                    if (bl) {
                        component4 = this.firstItem;
                    } else {
                        component2 = this.firstItem;
                    }
                }
                if (this.lastItem != null) {
                    if (bl) {
                        component2 = this.lastItem;
                    } else {
                        component4 = this.lastItem;
                    }
                }
                Dimension dimension = this.calcCompSize(this.center, 2);
                Dimension dimension2 = this.calcCompSize(component, 2);
                Dimension dimension3 = this.calcCompSize(component3, 2);
                Dimension dimension4 = this.calcCompSize(component2, 2);
                Dimension dimension5 = this.calcCompSize(component4, 2);
                int n = container.getWidth();
                int n2 = container.getHeight();
                int n3 = insets.left;
                int n4 = n3 + dimension5.width + (dimension5.width == 0 ? 0 : this.hgap);
                int n5 = n <= insets.right + dimension4.width ? n4 + dimension5.width + (dimension5.width == 0 ? 0 : this.hgap) : n - insets.right - dimension4.width;
                int n6 = n - insets.right - insets.left;
                int n7 = insets.top;
                int n8 = n7 + dimension2.height + (dimension2.height == 0 ? 0 : this.vgap);
                int n9 = Math.max(dimension4.height, Math.max(dimension5.height, dimension.height));
                int n10 = n2 <= insets.bottom + dimension3.height ? n8 + n9 + this.vgap : n2 - insets.bottom - dimension3.height;
                int n11 = n10 - n8 - (dimension3.height == 0 ? 0 : this.vgap);
                this.setBounds(this.center, n4, n8, n5 - n4 - (dimension5.width == 0 ? 0 : this.hgap), n11);
                this.setBounds(component, n3, n7, n6, dimension2.height);
                this.setBounds(component3, n3, n10, n6, dimension3.height);
                this.setBounds(component4, n3, n8, dimension5.width, n11);
                this.setBounds(component2, n5, n8, dimension4.width, n11);
            }
            finally {
                insets = null;
            }
            return;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    private void setBounds(Component component, int n, int n2, int n3, int n4) {
        if (component == null) {
            return;
        }
        component.setBounds(n, n2, n3, n4);
    }

    private Dimension calcCompSize(Component component, int n) {
        if (component == null || !component.isVisible()) {
            return new Dimension(0, 0);
        }
        if (n == 0) {
            return component.getMinimumSize();
        }
        if (n == 1) {
            return component.getMaximumSize();
        }
        return component.getPreferredSize();
    }

    private Dimension calcSize(Container container, int n) {
        Object object = container.getTreeLock();
        synchronized (object) {
            try {
                int n2;
                Insets insets = container.getInsets();
                ComponentOrientation componentOrientation = container.getComponentOrientation();
                boolean bl = componentOrientation.isLeftToRight();
                Component component = this.north;
                Component component2 = this.east;
                Component component3 = this.south;
                Component component4 = this.west;
                if (this.firstLine != null) {
                    component = this.firstLine;
                }
                if (this.lastLine != null) {
                    component3 = this.lastLine;
                }
                if (this.firstItem != null) {
                    if (bl) {
                        component4 = this.firstItem;
                    } else {
                        component2 = this.firstItem;
                    }
                }
                if (this.lastItem != null) {
                    if (bl) {
                        component2 = this.lastItem;
                    } else {
                        component4 = this.lastItem;
                    }
                }
                Dimension dimension = this.calcCompSize(component, n);
                Dimension dimension2 = this.calcCompSize(component3, n);
                Dimension dimension3 = this.calcCompSize(component2, n);
                Dimension dimension4 = this.calcCompSize(component4, n);
                Dimension dimension5 = this.calcCompSize(this.center, n);
                int n3 = dimension3.width + dimension5.width + dimension4.width + this.hgap * 2;
                if (n3 < dimension3.width || n3 < dimension5.width || n3 < dimension5.width) {
                    n3 = Integer.MAX_VALUE;
                }
                if (dimension.width > n3) {
                    n3 = dimension.width;
                }
                if (dimension2.width > n3) {
                    n3 = dimension2.width;
                }
                n3 += insets.left + insets.right;
                int n4 = dimension3.height;
                if (dimension5.height > n4) {
                    n4 = dimension5.height;
                }
                if (dimension4.height > n4) {
                    n4 = dimension4.height;
                }
                n4 = (n2 = n4 + (dimension.height + dimension2.height + this.vgap * 2 + insets.top + insets.bottom)) < n4 ? Integer.MAX_VALUE : n2;
                Dimension dimension6 = new Dimension(n3, n4);
                Object var20_20 = null;
                return dimension6;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                throw throwable;
            }
        }
    }

    public Component getLayoutComponent(Object object) {
        if (object == CENTER) {
            return this.center;
        }
        if (object == NORTH) {
            return this.north;
        }
        if (object == EAST) {
            return this.east;
        }
        if (object == SOUTH) {
            return this.south;
        }
        if (object == WEST) {
            return this.west;
        }
        if (object == "First") {
            return this.firstLine;
        }
        if (object == "Last") {
            return this.lastLine;
        }
        if (object == "Before") {
            return this.firstItem;
        }
        if (object == "After") {
            return this.lastItem;
        }
        throw new IllegalArgumentException("constraint " + object + " is not recognized");
    }

    public Component getLayoutComponent(Container container, Object object) {
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        if (object == CENTER) {
            return this.center;
        }
        if (object == NORTH) {
            return this.north;
        }
        if (object == SOUTH) {
            return this.south;
        }
        if (object == WEST) {
            if (componentOrientation.isLeftToRight()) {
                if (this.firstItem == null) {
                    return this.west;
                }
                return this.firstItem;
            }
            if (this.lastItem == null) {
                return this.west;
            }
            return this.lastItem;
        }
        if (object == EAST) {
            if (componentOrientation.isLeftToRight()) {
                if (this.lastItem == null) {
                    return this.east;
                }
                return this.lastItem;
            }
            if (this.firstItem == null) {
                return this.east;
            }
            return this.firstItem;
        }
        throw new IllegalArgumentException("constraint " + object + " is not recognized");
    }

    public Object getConstraints(Component component) {
        if (component == null) {
            return null;
        }
        if (component == this.center) {
            return CENTER;
        }
        if (component == this.north) {
            return NORTH;
        }
        if (component == this.east) {
            return EAST;
        }
        if (component == this.south) {
            return SOUTH;
        }
        if (component == this.west) {
            return WEST;
        }
        if (component == this.firstLine) {
            return "First";
        }
        if (component == this.lastLine) {
            return "Last";
        }
        if (component == this.firstItem) {
            return "Before";
        }
        if (component == this.lastItem) {
            return "After";
        }
        return null;
    }

    static {
        NORTH = NORTH;
        SOUTH = SOUTH;
        EAST = EAST;
        WEST = WEST;
        CENTER = CENTER;
        BEFORE_FIRST_LINE = "First";
        AFTER_LAST_LINE = "Last";
        BEFORE_LINE_BEGINS = "Before";
        AFTER_LINE_ENDS = "After";
        PAGE_START = "First";
        PAGE_END = "Last";
        LINE_START = "Before";
        LINE_END = "After";
    }
}

