/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.accessibility.Accessible;

public class Container
extends Component {
    private static final long serialVersionUID = 4613797578919906343L;
    int ncomponents;
    Component[] component;
    LayoutManager layoutMgr;
    LightweightDispatcher dispatcher;
    Dimension maxSize;
    boolean focusCycleRoot;
    int containerSerializedDataVersion;
    transient ContainerListener containerListener;
    transient PropertyChangeSupport changeSupport;
    private FocusTraversalPolicy focusTraversalPolicy;
    transient Set[] focusTraversalKeys;

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (n < 0 || n >= this.ncomponents) {
                    throw new ArrayIndexOutOfBoundsException("no such component");
                }
                Component component = this.component[n];
                Object var4_4 = null;
                return component;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public Component[] getComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                Component[] componentArray = new Component[this.ncomponents];
                if (this.ncomponents > 0) {
                    System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
                }
                Component[] componentArray2 = componentArray;
                Object var4_4 = null;
                return componentArray2;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    protected void swapComponents(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component;
            try {
                if (n < 0 || n >= this.component.length || n2 < 0 || n2 >= this.component.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                component = this.component[n];
                this.component[n] = this.component[n2];
                this.component[n2] = component;
            }
            finally {
                component = null;
            }
            return;
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        if (this.peer == null) {
            return new Insets(0, 0, 0, 0);
        }
        return ((ContainerPeer)this.peer).getInsets();
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            ContainerEvent containerEvent;
            try {
                Object[] objectArray;
                if (n > this.ncomponents || n < 0 && n != -1 || component instanceof Window || component instanceof Container && ((Container)component).isAncestorOf(this)) {
                    throw new IllegalArgumentException();
                }
                if (component.parent != null) {
                    component.parent.remove(component);
                }
                component.parent = this;
                if (this.peer != null) {
                    component.addNotify();
                    if (component.isLightweight()) {
                        this.enableEvents(component.eventMask);
                        if (!this.isLightweight()) {
                            this.enableEvents(8192);
                        }
                    }
                }
                component.invalidate();
                if (this.component == null) {
                    this.component = new Component[4];
                }
                if (this.ncomponents >= this.component.length) {
                    int n2 = this.component.length * 2;
                    objectArray = new Component[n2];
                    System.arraycopy(this.component, 0, objectArray, 0, this.ncomponents);
                    this.component = objectArray;
                }
                if (n == -1) {
                    this.component[this.ncomponents++] = component;
                } else {
                    System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
                    this.component[n] = component;
                    ++this.ncomponents;
                }
                if (this.layoutMgr != null) {
                    if (this.layoutMgr instanceof LayoutManager2) {
                        LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                        layoutManager2.addLayoutComponent(component, object);
                    } else if (object instanceof String) {
                        this.layoutMgr.addLayoutComponent((String)object, component);
                    } else {
                        this.layoutMgr.addLayoutComponent(null, component);
                    }
                }
                containerEvent = new ContainerEvent(this, 300, component);
                objectArray = this.getContainerListeners();
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i].componentAdded(containerEvent);
                }
                this.repaint(component.getX(), component.getY(), component.getWidth(), component.getHeight());
            }
            finally {
                containerEvent = null;
            }
            return;
        }
    }

    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component;
            block6: {
                try {
                    component = this.component[n];
                    ComponentListener[] componentListenerArray = component.getComponentListeners();
                    for (int i = 0; i < componentListenerArray.length; ++i) {
                        component.removeComponentListener(componentListenerArray[i]);
                    }
                    if (component.isShowing()) {
                        component.removeNotify();
                    }
                    System.arraycopy(this.component, n + 1, this.component, n, this.ncomponents - n - 1);
                    this.component[--this.ncomponents] = null;
                    this.invalidate();
                    if (this.layoutMgr != null) {
                        this.layoutMgr.removeLayoutComponent(component);
                    }
                    component.parent = null;
                    if (!this.isShowing()) break block6;
                    ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                    this.getToolkit().getSystemEventQueue().postEvent(containerEvent);
                    this.repaint();
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            component = null;
        }
    }

    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = 0; i < this.ncomponents; ++i) {
                    if (this.component[i] != component) continue;
                    this.remove(i);
                    break;
                }
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                while (this.ncomponents > 0) {
                    this.remove(0);
                }
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        this.invalidate();
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        if (this.layoutMgr != null) {
            this.layoutMgr.layoutContainer(this);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            layoutManager2.invalidateLayout(this);
        }
    }

    public void validate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            block3: {
                try {
                    if (this.isValid() || this.peer == null) break block3;
                    this.validateTree();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            Object var2_2 = null;
        }
    }

    void invalidateTree() {
        super.invalidate();
        for (int i = 0; i < this.ncomponents; ++i) {
            Component component = this.component[i];
            component.invalidate();
            if (!(component instanceof Container)) continue;
            ((Container)component).invalidateTree();
        }
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            layoutManager2.invalidateLayout(this);
        }
    }

    protected void validateTree() {
        Component component;
        int n;
        if (this.valid) {
            return;
        }
        ContainerPeer containerPeer = null;
        if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
            containerPeer = (ContainerPeer)this.peer;
            containerPeer.beginValidate();
        }
        for (n = 0; n < this.ncomponents; ++n) {
            component = this.component[n];
            if (component.getPeer() != null) continue;
            component.addNotify();
        }
        this.doLayout();
        for (n = 0; n < this.ncomponents; ++n) {
            component = this.component[n];
            if (component.isValid()) continue;
            if (component instanceof Container) {
                ((Container)component).validateTree();
                continue;
            }
            this.component[n].validate();
        }
        this.valid = true;
        if (containerPeer != null) {
            containerPeer.endValidate();
        }
    }

    public void setFont(Font font) {
        if (font != null && (this.font == null || !this.font.equals(font)) || font == null) {
            super.setFont(font);
            this.invalidateTree();
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Dimension preferredSize() {
        Object object = Component.treeLock;
        synchronized (object) {
            try {
                if (this.valid && this.prefSize != null) {
                    return new Dimension(this.prefSize);
                }
                LayoutManager layoutManager = this.getLayout();
                if (layoutManager == null) return super.preferredSize();
                Dimension dimension = layoutManager.preferredLayoutSize(this);
                if (!this.valid) return new Dimension(dimension);
                this.prefSize = dimension;
                return new Dimension(dimension);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.valid && this.minSize != null) {
            return new Dimension(this.minSize);
        }
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager != null) {
            this.minSize = layoutManager.minimumLayoutSize(this);
            return this.minSize;
        }
        return super.minimumSize();
    }

    public Dimension getMaximumSize() {
        if (this.valid && this.maxSize != null) {
            return new Dimension(this.maxSize);
        }
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            this.maxSize = layoutManager2.maximumLayoutSize(this);
            return this.maxSize;
        }
        return super.getMaximumSize();
    }

    public float getAlignmentX() {
        LayoutManager layoutManager = this.getLayout();
        float f = 0.0f;
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            f = layoutManager2.getLayoutAlignmentX(this);
        } else {
            f = super.getAlignmentX();
        }
        return f;
    }

    public float getAlignmentY() {
        LayoutManager layoutManager = this.getLayout();
        float f = 0.0f;
        if (layoutManager != null && layoutManager instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)layoutManager;
            f = layoutManager2.getLayoutAlignmentY(this);
        } else {
            f = super.getAlignmentY();
        }
        return f;
    }

    public void paint(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.visitChildren(graphics, GfxPaintVisitor.INSTANCE, false);
    }

    public void update(Graphics graphics) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.paint(graphics);
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        this.visitChildren(graphics, GfxPrintVisitor.INSTANCE, true);
    }

    public void paintComponents(Graphics graphics) {
        this.paint(graphics);
        this.visitChildren(graphics, GfxPaintAllVisitor.INSTANCE, true);
    }

    public void printComponents(Graphics graphics) {
        super.paint(graphics);
        this.visitChildren(graphics, GfxPrintAllVisitor.INSTANCE, true);
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        return (ContainerListener[])AWTEventMulticaster.getListeners(this.containerListener, Container.class$("java.awt.event.ContainerListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == Container.class$("java.awt.event.ContainerListener")) {
            return this.getContainerListeners();
        }
        return super.getListeners(clazz);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        if (this.containerListener == null) {
            return;
        }
        switch (containerEvent.id) {
            case 300: {
                this.containerListener.componentAdded(containerEvent);
                break;
            }
            case 301: {
                this.containerListener.componentRemoved(containerEvent);
            }
        }
    }

    public void deliverEvent(Event event) {
        if (!this.handleEvent(event)) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Container container;
                block4: {
                    try {
                        container = this.getParent();
                        if (container == null) break block4;
                        ((Component)container).deliverEvent(event);
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        throw throwable;
                    }
                }
                container = null;
            }
        }
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component locate(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (!this.contains(n, n2)) {
                    return null;
                }
                int n3 = 0;
                while (n3 < this.ncomponents) {
                    int n4;
                    int n5;
                    if (this.component[n3].isVisible() && this.component[n3].contains(n5 = n - this.component[n3].x, n4 = n2 - this.component[n3].y)) {
                        return this.component[n3];
                    }
                    ++n3;
                }
                return this;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                throw throwable;
            }
        }
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component findComponentAt(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (!this.contains(n, n2)) {
                    return null;
                }
                int n3 = 0;
                while (n3 < this.ncomponents) {
                    if (this.component[n3].isVisible()) {
                        int n4 = n - this.component[n3].x;
                        int n5 = n2 - this.component[n3].y;
                        if (this.component[n3] instanceof Container) {
                            Container container = (Container)this.component[n3];
                            Component component = container.findComponentAt(n4, n5);
                            if (component != null) {
                                return component;
                            }
                        } else if (this.component[n3].contains(n4, n5)) {
                            return this.component[n3];
                        }
                    }
                    ++n3;
                }
                return this;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Component findComponentForMouseEventAt(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (!this.contains(n, n2)) {
                    return null;
                }
                for (int i = 0; i < this.ncomponents; ++i) {
                    if (!this.component[i].isVisible()) continue;
                    int n3 = n - this.component[i].x;
                    int n4 = n2 - this.component[i].y;
                    if (this.component[i] instanceof Container) {
                        Container container = (Container)this.component[i];
                        Component component = container.findComponentForMouseEventAt(n3, n4);
                        if (component == null) continue;
                        return component;
                    }
                    if (!this.component[i].contains(n3, n4)) continue;
                    return this.component[i];
                }
                if (this.getMouseListeners().length != 0) return this;
                return null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                throw throwable;
            }
        }
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyContainerChildren();
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].removeNotify();
                }
                super.removeNotify();
            }
            finally {
                Object var2_3 = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAncestorOf(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                while (true) {
                    if (component == null) {
                        return false;
                    }
                    if (component == this) {
                        return true;
                    }
                    component = component.getParent();
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                throw throwable;
            }
        }
    }

    protected String paramString() {
        if (this.layoutMgr == null) {
            return super.paramString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.paramString());
        stringBuffer.append(",layout=");
        stringBuffer.append(this.layoutMgr.getClass().getName());
        return stringBuffer.toString();
    }

    public void list(PrintStream printStream, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                super.list(printStream, n);
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].list(printStream, n + 2);
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
        }
    }

    public void list(PrintWriter printWriter, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                super.list(printWriter, n);
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].list(printWriter, n + 2);
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
        }
    }

    public void setFocusTraversalKeys(int n, Set set) {
        Set set2;
        Set set3;
        Set set4;
        Object object;
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        if (set == null) {
            for (object = this.getParent(); object != null; object = ((Component)object).getParent()) {
                if (!((Container)object).areFocusTraversalKeysSet(n)) continue;
                set = ((Container)object).getFocusTraversalKeys(n);
                break;
            }
            if (set == null) {
                set = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
            }
        }
        switch (n) {
            case 0: {
                set4 = this.getFocusTraversalKeys(1);
                set3 = this.getFocusTraversalKeys(2);
                set2 = this.getFocusTraversalKeys(3);
                object = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                set4 = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(2);
                set2 = this.getFocusTraversalKeys(3);
                object = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                set4 = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(3);
                object = "upCycleFocusTraversalKeys";
                break;
            }
            case 3: {
                set4 = this.getFocusTraversalKeys(0);
                set3 = this.getFocusTraversalKeys(1);
                set2 = this.getFocusTraversalKeys(2);
                object = "downCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = set.size();
        Iterator iterator = set.iterator();
        while (--n2 >= 0) {
            Object object2 = iterator.next();
            if (object2 instanceof AWTKeyStroke && !set4.contains(object2) && !set3.contains(object2) && !set2.contains(object2) && ((AWTKeyStroke)object2).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[4];
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        this.firePropertyChange((String)object, this.focusTraversalKeys[n], set);
        this.focusTraversalKeys[n] = set;
    }

    public Set getFocusTraversalKeys(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        Set set = null;
        if (this.focusTraversalKeys != null) {
            set = this.focusTraversalKeys[n];
        }
        if (set == null && this.parent != null) {
            set = this.parent.getFocusTraversalKeys(n);
        }
        if (set == null) {
            return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n);
        }
        return set;
    }

    public boolean areFocusTraversalKeysSet(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n] != null;
    }

    public boolean isFocusCycleRoot(Container container) {
        if (this == container && this.isFocusCycleRoot()) {
            return true;
        }
        Container container2 = this.getFocusCycleRootAncestor();
        return container == container2;
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        this.focusTraversalPolicy = focusTraversalPolicy;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusCycleRoot()) {
            return null;
        }
        if (this.focusTraversalPolicy == null) {
            Container container = this.getFocusCycleRootAncestor();
            if (container != this) {
                return container.getFocusTraversalPolicy();
            }
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            return keyboardFocusManager.getDefaultFocusTraversalPolicy();
        }
        return this.focusTraversalPolicy;
    }

    public boolean isFocusTraversalPolicySet() {
        return this.focusTraversalPolicy == null;
    }

    public void setFocusCycleRoot(boolean bl) {
        this.focusCycleRoot = bl;
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public void transferFocusDownCycle() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.downFocusCycle(this);
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation == null) {
            throw new NullPointerException();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    private void visitChildren(Graphics graphics, GfxVisitor gfxVisitor, boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = this.ncomponents - 1; i >= 0; --i) {
                    boolean bl2;
                    Component component = this.component[i];
                    boolean bl3 = bl2 = component.isVisible() && (component.isLightweight() || !bl);
                    if (!bl2) continue;
                    this.visitChild(graphics, gfxVisitor, component);
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
    }

    private void visitChild(Graphics graphics, GfxVisitor gfxVisitor, Component component) {
        Rectangle rectangle;
        Rectangle rectangle2 = component.getBounds();
        Rectangle rectangle3 = graphics.getClipBounds();
        if (rectangle3 == null) {
            rectangle3 = rectangle2;
        }
        if ((rectangle = rectangle3.intersection(rectangle2)).isEmpty()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            bl = true;
            graphics.translate(rectangle2.x, rectangle2.y);
            bl2 = true;
            gfxVisitor.visit(component, graphics);
        }
        finally {
            Object var9_9 = null;
            if (bl2) {
                graphics.translate(-rectangle2.x, -rectangle2.y);
            }
            if (bl) {
                graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (this.dispatcher != null && this.dispatcher.handleEvent(aWTEvent)) {
            return;
        }
        if (aWTEvent.id <= 301 && aWTEvent.id >= 300 && (this.containerListener != null || (this.eventMask & (long)2) != 0L)) {
            this.processEvent(aWTEvent);
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    boolean eventTypeEnabled(int n) {
        if (n <= 301 && n >= 300) {
            return this.containerListener != null || (this.eventMask & (long)2) != 0L;
        }
        return super.eventTypeEnabled(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Component findNextFocusComponent(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                int n;
                int n2;
                if (component != null) {
                    for (n2 = 0; n2 < this.ncomponents && this.component[n2] != component; ++n2) {
                    }
                    n = n2;
                    if (n == 0) {
                        n = this.ncomponents;
                    }
                    ++n2;
                } else {
                    n2 = 0;
                    n = this.ncomponents;
                }
                int n3 = n2;
                while (n3 != n) {
                    if (n3 >= this.ncomponents) {
                        if (this.parent != null) {
                            return this.parent.findNextFocusComponent(this);
                        }
                        n3 -= this.ncomponents;
                    }
                    if (this.component[n3] instanceof Container) {
                        Component component2 = this.component[n3];
                        if ((component2 = component2.findNextFocusComponent(null)) != null) {
                            return component2;
                        }
                    } else if (this.component[n3].isFocusTraversable()) {
                        return this.component[n3];
                    }
                    ++n3;
                }
                return null;
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                throw throwable;
            }
        }
    }

    private void addNotifyContainerChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                int n = this.ncomponents;
                while (--n >= 0) {
                    this.component[n].addNotify();
                    if (!this.component[n].isLightweight()) continue;
                    if (!this.isLightweight() && this.dispatcher == null) {
                        this.dispatcher = new LightweightDispatcher(this);
                    }
                    if (this.dispatcher != null) {
                        this.dispatcher.enableEvents(this.component[n].eventMask);
                    }
                    this.enableEvents(this.component[n].eventMask);
                    if (this.peer == null || this.isLightweight()) continue;
                    this.enableEvents(8192);
                }
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        while (string != null) {
            Object object = objectInputStream.readObject();
            if ("containerL".equals(string)) {
                this.addContainerListener((ContainerListener)object);
            } else if ("focusTraversalPolicy".equals(string)) {
                this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
            }
            string = (String)objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        if (this.focusTraversalPolicy instanceof Serializable) {
            objectOutputStream.writeObject(this.focusTraversalPolicy);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        private /* synthetic */ Container this$0;
        private static final long serialVersionUID = 5081320404842566097L;
        protected ContainerListener accessibleContainerHandler;

        private /* synthetic */ void finit$() {
            this.accessibleContainerHandler = new AccessibleContainerHandler(this);
        }

        protected AccessibleAWTContainer(Container container) {
            this.this$0 = container;
            super(container);
            this.finit$();
            container.addContainerListener(this.accessibleContainerHandler);
        }

        public int getAccessibleChildrenCount() {
            Object object = this.this$0.getTreeLock();
            synchronized (object) {
                try {
                    int n;
                    int n2 = 0;
                    int n3 = n = this.this$0.component == null ? 0 : this.this$0.component.length;
                    while (--n >= 0) {
                        if (!(this.this$0.component[n] instanceof Accessible)) continue;
                        ++n2;
                    }
                    int n4 = n2;
                    Object var5_5 = null;
                    return n4;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Accessible getAccessibleChild(int n) {
            Object object = this.this$0.getTreeLock();
            synchronized (object) {
                try {
                    if (this.this$0.component == null) {
                        return null;
                    }
                    int n2 = -1;
                    while (n >= 0 && ++n2 < this.this$0.component.length) {
                        if (!(this.this$0.component[n2] instanceof Accessible)) continue;
                        --n;
                    }
                    if (n >= 0) return null;
                    return (Accessible)((Object)this.this$0.component[n2]);
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    throw throwable;
                }
            }
        }

        public Accessible getAccessibleAt(Point point) {
            Component component = this.this$0.getComponentAt(point.x, point.y);
            if (component != this.this$0 && component instanceof Accessible) {
                return (Accessible)((Object)component);
            }
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            private /* synthetic */ AccessibleAWTContainer this$1;

            protected AccessibleContainerHandler(AccessibleAWTContainer accessibleAWTContainer) {
                this.this$1 = accessibleAWTContainer;
            }

            public void componentAdded(ContainerEvent containerEvent) {
                this.this$1.firePropertyChange("AccessibleChild", null, containerEvent.getChild());
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                this.this$1.firePropertyChange("AccessibleChild", containerEvent.getChild(), null);
            }
        }
    }

    static class GfxPrintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintAllVisitor();

        public void visit(Component component, Graphics graphics) {
            component.printAll(graphics);
        }

        GfxPrintAllVisitor() {
        }
    }

    static class GfxPaintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintAllVisitor();

        public void visit(Component component, Graphics graphics) {
            component.paintAll(graphics);
        }

        GfxPaintAllVisitor() {
        }
    }

    static class GfxPrintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintVisitor();

        public void visit(Component component, Graphics graphics) {
            component.print(graphics);
        }

        GfxPrintVisitor() {
        }
    }

    static class GfxPaintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintVisitor();

        public void visit(Component component, Graphics graphics) {
            component.paint(graphics);
        }

        GfxPaintVisitor() {
        }
    }

    static abstract class GfxVisitor {
        public abstract void visit(Component var1, Graphics var2);

        GfxVisitor() {
        }
    }
}

