/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class DefaultKeyboardFocusManager
extends KeyboardFocusManager {
    private AWTKeyStroke waitForKeyStroke;
    private SortedSet delayRequests;

    private /* synthetic */ void finit$() {
        this.waitForKeyStroke = null;
        this.delayRequests = new TreeSet();
    }

    public DefaultKeyboardFocusManager() {
        this.finit$();
    }

    public boolean dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            Window window = (Window)aWTEvent.getSource();
            if (aWTEvent.id == 205) {
                this.setGlobalActiveWindow(window);
            } else if (aWTEvent.id == 207) {
                this.setGlobalFocusedWindow(window);
            } else if (aWTEvent.id != 208 && aWTEvent.id != 206) {
                return false;
            }
            this.redispatchEvent(window, aWTEvent);
            return true;
        }
        if (aWTEvent instanceof FocusEvent) {
            Component component = (Component)aWTEvent.getSource();
            if (aWTEvent.id == 1004) {
                Container container;
                if (!(component instanceof Window)) {
                    if (((FocusEvent)aWTEvent).isTemporary()) {
                        this.setGlobalFocusOwner(component);
                    } else {
                        this.setGlobalPermanentFocusOwner(component);
                    }
                }
                for (container = component.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
                }
                if (container != null || component instanceof Window) {
                    Window window = container == null ? (Window)component : (Window)container;
                    Component component2 = this.getFocusOwner();
                    if (component2 != null && !(component2 instanceof Window)) {
                        window.setFocusOwner(component2);
                    }
                }
            } else if (aWTEvent.id == 1005) {
                if (((FocusEvent)aWTEvent).isTemporary()) {
                    this.setGlobalFocusOwner(null);
                } else {
                    this.setGlobalPermanentFocusOwner(null);
                }
            }
            this.redispatchEvent(component, aWTEvent);
            return true;
        }
        if (aWTEvent instanceof KeyEvent) {
            Object object;
            Iterator iterator = this.getKeyEventDispatchers().iterator();
            while (iterator.hasNext()) {
                object = (KeyEventDispatcher)iterator.next();
                if (!object.dispatchKeyEvent((KeyEvent)aWTEvent)) continue;
                return true;
            }
            object = this.getGlobalPermanentFocusOwner();
            if (object != null) {
                this.processKeyEvent((Component)object, (KeyEvent)aWTEvent);
            }
            if (aWTEvent.isConsumed()) {
                return true;
            }
            if (this.enqueueKeyEvent((KeyEvent)aWTEvent)) {
                return true;
            }
            return this.dispatchKeyEvent((KeyEvent)aWTEvent);
        }
        return false;
    }

    private boolean enqueueKeyEvent(KeyEvent keyEvent) {
        Iterator iterator = this.delayRequests.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            EventDelayRequest eventDelayRequest = (EventDelayRequest)iterator.next();
            if (keyEvent.getWhen() <= eventDelayRequest.timestamp) continue;
            eventDelayRequest.enqueueEvent(keyEvent);
            bl = true;
        }
        return bl;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Component component = this.getGlobalPermanentFocusOwner();
        if (component != null) {
            this.redispatchEvent(component, keyEvent);
        }
        Iterator iterator = this.getKeyEventPostProcessors().iterator();
        while (iterator.hasNext()) {
            KeyEventPostProcessor keyEventPostProcessor = (KeyEventPostProcessor)iterator.next();
            if (!keyEventPostProcessor.postProcessKeyEvent(keyEvent)) continue;
            return true;
        }
        if (this.postProcessKeyEvent(keyEvent)) {
            return true;
        }
        return true;
    }

    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        MenuBar menuBar;
        Window window;
        int n = keyEvent.getModifiersEx();
        if (keyEvent.getID() == 401 && (n & 0x80) != 0 && (window = this.getGlobalFocusedWindow()) instanceof Frame && (menuBar = ((Frame)window).getMenuBar()) != null) {
            int n2 = menuBar.getMenuCount();
            for (int i = 0; i < n2; ++i) {
                Menu menu = menuBar.getMenu(i);
                int n3 = menu.getItemCount();
                for (int j = 0; j < n3; ++j) {
                    MenuItem menuItem = menu.getItem(j);
                    MenuShortcut menuShortcut = menuItem.getShortcut();
                    if (!menuItem.isEnabled() || menuShortcut == null || menuShortcut.getKey() != keyEvent.getKeyCode() || (!menuShortcut.usesShiftModifier() || (n & 0x40) == 0) && (menuShortcut.usesShiftModifier() || (n & 0x40) != 0)) continue;
                    menuItem.dispatchEvent(new ActionEvent(menuItem, 1001, menuItem.getActionCommand(), n));
                    return true;
                }
            }
        }
        return false;
    }

    public void processKeyEvent(Component component, KeyEvent keyEvent) {
        AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
        AWTKeyStroke aWTKeyStroke2 = AWTKeyStroke.getAWTKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiersEx(), keyEvent.id != 402);
        if (this.waitForKeyStroke != null) {
            if (aWTKeyStroke.equals(this.waitForKeyStroke)) {
                this.waitForKeyStroke = null;
            }
            keyEvent.consume();
            return;
        }
        Set set = component.getFocusTraversalKeys(0);
        Set set2 = component.getFocusTraversalKeys(1);
        Set set3 = component.getFocusTraversalKeys(2);
        Set set4 = null;
        if (component instanceof Container) {
            set4 = component.getFocusTraversalKeys(3);
        }
        if (set.contains(aWTKeyStroke)) {
            this.waitForKeyStroke = aWTKeyStroke2;
            this.focusNextComponent(component);
            keyEvent.consume();
        } else if (set2.contains(aWTKeyStroke)) {
            this.waitForKeyStroke = aWTKeyStroke2;
            this.focusPreviousComponent(component);
            keyEvent.consume();
        } else if (set3.contains(aWTKeyStroke)) {
            this.waitForKeyStroke = aWTKeyStroke2;
            this.upFocusCycle(component);
            keyEvent.consume();
        } else if (component instanceof Container && set4.contains(aWTKeyStroke)) {
            this.waitForKeyStroke = aWTKeyStroke2;
            this.downFocusCycle((Container)component);
            keyEvent.consume();
        }
    }

    protected void enqueueKeyEvents(long l, Component component) {
        this.delayRequests.add(new EventDelayRequest(this, l, component));
    }

    protected void dequeueKeyEvents(long l, Component component) {
        if (l < 0L) {
            int n = this.delayRequests.size();
            if (n > 0) {
                this.delayRequests.remove(this.delayRequests.first());
            }
        } else {
            EventDelayRequest eventDelayRequest = new EventDelayRequest(this, l, component);
            if (this.delayRequests.contains(eventDelayRequest)) {
                EventDelayRequest eventDelayRequest2 = (EventDelayRequest)this.delayRequests.tailSet(eventDelayRequest).first();
                this.delayRequests.remove(eventDelayRequest2);
                eventDelayRequest2.dispatchEvents();
            }
        }
    }

    protected void discardKeyEvents(Component component) {
        Iterator iterator = this.delayRequests.iterator();
        while (iterator.hasNext()) {
            EventDelayRequest eventDelayRequest = (EventDelayRequest)iterator.next();
            if (eventDelayRequest.focusedComp != component && (!(component instanceof Container) || !((Container)component).isAncestorOf(eventDelayRequest.focusedComp))) continue;
            eventDelayRequest.discardEvents();
        }
    }

    public void focusPreviousComponent(Component component) {
        Component component2 = component == null ? this.getGlobalFocusOwner() : component;
        Container container = component2.getFocusCycleRootAncestor();
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        Component component3 = focusTraversalPolicy.getComponentBefore(container, component2);
        if (component3 != null) {
            component3.requestFocusInWindow();
        }
    }

    public void focusNextComponent(Component component) {
        Component component2 = component == null ? this.getGlobalFocusOwner() : component;
        Container container = component2.getFocusCycleRootAncestor();
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        Component component3 = focusTraversalPolicy.getComponentAfter(container, component2);
        if (component3 != null) {
            component3.requestFocusInWindow();
        }
    }

    public void upFocusCycle(Component component) {
        Component component2 = component == null ? this.getGlobalFocusOwner() : component;
        Container container = component2.getFocusCycleRootAncestor();
        if (container instanceof Window) {
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component3 = focusTraversalPolicy.getDefaultComponent(container);
            if (component3 != null) {
                component3.requestFocusInWindow();
            }
        } else {
            Container container2 = container.getFocusCycleRootAncestor();
            container.requestFocusInWindow();
            this.setGlobalCurrentFocusCycleRoot(container2);
        }
    }

    public void downFocusCycle(Container container) {
        if (container == null) {
            return;
        }
        if (container.isFocusCycleRoot(container)) {
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component = focusTraversalPolicy.getDefaultComponent(container);
            if (component != null) {
                component.requestFocusInWindow();
            }
            this.setGlobalCurrentFocusCycleRoot(container);
        }
    }

    private class EventDelayRequest
    implements Comparable {
        private /* synthetic */ DefaultKeyboardFocusManager this$0;
        private LinkedList enqueuedKeyEvents;
        public long timestamp;
        public Component focusedComp;

        private /* synthetic */ void finit$() {
            this.enqueuedKeyEvents = new LinkedList();
        }

        public EventDelayRequest(DefaultKeyboardFocusManager defaultKeyboardFocusManager, long l, Component component) {
            this.this$0 = defaultKeyboardFocusManager;
            this.finit$();
            this.timestamp = l;
            this.focusedComp = component;
        }

        public int compareTo(Object object) {
            if (!(object instanceof EventDelayRequest)) {
                throw new ClassCastException();
            }
            EventDelayRequest eventDelayRequest = (EventDelayRequest)object;
            if (eventDelayRequest.timestamp < this.timestamp) {
                return -1;
            }
            if (eventDelayRequest.timestamp == this.timestamp) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object object) {
            if (!(object instanceof EventDelayRequest) || object == null) {
                return false;
            }
            EventDelayRequest eventDelayRequest = (EventDelayRequest)object;
            return eventDelayRequest.timestamp == this.timestamp && eventDelayRequest.focusedComp == this.focusedComp;
        }

        public void enqueueEvent(KeyEvent keyEvent) {
            KeyEvent keyEvent2 = (KeyEvent)this.enqueuedKeyEvents.getLast();
            if (keyEvent2 != null && keyEvent.getWhen() < keyEvent2.getWhen()) {
                throw new RuntimeException("KeyEvents enqueued out-of-order");
            }
            if (keyEvent.getWhen() <= this.timestamp) {
                throw new RuntimeException("KeyEvents enqueued before starting timestamp");
            }
            this.enqueuedKeyEvents.add(keyEvent);
        }

        public void dispatchEvents() {
            int n = this.enqueuedKeyEvents.size();
            for (int i = 0; i < n; ++i) {
                KeyEvent keyEvent = (KeyEvent)this.enqueuedKeyEvents.remove(0);
                this.this$0.dispatchKeyEvent(keyEvent);
            }
        }

        public void discardEvents() {
            this.enqueuedKeyEvents.clear();
        }
    }
}

