/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.AWTUtilities;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;

class LightweightDispatcher
implements Serializable {
    private static final long serialVersionUID = 5184291520170872969L;
    private Container nativeContainer;
    private Cursor nativeCursor;
    private long eventMask;
    private transient Component pressedComponent;
    private transient Component lastComponentEntered;
    private transient int pressCount;

    LightweightDispatcher(Container container) {
        this.nativeContainer = container;
    }

    void enableEvents(long l) {
        this.eventMask |= l;
    }

    Component getDeepestComponentForMouseEventAt(Component component, int n, int n2) {
        if (component == null || !component.contains(n, n2)) {
            return null;
        }
        if (!(component instanceof Container)) {
            return component;
        }
        Container container = (Container)component;
        return container.findComponentForMouseEventAt(n, n2);
    }

    Component acquireComponentForMouseEvent(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2;
        Point point;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Component component = null;
        Container container = this.nativeContainer;
        Component component2 = null;
        Point point2 = mouseEvent.getPoint();
        while (component2 == null && container != null) {
            component2 = this.getDeepestComponentForMouseEventAt(container, point2.x, point2.y);
            if (component2 != null && (component2.eventMask & (long)mouseEvent.getID()) != 0L) continue;
            component2 = null;
            point2 = AWTUtilities.convertPoint(container, point2.x, point2.y, container.parent);
            container = container.parent;
        }
        if (component2 == this.nativeContainer) {
            component2 = null;
        }
        if (this.lastComponentEntered != null && this.lastComponentEntered.isShowing() && this.lastComponentEntered != component2) {
            if (AWTUtilities.isDescendingFrom(this.lastComponentEntered, this.nativeContainer)) {
                point = AWTUtilities.convertPoint(this.nativeContainer, n, n2, this.lastComponentEntered);
                mouseEvent2 = new MouseEvent(this.lastComponentEntered, 505, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                this.lastComponentEntered.dispatchEvent(mouseEvent2);
            }
            this.lastComponentEntered = null;
        }
        if (component2 != null) {
            component = component2;
            if (component2.isLightweight() && component2.isShowing() && component2 != this.nativeContainer && component2 != this.lastComponentEntered) {
                this.lastComponentEntered = component;
                point = AWTUtilities.convertPoint(this.nativeContainer, n, n2, this.lastComponentEntered);
                mouseEvent2 = new MouseEvent(this.lastComponentEntered, 504, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                this.lastComponentEntered.dispatchEvent(mouseEvent2);
            }
        }
        int n3 = mouseEvent.getModifiersEx() & 0x1C00;
        switch (mouseEvent.getButton()) {
            case 1: {
                n3 &= 0xFFFFFBFF;
                break;
            }
            case 2: {
                n3 &= 0xFFFFF7FF;
                break;
            }
            case 3: {
                n3 &= 0xFFFFEFFF;
            }
        }
        if (mouseEvent.getID() == 501 && n3 > 0 || mouseEvent.getID() == 506) {
            if (AWTUtilities.isDescendingFrom(this.pressedComponent, this.nativeContainer)) {
                component = this.pressedComponent;
            }
        } else if (mouseEvent.getID() == 500) {
            if (component2 != this.pressedComponent) {
                component = null;
                this.pressCount = 0;
            } else if (this.pressCount == 0) {
                this.pressedComponent = null;
            }
        }
        return component;
    }

    boolean handleEvent(AWTEvent aWTEvent) {
        MouseEvent mouseEvent;
        Component component;
        if (aWTEvent instanceof MouseEvent && (component = this.acquireComponentForMouseEvent(mouseEvent = (MouseEvent)aWTEvent)) != null && component.isShowing() && aWTEvent.getID() != 504 && aWTEvent.getID() != 505) {
            switch (aWTEvent.getID()) {
                case 501: {
                    if (this.pressCount++ != 0) break;
                    this.pressedComponent = component;
                    break;
                }
                case 502: {
                    if (--this.pressCount != 0 || component == this.pressedComponent) break;
                    this.pressedComponent = null;
                    this.pressCount = 0;
                }
            }
            MouseEvent mouseEvent2 = AWTUtilities.convertMouseEvent(this.nativeContainer, mouseEvent, component);
            component.dispatchEvent(mouseEvent2);
            if (mouseEvent2.isConsumed()) {
                aWTEvent.consume();
            }
        }
        return aWTEvent.isConsumed();
    }
}

