/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class ConvolveOp
implements BufferedImageOp,
RasterOp {
    public static final int EDGE_ZERO_FILL = 0;
    public static final int EDGE_NO_OP = 1;
    private Kernel kernel;
    private int edge;
    private RenderingHints hints;

    public ConvolveOp(Kernel kernel, int n, RenderingHints renderingHints) {
        this.kernel = kernel;
        this.edge = n;
        this.hints = renderingHints;
    }

    public ConvolveOp(Kernel kernel) {
        this.kernel = kernel;
        this.edge = 0;
        this.hints = null;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage == bufferedImage2) {
            throw new IllegalArgumentException();
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        BufferedImage bufferedImage3 = bufferedImage;
        if (!bufferedImage.isPremultiplied) {
            bufferedImage3 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
            bufferedImage.copyData(bufferedImage3.getRaster());
            bufferedImage3.coerceData(true);
        }
        BufferedImage bufferedImage4 = bufferedImage2;
        if (!bufferedImage.getColorModel().equals(bufferedImage2.getColorModel())) {
            bufferedImage4 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        this.filter(bufferedImage3.getRaster(), bufferedImage4.getRaster());
        if (bufferedImage4 != bufferedImage2) {
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHints(this.hints);
            graphics2D.drawImage((Image)bufferedImage4, 0, 0, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(), bufferedImage.isPremultiplied, null);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public int getEdgeCondition() {
        return this.edge;
    }

    public Kernel getKernel() {
        return (Kernel)this.kernel.clone();
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n;
        float[] fArray;
        if (raster == writableRaster) {
            throw new IllegalArgumentException();
        }
        if (raster.getWidth() < this.kernel.getWidth() || raster.getHeight() < this.kernel.getHeight()) {
            throw new ImagingOpException(null);
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (raster.numBands != writableRaster.numBands) {
            throw new ImagingOpException(null);
        }
        if (this.edge == 0) {
            fArray = new float[raster.getNumBands() * raster.getWidth() * (this.kernel.getYOrigin() - 1)];
            Arrays.fill(fArray, 0.0f);
            writableRaster.setPixels(raster.getMinX(), raster.getMinY(), raster.getWidth(), this.kernel.getYOrigin() - 1, fArray);
        } else {
            fArray = new float[raster.getNumBands() * raster.getWidth() * (this.kernel.getYOrigin() - 1)];
            raster.getPixels(raster.getMinX(), raster.getMinY(), raster.getWidth(), this.kernel.getYOrigin() - 1, fArray);
            writableRaster.setPixels(raster.getMinX(), raster.getMinY(), raster.getWidth(), this.kernel.getYOrigin() - 1, fArray);
        }
        fArray = this.kernel.getKernelData(null);
        float[] fArray2 = new float[this.kernel.getWidth() * this.kernel.getHeight()];
        for (n = raster.getMinY() + this.kernel.getYOrigin(); n < raster.getMinY() + raster.getHeight() - this.kernel.getYOrigin() / 2; ++n) {
            float[] fArray3 = new float[(this.kernel.getXOrigin() - 1) * raster.getNumBands()];
            if (this.edge == 0) {
                Arrays.fill(fArray3, 0.0f);
            } else {
                raster.getPixels(raster.getMinX(), n, this.kernel.getXOrigin() - 1, 1, fArray3);
            }
            writableRaster.setPixels(raster.getMinX(), n, this.kernel.getXOrigin() - 1, 1, fArray3);
            for (int i = raster.getMinX(); i < raster.getWidth() + raster.getMinX(); ++i) {
                for (int j = 0; j < raster.getNumBands(); ++j) {
                    float f = 0.0f;
                    raster.getSamples(i, n, this.kernel.getWidth(), this.kernel.getHeight(), j, fArray2);
                    for (int k = 0; k < fArray2.length; ++k) {
                        f += fArray2[k] * fArray[k];
                    }
                    writableRaster.setSample(i, n, j, f);
                }
            }
            float[] fArray4 = new float[this.kernel.getWidth() / 2 * raster.getNumBands()];
            if (this.edge == 0) {
                Arrays.fill(fArray4, 0.0f);
            } else {
                raster.getPixels(raster.getMinX() + raster.getWidth() - this.kernel.getWidth() / 2, n, this.kernel.getWidth() / 2, 1, fArray4);
            }
            writableRaster.setPixels(raster.getMinX() + raster.getWidth() - this.kernel.getWidth() / 2, n, this.kernel.getWidth() / 2, 1, fArray4);
        }
        for (n = raster.getMinY(); n < raster.getHeight() + raster.getMinY(); ++n) {
            for (int i = raster.getMinX(); i < raster.getWidth() + raster.getMinX(); ++i) {
            }
        }
        for (n = raster.getMinY(); n < raster.getHeight() + raster.getMinY(); ++n) {
            for (int i = raster.getMinX(); i < raster.getWidth() + raster.getMinX(); ++i) {
            }
        }
        if (this.edge == 0) {
            float[] fArray5 = new float[raster.getNumBands() * raster.getWidth() * (this.kernel.getHeight() / 2)];
            Arrays.fill(fArray5, 0.0f);
            writableRaster.setPixels(raster.getMinX(), raster.getHeight() + raster.getMinY() - this.kernel.getHeight() / 2, raster.getWidth(), this.kernel.getHeight() / 2, fArray5);
        } else {
            float[] fArray6 = new float[raster.getNumBands() * raster.getWidth() * (this.kernel.getHeight() / 2)];
            raster.getPixels(raster.getMinX(), raster.getHeight() + raster.getMinY() - this.kernel.getHeight() / 2, raster.getWidth(), this.kernel.getHeight() / 2, fArray6);
            writableRaster.setPixels(raster.getMinX(), raster.getHeight() + raster.getMinY() - this.kernel.getHeight() / 2, raster.getWidth(), this.kernel.getHeight() / 2, fArray6);
        }
        return writableRaster;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    public Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }
}

