/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class PixelGrabber
implements ImageConsumer {
    int x;
    int y;
    int offset;
    int width;
    int height;
    int scansize;
    boolean forceRGB;
    ColorModel model;
    int hints;
    Hashtable props;
    int[] int_pixel_buffer;
    boolean ints_delivered;
    byte[] byte_pixel_buffer;
    boolean bytes_delivered;
    ImageProducer ip;
    int observerStatus;
    int consumerStatus;
    private Thread grabberThread;
    boolean grabbing;

    private /* synthetic */ void finit$() {
        this.width = -1;
        this.height = -1;
        this.scansize = -1;
        this.forceRGB = true;
        this.model = ColorModel.getRGBdefault();
        this.ints_delivered = false;
        this.bytes_delivered = false;
        this.grabbing = false;
    }

    public PixelGrabber(Image image, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        this(image.getSource(), n, n2, n3, n4, nArray, n5, n6);
    }

    public PixelGrabber(ImageProducer imageProducer, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        this.finit$();
        if (imageProducer == null) {
            throw new NullPointerException("The ImageProducer must not be null.");
        }
        this.ip = imageProducer;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.offset = n5;
        this.scansize = n6;
        this.int_pixel_buffer = nArray;
        this.byte_pixel_buffer = new byte[nArray.length * 4];
    }

    public PixelGrabber(Image image, int n, int n2, int n3, int n4, boolean bl) {
        this.finit$();
        this.ip = image.getSource();
        if (this.ip == null) {
            throw new NullPointerException("The ImageProducer must not be null.");
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (this.width >= 0 && this.height >= 0) {
            this.int_pixel_buffer = new int[this.width * this.height];
            this.byte_pixel_buffer = new byte[this.width * this.height];
        }
        this.forceRGB = bl;
    }

    public synchronized void startGrabbing() {
        if (!this.grabbing) {
            this.grabbing = true;
            this.grabberThread = new Thread(this){
                private /* synthetic */ PixelGrabber this$0;
                {
                    this.this$0 = pixelGrabber;
                }

                public void run() {
                    try {
                        this.this$0.ip.startProduction(this.this$0);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.this$0.imageComplete(4);
                    }
                }
            };
            this.grabberThread.start();
        }
    }

    public synchronized void abortGrabbing() {
        if (this.grabbing) {
            Thread thread = this.grabberThread;
            this.grabberThread = null;
            thread.interrupt();
            this.imageComplete(4);
        }
    }

    public synchronized boolean grabPixels() throws InterruptedException {
        return this.grabPixels(0L);
    }

    public synchronized boolean grabPixels(long l) throws InterruptedException {
        if (l < 0L) {
            return (this.observerStatus & 0x30) != 0;
        }
        this.startGrabbing();
        if (l > 0L) {
            long l2;
            long l3 = System.currentTimeMillis() + l;
            while (this.grabbing && (l2 = l3 - System.currentTimeMillis()) > 0L) {
                this.wait(l2);
            }
            this.abortGrabbing();
        } else {
            this.wait();
        }
        if (this.consumerStatus != 0) {
            return this.setObserverStatus();
        }
        return (this.observerStatus & 0x30) != 0;
    }

    private synchronized boolean setObserverStatus() {
        boolean bl = false;
        if ((this.consumerStatus & 1) != 0) {
            this.observerStatus |= 0x40;
        }
        if ((this.consumerStatus & 4) != 0) {
            this.observerStatus |= 0x80;
        }
        if ((this.consumerStatus & 3) != 0) {
            this.observerStatus |= 0x20;
            bl = true;
        }
        if ((this.consumerStatus & 2) != 0) {
            this.observerStatus |= 0x10;
            bl = true;
        }
        return bl;
    }

    public synchronized int getStatus() {
        return this.observerStatus;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized Object getPixels() {
        if (this.ints_delivered) {
            return this.int_pixel_buffer;
        }
        if (this.bytes_delivered) {
            return this.byte_pixel_buffer;
        }
        return null;
    }

    public synchronized ColorModel getColorModel() {
        return this.model;
    }

    public synchronized void setDimensions(int n, int n2) {
        if (this.width < 0) {
            this.width = n - this.x;
        }
        if (this.height < 0) {
            this.height = n2 - this.y;
        }
        if (this.scansize < 0) {
            this.scansize = this.width;
        }
        if (this.int_pixel_buffer == null) {
            this.int_pixel_buffer = new int[this.width * this.height];
        }
        if (this.byte_pixel_buffer == null) {
            this.byte_pixel_buffer = new byte[this.width * this.height];
        }
    }

    public synchronized void setProperties(Hashtable hashtable) {
        this.props = hashtable;
    }

    public synchronized void setColorModel(ColorModel colorModel) {
        this.model = colorModel;
    }

    public synchronized void setHints(int n) {
        this.hints = n;
    }

    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        ColorModel colorModel2 = colorModel != null ? colorModel : this.model;
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                if (j < this.x || i < this.y || j >= this.x + this.width || i >= this.y + this.height) continue;
                int n7 = (i - this.y) * this.scansize + (j - this.x) + this.offset;
                int n8 = (i - n2) * n6 + (j - n) + n5;
                if (this.forceRGB) {
                    this.ints_delivered = true;
                    this.int_pixel_buffer[n7] = colorModel2.getRGB(byArray[n8] & 0xFF);
                    continue;
                }
                this.bytes_delivered = true;
                this.byte_pixel_buffer[n7] = byArray[n8];
            }
        }
    }

    public synchronized void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        ColorModel colorModel2 = colorModel != null ? colorModel : this.model;
        this.ints_delivered = true;
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                if (j < this.x || i < this.y || j >= this.x + this.width || i >= this.y + this.height) continue;
                int n7 = (i - this.y) * this.scansize + (j - this.x) + this.offset;
                int n8 = (i - n2) * n6 + (j - n) + n5;
                this.int_pixel_buffer[n7] = this.forceRGB ? colorModel2.getRGB(nArray[n8]) : nArray[n8];
            }
        }
    }

    public synchronized void imageComplete(int n) {
        this.consumerStatus = n;
        this.setObserverStatus();
        this.grabbing = false;
        if (this.ip != null) {
            this.ip.removeConsumer(this);
        }
        this.notifyAll();
    }

    public synchronized int status() {
        return this.getStatus();
    }
}

