/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class RescaleOp
implements BufferedImageOp,
RasterOp {
    private float[] scale;
    private float[] offsets;
    private RenderingHints hints;

    private /* synthetic */ void finit$() {
        this.hints = null;
    }

    public RescaleOp(float[] fArray, float[] fArray2, RenderingHints renderingHints) {
        this.finit$();
        this.scale = fArray;
        this.offsets = fArray2;
        this.hints = renderingHints;
    }

    public RescaleOp(float f, float f2, RenderingHints renderingHints) {
        this.finit$();
        this.scale = new float[]{f};
        this.offsets = new float[]{f2};
        this.hints = renderingHints;
    }

    public final float[] getScaleFactors(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.scale.length];
        }
        System.arraycopy(this.scale, 0, fArray, 0, this.scale.length);
        return fArray;
    }

    public final float[] getOffsets(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.offsets.length];
        }
        System.arraycopy(this.offsets, 0, fArray, 0, this.offsets.length);
        return fArray;
    }

    public final int getNumFactors() {
        return this.scale.length;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.scale.length != this.offsets.length) {
            throw new IllegalArgumentException();
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        if (this.scale.length == 1 || this.scale.length == colorModel.getNumColorComponents()) {
            int[] nArray = new int[colorModel.getNumColorComponents()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            writableRaster = writableRaster.createWritableChild(writableRaster.minX, writableRaster.minY, writableRaster.width, writableRaster.height, writableRaster.minX, writableRaster.minY, nArray);
        }
        this.filter(writableRaster, writableRaster2);
        return bufferedImage2;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster == null) {
            writableRaster = raster.createCompatibleWritableRaster();
        }
        if (raster.numBands != writableRaster.numBands || this.scale.length != this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (this.scale.length != 1 && this.scale.length != raster.numBands) {
            throw new IllegalArgumentException();
        }
        float[] fArray = this.scale;
        float[] fArray2 = this.offsets;
        if (this.scale.length == 1) {
            fArray = new float[raster.numBands];
            Arrays.fill(fArray, this.scale[0]);
            fArray2 = new float[raster.numBands];
            Arrays.fill(fArray2, this.offsets[0]);
        }
        float[] fArray3 = new float[raster.numBands];
        for (int i = raster.minY; i < raster.height + raster.minY; ++i) {
            for (int j = raster.minX; j < raster.width + raster.minX; ++j) {
                raster.getPixel(j, i, fArray3);
                for (int k = 0; k < raster.numBands; ++k) {
                    fArray3[k] = fArray3[k] * fArray[k] + fArray2[k];
                }
                writableRaster.setPixel(j, i, fArray3);
            }
        }
        return writableRaster;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        WritableRaster writableRaster = bufferedImage.getRaster().createCompatibleWritableRaster();
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, bufferedImage.isPremultiplied, null);
        return bufferedImage2;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = (Point2D)point2D.clone();
        } else {
            point2D2.setLocation(point2D);
        }
        return point2D2;
    }
}

