/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public abstract class SampleModel {
    protected int width;
    protected int height;
    protected int numBands;
    protected int dataType;

    public SampleModel(int n, int n2, int n3, int n4) {
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException((n2 <= 0 ? " width<=0" : " width is ok") + (n3 <= 0 ? " height<=0" : " height is ok"));
        }
        this.dataType = n;
        this.width = n2;
        this.height = n3;
        this.numBands = n4;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public abstract int getNumDataElements();

    public final int getDataType() {
        return this.dataType;
    }

    public int getTransferType() {
        return this.dataType;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = this.getSample(n, n2, i, dataBuffer);
        }
        return nArray;
    }

    public abstract Object getDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public Object getDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5 = n3 * n4;
        int n6 = this.getNumDataElements();
        int n7 = n6 * n5;
        if (object == null) {
            switch (this.getTransferType()) {
                case 0: {
                    object = new byte[n7];
                    break;
                }
                case 1: {
                    object = new short[n7];
                    break;
                }
                case 3: {
                    object = new int[n7];
                    break;
                }
                default: {
                    throw new ClassCastException();
                }
            }
        }
        Object object2 = null;
        int n8 = 0;
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                object2 = this.getDataElements(j, i, object2, dataBuffer);
                System.arraycopy(object2, 0, object, n8, n6);
                n8 += n6;
            }
        }
        return object;
    }

    public abstract void setDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public void setDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        Object[] objectArray;
        int n5 = n3 * n4;
        int n6 = this.getNumDataElements();
        int n7 = n6 * n5;
        switch (this.getTransferType()) {
            case 0: {
                objectArray = new byte[n6];
                break;
            }
            case 1: {
                objectArray = new short[n6];
                break;
            }
            case 3: {
                objectArray = new int[n6];
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
        int n8 = 0;
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                System.arraycopy(object, n8, objectArray, 0, n6);
                this.setDataElements(j, i, objectArray, dataBuffer);
                n8 += n6;
            }
        }
    }

    public float[] getPixel(int n, int n2, float[] fArray, DataBuffer dataBuffer) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        for (int i = 0; i < this.numBands; ++i) {
            fArray[i] = this.getSampleFloat(n, n2, i, dataBuffer);
        }
        return fArray;
    }

    public double[] getPixel(int n, int n2, double[] dArray, DataBuffer dataBuffer) {
        if (dArray == null) {
            dArray = new double[this.numBands];
        }
        for (int i = 0; i < this.numBands; ++i) {
            dArray[i] = this.getSampleDouble(n, n2, i, dataBuffer);
        }
        return dArray;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = n3 * n4;
        int n6 = 0;
        int[] nArray2 = null;
        if (nArray == null) {
            nArray = new int[n3 * n4 * this.numBands];
        }
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                nArray2 = this.getPixel(j, i, nArray2, dataBuffer);
                System.arraycopy(nArray2, 0, nArray, n6, this.numBands);
                n6 += this.numBands;
            }
        }
        return nArray;
    }

    public float[] getPixels(int n, int n2, int n3, int n4, float[] fArray, DataBuffer dataBuffer) {
        int n5 = n3 * n4;
        int n6 = 0;
        float[] fArray2 = null;
        if (fArray == null) {
            fArray = new float[n3 * n4 * this.numBands];
        }
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                fArray2 = this.getPixel(j, i, fArray2, dataBuffer);
                System.arraycopy(fArray2, 0, fArray, n6, this.numBands);
                n6 += this.numBands;
            }
        }
        return fArray;
    }

    public double[] getPixels(int n, int n2, int n3, int n4, double[] dArray, DataBuffer dataBuffer) {
        int n5 = n3 * n4;
        int n6 = 0;
        double[] dArray2 = null;
        if (dArray == null) {
            dArray = new double[n3 * n4 * this.numBands];
        }
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                dArray2 = this.getPixel(j, i, dArray2, dataBuffer);
                System.arraycopy(dArray2, 0, dArray, n6, this.numBands);
                n6 += this.numBands;
            }
        }
        return dArray;
    }

    public abstract int getSample(int var1, int var2, int var3, DataBuffer var4);

    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        return this.getSample(n, n2, n3, dataBuffer);
    }

    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        return this.getSampleFloat(n, n2, n3, dataBuffer);
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = n3 * n4;
        int n7 = 0;
        if (nArray == null) {
            nArray = new int[n6];
        }
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                nArray[n7++] = this.getSample(j, i, n5, dataBuffer);
            }
        }
        return nArray;
    }

    public float[] getSamples(int n, int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = n3 * n4;
        int n7 = 0;
        if (fArray == null) {
            fArray = new float[n6];
        }
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                fArray[n7++] = this.getSampleFloat(j, i, n5, dataBuffer);
            }
        }
        return fArray;
    }

    public double[] getSamples(int n, int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = n3 * n4;
        int n7 = 0;
        if (dArray == null) {
            dArray = new double[n6];
        }
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                dArray[n7++] = this.getSampleDouble(j, i, n5, dataBuffer);
            }
        }
        return dArray;
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(n, n2, i, nArray[i], dataBuffer);
        }
    }

    public void setPixel(int n, int n2, float[] fArray, DataBuffer dataBuffer) {
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(n, n2, i, fArray[i], dataBuffer);
        }
    }

    public void setPixel(int n, int n2, double[] dArray, DataBuffer dataBuffer) {
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(n, n2, i, dArray[i], dataBuffer);
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int[] nArray2 = new int[this.numBands];
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                System.arraycopy(nArray, n5, nArray2, 0, this.numBands);
                this.setPixel(j, i, nArray2, dataBuffer);
                n5 += this.numBands;
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, float[] fArray, DataBuffer dataBuffer) {
        int n5 = 0;
        float[] fArray2 = new float[this.numBands];
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                System.arraycopy(fArray, n5, fArray2, 0, this.numBands);
                this.setPixel(j, i, fArray2, dataBuffer);
                n5 += this.numBands;
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, double[] dArray, DataBuffer dataBuffer) {
        int n5 = 0;
        double[] dArray2 = new double[this.numBands];
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                System.arraycopy(dArray, n5, dArray2, 0, this.numBands);
                this.setPixel(j, i, dArray2, dataBuffer);
                n5 += this.numBands;
            }
        }
    }

    public abstract void setSample(int var1, int var2, int var3, int var4, DataBuffer var5);

    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        this.setSample(n, n2, n3, (int)f, dataBuffer);
    }

    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        this.setSample(n, n2, n3, (float)d, dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = n3 * n4;
        int n7 = 0;
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                this.setSample(j, i, n5, nArray[n7++], dataBuffer);
            }
        }
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, float[] fArray, DataBuffer dataBuffer) {
        int n6 = n3 * n4;
        int n7 = 0;
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                this.setSample(j, i, n5, fArray[n7++], dataBuffer);
            }
        }
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, double[] dArray, DataBuffer dataBuffer) {
        int n6 = n3 * n4;
        int n7 = 0;
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                this.setSample(j, i, n5, dArray[n7++], dataBuffer);
            }
        }
    }

    public abstract SampleModel createCompatibleSampleModel(int var1, int var2);

    public abstract SampleModel createSubsetSampleModel(int[] var1);

    public abstract DataBuffer createDataBuffer();

    public abstract int[] getSampleSize();

    public abstract int getSampleSize(int var1);
}

