/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ShortLookupTable
extends LookupTable {
    private short[][] data;

    public ShortLookupTable(int n, short[][] sArray) throws IllegalArgumentException {
        super(n, sArray.length);
        this.data = sArray;
    }

    public ShortLookupTable(int n, short[] sArray) throws IllegalArgumentException {
        super(n, 1);
        this.data = new short[][]{sArray};
    }

    public final short[][] getTable() {
        return this.data;
    }

    public int[] lookupPixel(int[] nArray, int[] nArray2) throws ArrayIndexOutOfBoundsException {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.data.length == 1) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.data[0][nArray[i] - this.offset];
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.data[i][nArray[i] - this.offset];
            }
        }
        return nArray2;
    }

    public short[] lookupPixel(short[] sArray, short[] sArray2) throws ArrayIndexOutOfBoundsException {
        if (sArray2 == null) {
            sArray2 = new short[sArray.length];
        }
        if (this.data.length == 1) {
            for (int i = 0; i < sArray.length; ++i) {
                sArray2[i] = this.data[0][sArray[i] - this.offset];
            }
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                sArray2[i] = this.data[i][sArray[i] - this.offset];
            }
        }
        return sArray2;
    }
}

