/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.BitMaskExtent;
import gnu.java.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int scanlineStride;
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int[] nArray) {
        this(n, n2, n3, n2, nArray);
    }

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int n4, int[] nArray) {
        super(n, n2, n3, nArray.length);
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("SinglePixelPackedSampleModel unsupported dataType");
            }
        }
        this.scanlineStride = n4;
        this.bitMasks = nArray;
        this.bitOffsets = new int[this.numBands];
        this.sampleSize = new int[this.numBands];
        BitMaskExtent bitMaskExtent = new BitMaskExtent();
        for (int i = 0; i < this.numBands; ++i) {
            bitMaskExtent.setMask(nArray[i]);
            this.sampleSize[i] = bitMaskExtent.bitWidth;
            this.bitOffsets[i] = bitMaskExtent.leastSignificantBit;
        }
    }

    public int getNumDataElements() {
        return 1;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SinglePixelPackedSampleModel(this.dataType, n, n2, this.bitMasks);
    }

    public DataBuffer createDataBuffer() {
        int n = this.scanlineStride * (this.height - 1) + this.width;
        return Buffers.createBuffer(this.getDataType(), n);
    }

    public int[] getSampleSize() {
        return this.sampleSize;
    }

    public int getSampleSize(int n) {
        return this.sampleSize[n];
    }

    public int getOffset(int n, int n2) {
        return this.scanlineStride * n2 + n;
    }

    public int[] getBitOffsets() {
        return this.bitOffsets;
    }

    public int[] getBitMasks() {
        return this.bitMasks;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.bitMasks[nArray[i]];
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2);
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n + dataBuffer.getOffset();
        return Buffers.getData(dataBuffer, n3, object, 0, 1);
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        int n5;
        int n6 = n5 = n3 * n4;
        Object[] objectArray = null;
        switch (this.getTransferType()) {
            case 0: {
                objectArray = ((DataBufferByte)dataBuffer).getData();
                if (object != null) break;
                object = new byte[n6];
                break;
            }
            case 1: {
                objectArray = ((DataBufferUShort)dataBuffer).getData();
                if (object != null) break;
                object = new short[n6];
                break;
            }
            case 3: {
                objectArray = ((DataBufferInt)dataBuffer).getData();
                if (object != null) break;
                object = new int[n6];
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
        if (n == 0 && this.scanlineStride == n3) {
            System.arraycopy(objectArray, this.scanlineStride * n2 + dataBuffer.getOffset(), object, 0, n5);
        } else {
            int n7 = 0;
            int n8 = this.scanlineStride * n2 + n + dataBuffer.getOffset();
            for (int i = n2; i < n2 + n4; ++i) {
                System.arraycopy(objectArray, n8, object, n7, n3);
                n8 += this.scanlineStride;
                n7 += n3;
            }
        }
        return object;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n;
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n4 = dataBuffer.getElem(n3);
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = (n4 & this.bitMasks[i]) >>> (this.bitOffsets[i] & 0x1F);
        }
        return nArray;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = this.scanlineStride * n2 + n;
        if (nArray == null) {
            nArray = new int[this.numBands * n3 * n4];
        }
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n7 = n5;
            for (n = 0; n < n3; ++n) {
                int n8 = dataBuffer.getElem(n7++);
                for (int i = 0; i < this.numBands; ++i) {
                    nArray[n6++] = (n8 & this.bitMasks[i]) >>> (this.bitOffsets[i] & 0x1F);
                }
            }
            n5 += this.scanlineStride;
        }
        return nArray;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = this.scanlineStride * n2 + n;
        int n5 = dataBuffer.getElem(n4);
        return (n5 & this.bitMasks[n3]) >>> (this.bitOffsets[n3] & 0x1F);
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        Object[] objectArray;
        switch (this.getTransferType()) {
            case 0: {
                objectArray = ((DataBufferByte)dataBuffer).getData();
                break;
            }
            case 1: {
                objectArray = ((DataBufferUShort)dataBuffer).getData();
                break;
            }
            case 3: {
                objectArray = ((DataBufferInt)dataBuffer).getData();
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
        int n5 = 0;
        int n6 = this.scanlineStride * n2 + n + dataBuffer.getOffset();
        for (int i = n2; i < n2 + n4; ++i) {
            System.arraycopy(object, n5, objectArray, n6, n3);
            n6 += this.scanlineStride;
            n5 += n3;
        }
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n + dataBuffer.getOffset();
        int n4 = this.getTransferType();
        if (this.getTransferType() != dataBuffer.getDataType()) {
            throw new IllegalArgumentException("transfer type (" + this.getTransferType() + "), " + "does not match data " + "buffer type (" + dataBuffer.getDataType() + ").");
        }
        try {
            switch (n4) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                    byte[] byArray = (byte[])object;
                    dataBufferByte.getData()[n3] = byArray[0];
                    return;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                    short[] sArray = (short[])object;
                    dataBufferUShort.getData()[n3] = sArray[0];
                    return;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                    int[] nArray = (int[])object;
                    dataBufferInt.getData()[n3] = nArray[0];
                    return;
                }
            }
            throw new InternalError();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = "While writing data elements, x=" + n + ", y=" + n2 + ", width=" + this.width + ", height=" + this.height + ", scanlineStride=" + this.scanlineStride + ", offset=" + n3 + ", data.getSize()=" + dataBuffer.getSize() + ", data.getOffset()=" + dataBuffer.getOffset() + ": " + arrayIndexOutOfBoundsException;
            throw new ArrayIndexOutOfBoundsException(string);
        }
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.scanlineStride * n2 + n;
        int n4 = 0;
        for (int i = 0; i < this.numBands; ++i) {
            n4 |= nArray[i] << (this.bitOffsets[i] & 0x1F) & this.bitMasks[i];
        }
        dataBuffer.setElem(n3, n4);
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        int[] nArray2 = new int[this.numBands];
        for (int i = n2; i < n2 + n4; ++i) {
            int n6 = this.scanlineStride * i + n;
            for (int j = n; j < n + n3; ++j) {
                int n7 = 0;
                for (int k = 0; k < this.numBands; ++k) {
                    n7 |= nArray[n5 + k] << (this.bitOffsets[k] & 0x1F) & this.bitMasks[k];
                }
                dataBuffer.setElem(0, n6, n7);
                n5 += this.numBands;
                ++n6;
            }
        }
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        int n5 = this.scanlineStride * n2 + n;
        int n6 = dataBuffer.getElem(n5);
        int n7 = this.bitMasks[n3];
        n6 &= ~n7;
        dataBuffer.setElem(n5, n6 |= n4 << (this.bitOffsets[n3] & 0x1F) & n7);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append("scanlineStride=").append(this.scanlineStride);
        for (int i = 0; i < this.bitMasks.length; ++i) {
            stringBuffer.append(", mask[").append(i).append("]=0x").append(Integer.toHexString(this.bitMasks[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

