/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    PipedOutputStream source;
    boolean closed;
    protected static final int PIPE_SIZE = 1024;
    protected byte[] buffer;
    protected int in;
    protected int out;
    private byte[] read_buf;

    private /* synthetic */ void finit$() {
        this.buffer = new byte[1024];
        this.in = -1;
        this.out = 0;
        this.read_buf = new byte[1];
    }

    public PipedInputStream() {
        this.finit$();
    }

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        this.finit$();
        this.connect(pipedOutputStream);
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        if (this.source != null || pipedOutputStream.sink != null) {
            throw new IOException("Already connected");
        }
        pipedOutputStream.sink = this;
        this.source = pipedOutputStream;
    }

    protected synchronized void receive(int n) throws IOException {
        this.read_buf[0] = (byte)n & 0xFFFFFFFF;
        this.receive(this.read_buf, 0, 1);
    }

    synchronized void receive(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        int n3 = n;
        while (n2 > 0) {
            try {
                while (this.in == this.out) {
                    this.notifyAll();
                    this.wait();
                    if (!this.closed) continue;
                    throw new IOException("Pipe closed");
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if (this.in < 0) {
                this.in = 0;
            }
            int n4 = this.in < this.out ? Math.min(n2, this.out - this.in) : Math.min(n2, this.buffer.length - this.in);
            System.arraycopy(byArray, n3, this.buffer, this.in, n4);
            n2 -= n4;
            n3 += n4;
            this.in += n4;
            if (this.in != this.buffer.length) continue;
            this.in = 0;
        }
        this.notifyAll();
    }

    public int read() throws IOException {
        int n = this.read(this.read_buf, 0, 1);
        if (n != -1) {
            return this.read_buf[0] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.source == null) {
            throw new IOException("Not connected");
        }
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        try {
            while (this.in < 0) {
                if (this.source.closed) {
                    return -1;
                }
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
        int n3 = 0;
        do {
            int n4 = this.out < this.in ? Math.min(n2, this.in - this.out) : Math.min(n2, this.buffer.length - this.out);
            System.arraycopy(this.buffer, this.out, byArray, n, n4);
            n += n4;
            n2 -= n4;
            this.out += n4;
            n3 += n4;
            if (this.out == this.buffer.length) {
                this.out = 0;
            }
            if (this.out != this.in) continue;
            this.in = -1;
            this.out = 0;
        } while (n2 != 0 && this.in != -1);
        this.notifyAll();
        return n3;
    }

    public synchronized int available() throws IOException {
        if (this.in < 0) {
            return 0;
        }
        if (this.out < this.in) {
            return this.in - this.out;
        }
        return this.buffer.length - this.out + this.in;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.notifyAll();
    }
}

