/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StackTraceElement
implements Serializable {
    private static final long serialVersionUID = 6992337162326171013L;
    private final String fileName;
    private final int lineNumber;
    private final String declaringClass;
    private final String methodName;
    private final transient boolean isNative;

    StackTraceElement(String string, int n, String string2, String string3, boolean bl) {
        this.fileName = string;
        this.lineNumber = n;
        this.declaringClass = string2;
        this.methodName = string3;
        this.isNative = bl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.isNative;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.declaringClass != null) {
            stringBuffer.append(this.declaringClass);
            if (this.methodName != null) {
                stringBuffer.append('.');
            }
        }
        if (this.methodName != null) {
            stringBuffer.append(this.methodName);
        }
        stringBuffer.append("(");
        if (this.fileName != null) {
            stringBuffer.append(this.fileName);
        } else {
            stringBuffer.append(this.isNative ? "Native Method" : "Unknown Source");
        }
        if (this.lineNumber >= 0) {
            stringBuffer.append(':').append(this.lineNumber);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement stackTraceElement = (StackTraceElement)object;
        return StackTraceElement.equals(this.fileName, stackTraceElement.fileName) && this.lineNumber == stackTraceElement.lineNumber && StackTraceElement.equals(this.declaringClass, stackTraceElement.declaringClass) && StackTraceElement.equals(this.methodName, stackTraceElement.methodName);
    }

    public int hashCode() {
        return StackTraceElement.hashCode(this.fileName) ^ this.lineNumber ^ StackTraceElement.hashCode(this.declaringClass) ^ StackTraceElement.hashCode(this.methodName);
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }
}

