/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Vector;

public class ThreadGroup {
    static ThreadGroup root = new ThreadGroup();
    static boolean had_uncaught_exception;
    private final ThreadGroup parent;
    final String name;
    private final Vector threads;
    private Vector groups;
    private boolean daemon_flag;
    private int maxpri;

    private /* synthetic */ void finit$() {
        this.threads = new Vector();
        this.groups = new Vector();
        this.daemon_flag = false;
    }

    private ThreadGroup() {
        this.finit$();
        this.name = "main";
        this.parent = null;
        this.maxpri = 10;
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().group, string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        this.finit$();
        threadGroup.checkAccess();
        this.parent = threadGroup;
        this.name = string;
        this.maxpri = threadGroup.maxpri;
        this.daemon_flag = threadGroup.daemon_flag;
        ThreadGroup threadGroup2 = threadGroup;
        synchronized (threadGroup2) {
            try {
                if (threadGroup.groups == null) {
                    throw new IllegalThreadStateException();
                }
                threadGroup.groups.add(this);
            }
            finally {
                Object var4_4 = null;
            }
            return;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        }
        return this.parent;
    }

    public final int getMaxPriority() {
        return this.maxpri;
    }

    public final boolean isDaemon() {
        return this.daemon_flag;
    }

    public synchronized boolean isDestroyed() {
        return this.groups == null;
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        this.daemon_flag = bl;
    }

    public final synchronized void setMaxPriority(int n) {
        this.checkAccess();
        if (n < 1 || n > 10) {
            return;
        }
        if (this.parent != null && n > this.parent.maxpri) {
            n = this.parent.maxpri;
        }
        this.maxpri = n;
        if (this.groups == null) {
            return;
        }
        int n2 = this.groups.size();
        while (--n2 >= 0) {
            ((ThreadGroup)this.groups.get(n2)).setMaxPriority(n);
        }
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (threadGroup == this) {
                return true;
            }
            threadGroup = threadGroup.parent;
        }
        return false;
    }

    public final void checkAccess() {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public int activeCount() {
        int n = 0;
        if (this.groups == null) {
            return n;
        }
        int n2 = this.threads.size();
        while (--n2 >= 0) {
            if (!((Thread)this.threads.get(n2)).isAlive()) continue;
            ++n;
        }
        n2 = this.groups.size();
        while (--n2 >= 0) {
            n += ((ThreadGroup)this.groups.get(n2)).activeCount();
        }
        return n;
    }

    public int enumerate(Thread[] threadArray) {
        return this.enumerate(threadArray, 0, true);
    }

    public int enumerate(Thread[] threadArray, boolean bl) {
        return this.enumerate(threadArray, 0, bl);
    }

    public int activeGroupCount() {
        int n;
        if (this.groups == null) {
            return 0;
        }
        int n2 = n = this.groups.size();
        while (--n2 >= 0) {
            n += ((ThreadGroup)this.groups.get(n2)).activeGroupCount();
        }
        return n;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        return this.enumerate(threadGroupArray, 0, true);
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl) {
        return this.enumerate(threadGroupArray, 0, bl);
    }

    public final synchronized void stop() {
        this.checkAccess();
        if (this.groups == null) {
            return;
        }
        int n = this.threads.size();
        while (--n >= 0) {
            ((Thread)this.threads.get(n)).stop();
        }
        n = this.groups.size();
        while (--n >= 0) {
            ((ThreadGroup)this.groups.get(n)).stop();
        }
    }

    public final synchronized void interrupt() {
        this.checkAccess();
        if (this.groups == null) {
            return;
        }
        int n = this.threads.size();
        while (--n >= 0) {
            ((Thread)this.threads.get(n)).interrupt();
        }
        n = this.groups.size();
        while (--n >= 0) {
            ((ThreadGroup)this.groups.get(n)).interrupt();
        }
    }

    public final synchronized void suspend() {
        this.checkAccess();
        if (this.groups == null) {
            return;
        }
        int n = this.threads.size();
        while (--n >= 0) {
            ((Thread)this.threads.get(n)).suspend();
        }
        n = this.groups.size();
        while (--n >= 0) {
            ((ThreadGroup)this.groups.get(n)).suspend();
        }
    }

    public final synchronized void resume() {
        this.checkAccess();
        if (this.groups == null) {
            return;
        }
        int n = this.threads.size();
        while (--n >= 0) {
            ((Thread)this.threads.get(n)).resume();
        }
        n = this.groups.size();
        while (--n >= 0) {
            ((ThreadGroup)this.groups.get(n)).resume();
        }
    }

    public final synchronized void destroy() {
        this.checkAccess();
        if (!this.threads.isEmpty() || this.groups == null) {
            throw new IllegalThreadStateException();
        }
        int n = this.groups.size();
        while (--n >= 0) {
            ((ThreadGroup)this.groups.get(n)).destroy();
        }
        this.groups = null;
        if (this.parent != null) {
            this.parent.removeGroup(this);
        }
    }

    public void list() {
        this.list("");
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
        } else if (!(throwable instanceof ThreadDeath)) {
            if (throwable == null) {
                throw new NullPointerException();
            }
            had_uncaught_exception = true;
            try {
                if (thread != null) {
                    System.err.print("Exception in thread \"" + thread.name + "\" ");
                }
                throwable.printStackTrace(System.err);
            }
            catch (Throwable throwable2) {
                try {
                    System.err.println(throwable);
                    System.err.println("*** Got " + throwable2 + " while trying to print stack trace.");
                }
                catch (Throwable throwable3) {
                    System.err.println("*** Catastrophic failure while handling uncaught exception.");
                    throw new InternalError();
                }
            }
        }
    }

    public boolean allowThreadSuspension(boolean bl) {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ",maxpri=" + this.maxpri + ']';
    }

    private int enumerate(Thread[] threadArray, int n, boolean bl) {
        Object object;
        this.checkAccess();
        if (this.groups == null) {
            return n;
        }
        int n2 = this.threads.size();
        while (--n2 >= 0 && n < threadArray.length) {
            object = (Thread)this.threads.get(n2);
            if (!((Thread)object).isAlive()) continue;
            threadArray[n++] = object;
        }
        if (bl) {
            n2 = this.groups.size();
            while (--n2 >= 0 && n < threadArray.length) {
                object = (ThreadGroup)this.groups.get(n2);
                n = super.enumerate(threadArray, n, true);
            }
        }
        return n;
    }

    private int enumerate(ThreadGroup[] threadGroupArray, int n, boolean bl) {
        this.checkAccess();
        if (this.groups == null) {
            return n;
        }
        int n2 = this.groups.size();
        while (--n2 >= 0 && n < threadGroupArray.length) {
            ThreadGroup threadGroup = (ThreadGroup)this.groups.get(n2);
            threadGroupArray[n++] = threadGroup;
            if (!bl || n == threadGroupArray.length) continue;
            n = threadGroup.enumerate(threadGroupArray, n, true);
        }
        return n;
    }

    private void list(String string) {
        if (this.groups == null) {
            return;
        }
        System.out.println(string + this);
        string = string + "    ";
        int n = this.threads.size();
        while (--n >= 0) {
            System.out.println(string + this.threads.get(n));
        }
        n = this.groups.size();
        while (--n >= 0) {
            ((ThreadGroup)this.groups.get(n)).list(string);
        }
    }

    final synchronized void addThread(Thread thread) {
        if (this.groups == null) {
            throw new IllegalThreadStateException("ThreadGroup is destroyed");
        }
        this.threads.add(thread);
    }

    final synchronized void removeThread(Thread thread) {
        if (this.groups == null) {
            return;
        }
        this.threads.remove(thread);
        thread.group = null;
        if (this.daemon_flag && this.groups.size() == 0 && this.threads.size() == 0) {
            this.groups = null;
            if (this.parent != null) {
                this.parent.removeGroup(this);
            }
        }
    }

    final synchronized void removeGroup(ThreadGroup threadGroup) {
        this.groups.remove(threadGroup);
        if (this.daemon_flag && this.groups.size() == 0 && this.threads.size() == 0) {
            this.groups = null;
            if (this.parent != null) {
                this.parent.removeGroup(this);
            }
        }
    }
}

