/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.classpath.SystemProperties;
import gnu.java.net.PlainDatagramSocketImpl;
import gnu.java.nio.DatagramChannelImpl;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;

public class DatagramSocket {
    private static DatagramSocketImplFactory factory;
    private DatagramSocketImpl impl;
    private boolean implCreated;
    private InetAddress remoteAddress;
    private int remotePort;
    private boolean bound;

    private /* synthetic */ void finit$() {
        this.remotePort = -1;
    }

    protected DatagramSocket(DatagramSocketImpl datagramSocketImpl) {
        this.finit$();
        if (datagramSocketImpl == null) {
            throw new NullPointerException("impl may not be null");
        }
        this.impl = datagramSocketImpl;
        this.remoteAddress = null;
        this.remotePort = -1;
    }

    public DatagramSocket() throws SocketException {
        this(new InetSocketAddress(0));
    }

    public DatagramSocket(int n) throws SocketException {
        this(new InetSocketAddress(n));
    }

    public DatagramSocket(int n, InetAddress inetAddress) throws SocketException {
        this(new InetSocketAddress(inetAddress, n));
    }

    public DatagramSocket(SocketAddress socketAddress) throws SocketException {
        this.finit$();
        String string = SystemProperties.getProperty("impl.prefix");
        if (string == null || string.equals("")) {
            this.impl = new PlainDatagramSocketImpl();
        } else {
            try {
                this.impl = (DatagramSocketImpl)Class.forName("java.net." + string + "DatagramSocketImpl").newInstance();
            }
            catch (Exception exception) {
                System.err.println("Could not instantiate class: java.net." + string + "DatagramSocketImpl");
                this.impl = new PlainDatagramSocketImpl();
            }
        }
        if (socketAddress != null) {
            this.bind(socketAddress);
        }
    }

    DatagramSocketImpl getImpl() throws SocketException {
        try {
            if (!this.implCreated) {
                this.impl.create();
                this.implCreated = true;
            }
            return this.impl;
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            try {
                this.getImpl().close();
            }
            catch (SocketException socketException) {
            }
            Object var1_2 = null;
            this.remoteAddress = null;
            this.remotePort = -1;
            this.impl = null;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.remoteAddress = null;
            this.remotePort = -1;
            this.impl = null;
            throw throwable;
        }
        try {
            if (this.getChannel() != null) {
                this.getChannel().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InetAddress getInetAddress() {
        return this.remoteAddress;
    }

    public int getPort() {
        return this.remotePort;
    }

    public InetAddress getLocalAddress() {
        InetAddress inetAddress;
        if (!this.isBound()) {
            return null;
        }
        try {
            inetAddress = (InetAddress)this.getImpl().getOption(15);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(inetAddress.getHostName(), -1);
            }
        }
        catch (SecurityException securityException) {
            inetAddress = InetAddress.ANY_IF;
        }
        catch (SocketException socketException) {
            return null;
        }
        return inetAddress;
    }

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return 0;
        }
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new SocketException("unexpected type");
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + n);
        }
        this.getImpl().setOption(4102, new Integer(n));
    }

    public int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(4097);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new SocketException("unexpected type");
    }

    public void setSendBufferSize(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Buffer size is less than 0");
        }
        this.getImpl().setOption(4097, new Integer(n));
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(4098);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new SocketException("unexpected type");
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Buffer size is less than 0");
        }
        this.getImpl().setOption(4098, new Integer(n));
    }

    public void connect(InetAddress inetAddress, int n) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("Connect address may not be null");
        }
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("Port number is illegal: " + n);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetAddress.getHostName(), n);
        }
        try {
            this.getImpl().connect(inetAddress, n);
            this.remoteAddress = inetAddress;
            this.remotePort = n;
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            try {
                this.getImpl().disconnect();
            }
            catch (SocketException socketException) {
            }
            Object var1_2 = null;
            this.remoteAddress = null;
            this.remotePort = -1;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.remoteAddress = null;
            this.remotePort = -1;
            throw throwable;
        }
    }

    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (this.remoteAddress != null && this.remoteAddress.isMulticastAddress()) {
            throw new IOException("Socket connected to a multicast address my not receive");
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((DatagramChannelImpl)this.getChannel()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        this.getImpl().receive(datagramPacket);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && this.isConnected()) {
            securityManager.checkAccept(datagramPacket.getAddress().getHostName(), datagramPacket.getPort());
        }
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !this.isConnected()) {
            InetAddress inetAddress = datagramPacket.getAddress();
            if (inetAddress.isMulticastAddress()) {
                securityManager.checkMulticast(inetAddress);
            } else {
                securityManager.checkConnect(inetAddress.getHostAddress(), datagramPacket.getPort());
            }
        }
        if (this.isConnected() && datagramPacket.getAddress() != null && (this.remoteAddress != datagramPacket.getAddress() || this.remotePort != datagramPacket.getPort())) {
            throw new IllegalArgumentException("DatagramPacket address does not match remote address");
        }
        if (this.getChannel() != null && !this.getChannel().isBlocking() && !((DatagramChannelImpl)this.getChannel()).isInChannelOperation()) {
            throw new IllegalBlockingModeException();
        }
        this.getImpl().send(datagramPacket);
    }

    public void bind(SocketAddress socketAddress) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        int n = ((InetSocketAddress)socketAddress).getPort();
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
        if (inetAddress == null) {
            inetAddress = InetAddress.ANY_IF;
        }
        try {
            this.getImpl().bind(n, inetAddress);
            this.bound = true;
        }
        catch (SocketException socketException) {
            this.getImpl().close();
            throw socketException;
        }
        catch (RuntimeException runtimeException) {
            this.getImpl().close();
            throw runtimeException;
        }
        catch (Error error) {
            this.getImpl().close();
            throw error;
        }
    }

    public boolean isClosed() {
        return this.impl == null;
    }

    public DatagramChannel getChannel() {
        return null;
    }

    public void connect(SocketAddress socketAddress) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        this.connect(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isConnected() {
        return this.remoteAddress != null;
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.remoteAddress, this.remotePort);
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(4, bl);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(4);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new SocketException("unexpected type");
    }

    public void setBroadcast(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(32, bl);
    }

    public boolean getBroadcast() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(32);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new SocketException("unexpected type");
    }

    public void setTrafficClass(int n) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException();
        }
        this.getImpl().setOption(3, new Integer(n));
    }

    public int getTrafficClass() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(3);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new SocketException("unexpected type");
    }

    public static void setDatagramSocketImplFactory(DatagramSocketImplFactory datagramSocketImplFactory) throws IOException {
        if (factory != null) {
            throw new SocketException("DatagramSocketImplFactory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = datagramSocketImplFactory;
    }
}

