/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.util.Arrays;

public final class Inet6Address
extends InetAddress {
    static final long serialVersionUID = 6880410070516793377L;
    byte[] ipaddress;

    Inet6Address(byte[] byArray, String string) {
        super(byArray, string);
        this.ipaddress = this.addr;
    }

    public boolean isMulticastAddress() {
        return this.ipaddress[0] == 255;
    }

    public boolean isAnyLocalAddress() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        return Arrays.equals(this.ipaddress, byArray);
    }

    public boolean isLoopbackAddress() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        return Arrays.equals(this.ipaddress, byArray);
    }

    public boolean isLinkLocalAddress() {
        return this.ipaddress[0] == 250;
    }

    public boolean isSiteLocalAddress() {
        return this.ipaddress[0] == 251;
    }

    public boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 14;
    }

    public boolean isMCNodeLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 1;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 2;
    }

    public boolean isMCSiteLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 5;
    }

    public boolean isMCOrgLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 8;
    }

    public byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    public String getHostAddress() {
        StringBuffer stringBuffer = new StringBuffer(40);
        for (int i = 0; i < 16; i += 2) {
            int n = (this.ipaddress[i] & 0xFF) << 8 | this.ipaddress[i + 1] & 0xFF;
            if (i > 0) {
                stringBuffer.append(':');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Inet6Address)) {
            return false;
        }
        return super.equals(object);
    }

    public boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }
}

