/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class InetAddress
implements Serializable {
    private static final long serialVersionUID = 3286316764910316507L;
    static InetAddress ANY_IF;
    private static final byte[] loopbackAddress;
    private static final InetAddress loopback;
    private static InetAddress localhost;
    private int address;
    transient byte[] addr;
    String hostName;
    int family;

    InetAddress(byte[] byArray, String string) {
        this.addr = byArray == null ? null : (byte[])byArray.clone();
        this.hostName = string;
        if (byArray != null) {
            this.family = InetAddress.getFamily(byArray);
        }
    }

    public boolean isMulticastAddress() {
        if (this.addr.length == 4) {
            return (this.addr[0] & 0xF0) == 224;
        }
        if (this.addr.length == 16) {
            return this.addr[0] == -1;
        }
        return false;
    }

    public boolean isAnyLocalAddress() {
        return this.equals(ANY_IF);
    }

    public boolean isLoopbackAddress() {
        return (this.addr[0] & 0xFF) == 127;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        if ((this.addr[0] & 0xFF) == 10) {
            return true;
        }
        if ((this.addr[0] & 0xFF) == 172 && (this.addr[1] & 0xF0) == 16) {
            return true;
        }
        return (this.addr[0] & 0xFF) == 192 && (this.addr[1] & 0xFF) == 168;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.addr[0] & 0xFF) == 224 && (this.addr[1] & 0xFF) == 0 && (this.addr[2] & 0xFF) == 0;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public String getHostName() {
        if (this.hostName != null) {
            return this.hostName;
        }
        InetAddress.lookup(null, this, false);
        return this.hostName;
    }

    public String getCanonicalHostName() {
        byte[] byArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(this.hostName, -1);
            }
            catch (SecurityException securityException) {
                return this.getHostAddress();
            }
        }
        InetAddress inetAddress = (byArray = this.getAddress()).length == 16 ? new Inet6Address(this.getAddress(), null) : new Inet4Address(this.getAddress(), null);
        return inetAddress.getHostName();
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    private static InetAddress[] allocArray(int n) {
        return new InetAddress[n];
    }

    private static SecurityException checkConnect(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        try {
            securityManager.checkConnect(string, -1);
            return null;
        }
        catch (SecurityException securityException) {
            return securityException;
        }
    }

    public String getHostAddress() {
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = this.addr.length;
        int n2 = 0;
        if (n == 16) {
            while (true) {
                boolean bl;
                if (n2 >= 16) {
                    return stringBuffer.toString();
                }
                int n3 = (this.addr[n2] & 0xFF) << 8 | this.addr[n2 + 1] & 0xFF;
                boolean bl2 = bl = stringBuffer.length() == 0;
                if (bl) {
                    if (n2 == 10 && n3 == 65535) {
                        stringBuffer.append(":FFFF:");
                        break;
                    }
                    if (n2 == 12) {
                        stringBuffer.append(':');
                        break;
                    }
                    if (n2 > 0) {
                        stringBuffer.append("::");
                    }
                } else {
                    stringBuffer.append(':');
                }
                if (n3 != 0 || n2 >= 14) {
                    stringBuffer.append(Integer.toHexString(n3).toUpperCase());
                }
                n2 += 2;
            }
        }
        while (true) {
            stringBuffer.append(this.addr[n2] & 0xFF);
            if (++n2 == n) break;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        int n3 = this.addr.length;
        int n4 = n = n3 > 4 ? n3 - 4 : 0;
        while (n < n3) {
            n2 = n2 << 8 | this.addr[n] & 0xFF;
            ++n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InetAddress)) {
            return false;
        }
        byte[] byArray = ((InetAddress)object).addr;
        if (this.addr.length != byArray.length) {
            return false;
        }
        for (int i = 0; i < this.addr.length; ++i) {
            if (this.addr[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = this.getHostAddress();
        String string2 = this.hostName != null ? this.hostName : "";
        return string2 + "/" + string;
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        return InetAddress.getByAddress(null, byArray);
    }

    public static InetAddress getByAddress(String string, byte[] byArray) throws UnknownHostException {
        if (byArray.length == 4) {
            return new Inet4Address(byArray, string);
        }
        if (byArray.length == 16) {
            return new Inet6Address(byArray, string);
        }
        throw new UnknownHostException("IP address has illegal length");
    }

    private static native byte[] aton(String var0);

    private static native InetAddress[] lookup(String var0, InetAddress var1, boolean var2);

    private static native int getFamily(byte[] var0);

    public static InetAddress getByName(String string) throws UnknownHostException {
        byte[] byArray;
        if (string == null || string.length() == 0) {
            return loopback;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, -1);
        }
        if ((byArray = InetAddress.aton(string)) != null) {
            if (byArray.length == 4) {
                return new Inet4Address(byArray, null);
            }
            if (byArray.length == 16) {
                if (byArray[10] == 255 && byArray[11] == 255) {
                    byte[] byArray2 = new byte[]{byArray[12], byArray[13], byArray[14], byArray[15]};
                    return new Inet4Address(byArray2, null);
                }
                return new Inet6Address(byArray, null);
            }
            throw new UnknownHostException("Address has invalid length");
        }
        InetAddress inetAddress = new InetAddress(null, null);
        InetAddress.lookup(string, inetAddress, false);
        return inetAddress;
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        byte[] byArray;
        if (string == null || string.length() == 0) {
            return new InetAddress[]{loopback};
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, -1);
        }
        if ((byArray = InetAddress.aton(string)) != null) {
            InetAddress[] inetAddressArray = new InetAddress[]{new InetAddress(byArray, null)};
            return inetAddressArray;
        }
        return InetAddress.lookup(string, null, true);
    }

    private static native String getLocalHostname();

    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager securityManager = System.getSecurityManager();
        if (localhost == null || securityManager != null && !localhost.isLoopbackAddress()) {
            InetAddress.getLocalHost(securityManager);
        }
        return localhost;
    }

    private static synchronized void getLocalHost(SecurityManager securityManager) throws UnknownHostException {
        if (securityManager == null && localhost != null) {
            return;
        }
        String string = InetAddress.getLocalHostname();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(string, -1);
            }
            catch (SecurityException securityException) {
                string = null;
            }
        }
        if (string != null && string.length() != 0) {
            try {
                localhost = new InetAddress(null, null);
                InetAddress.lookup(string, localhost, false);
            }
            catch (Exception exception) {
                UnknownHostException unknownHostException = new UnknownHostException(string);
                unknownHostException.initCause(exception);
                throw unknownHostException;
            }
        } else {
            throw new UnknownHostException();
        }
        if (localhost == null) {
            localhost = new InetAddress(loopbackAddress, "localhost");
        }
    }

    private void readResolve() throws ObjectStreamException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addr = new byte[4];
        this.addr[3] = (byte)this.address;
        for (int i = 2; i >= 0; --i) {
            this.addr[i] = (byte)(this.address >>= 8);
        }
        this.family = InetAddress.getFamily(this.addr);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.addr.length;
        for (int i = n - 4; i < n; ++i) {
            this.address = this.address << 8 | this.addr[i] & 0xFF;
        }
        objectOutputStream.defaultWriteObject();
    }

    static {
        loopbackAddress = new byte[]{127, 0, 0, 1};
        loopback = new Inet4Address(loopbackAddress, "localhost");
        localhost = null;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        ANY_IF = new Inet4Address(byArray, "0.0.0.0");
    }
}

