/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

public abstract class URLStreamHandler {
    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected void parseURL(URL uRL, String string, int n, int n2) {
        int n3;
        String string2 = uRL.getHost();
        int n4 = uRL.getPort();
        String string3 = uRL.getFile();
        String string4 = uRL.getRef();
        String string5 = uRL.getUserInfo();
        String string6 = uRL.getAuthority();
        String string7 = null;
        char c = File.separatorChar;
        if (uRL.getProtocol().equals("file") && c != '/') {
            string3 = string3.replace(c, '/');
            string = string.replace(c, '/');
        }
        if (string.regionMatches(n, "//", 0, 2)) {
            String string8;
            int n5 = string.indexOf(47, n += 2);
            int n6 = n5 >= 0 ? n5 : n2;
            string6 = string2 = string.substring(n, n6);
            n3 = string2.indexOf(64);
            if (n3 >= 0) {
                string8 = string2.substring(n3);
                string5 = string2.substring(0, n3);
            } else {
                string8 = string2;
            }
            int n7 = string8.indexOf(58);
            if (n7 >= 0) {
                try {
                    n4 = Integer.parseInt(string8.substring(n7 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                string2 = n3 >= 0 ? string2.substring(0, n3 + n7) : string2.substring(0, n7);
            }
            string3 = null;
            n = n6;
        } else if (string2 == null) {
            string2 = "";
        }
        if (string3 == null || string3.length() == 0 || n < n2 && string.charAt(n) == '/') {
            string3 = string.substring(n, n2);
            string4 = null;
        } else if (n < n2) {
            n3 = string3.lastIndexOf(47);
            string3 = n3 < 0 ? string.substring(n, n2) : string3.substring(0, n3) + '/' + string.substring(n, n2);
            string3 = URLStreamHandler.canonicalizeFilename(string3);
            string4 = null;
        }
        if (string4 == null && (n3 = string3.indexOf(35)) != -1) {
            string4 = string3.substring(n3 + 1, string3.length());
            string3 = string3.substring(0, n3);
        }
        if (string4 == null && (n3 = string3.indexOf(63)) != -1) {
            string7 = string3.substring(n3 + 1);
            string3 = string3.substring(0, n3);
        }
        this.setURL(uRL, uRL.getProtocol(), string2, n4, string6, string5, string3, string7, string4);
    }

    private static String canonicalizeFilename(String string) {
        int n;
        int n2;
        while ((n2 = string.indexOf("/./")) >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + 2);
        }
        while ((n2 = string.indexOf("/../")) >= 0 && (n = string.lastIndexOf(47, n2 - 1)) >= 0) {
            string = string.substring(0, n) + string.substring(n2 + 3);
        }
        return string;
    }

    protected boolean sameFile(URL uRL, URL uRL2) {
        String string;
        int n;
        if (uRL == uRL2) {
            return true;
        }
        if (uRL == null || uRL2 == null) {
            return false;
        }
        int n2 = uRL.getPort();
        if (n2 == -1) {
            n2 = uRL.ph.getDefaultPort();
        }
        if ((n = uRL2.getPort()) == -1) {
            n = uRL2.ph.getDefaultPort();
        }
        if (n2 != n) {
            return false;
        }
        String string2 = uRL.getProtocol();
        if (!(string2 == (string = uRL2.getProtocol()) || string2 != null && string2.equals(string))) {
            return false;
        }
        string2 = uRL.getHost();
        if (!(string2 == (string = uRL2.getHost()) || string2 != null && string2.equals(string))) {
            return false;
        }
        string2 = URLStreamHandler.canonicalizeFilename(uRL.getFile());
        return string2 == (string = URLStreamHandler.canonicalizeFilename(uRL2.getFile())) || string2 != null && string2.equals(string);
    }

    protected void setURL(URL uRL, String string, String string2, int n, String string3, String string4) {
        uRL.set(string, string2, n, string3, string4);
    }

    protected void setURL(URL uRL, String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        uRL.set(string, string2, n, string3, string4, string5, string6, string7);
    }

    protected boolean equals(URL uRL, URL uRL2) {
        return uRL.getPort() == uRL2.getPort() && (uRL.getProtocol() == null && uRL2.getProtocol() == null || uRL.getProtocol() != null && uRL.getProtocol().equals(uRL2.getProtocol())) && (uRL.getUserInfo() == null && uRL2.getUserInfo() == null || uRL.getUserInfo() != null && uRL.getUserInfo().equals(uRL2.getUserInfo())) && (uRL.getAuthority() == null && uRL2.getAuthority() == null || uRL.getAuthority() != null && uRL.getAuthority().equals(uRL2.getAuthority())) && (uRL.getHost() == null && uRL2.getHost() == null || uRL.getHost() != null && uRL.getHost().equals(uRL2.getHost())) && (uRL.getPath() == null && uRL2.getPath() == null || uRL.getPath() != null && uRL.getPath().equals(uRL2.getPath())) && (uRL.getQuery() == null && uRL2.getQuery() == null || uRL.getQuery() != null && uRL.getQuery().equals(uRL2.getQuery())) && (uRL.getRef() == null && uRL2.getRef() == null || uRL.getRef() != null && uRL.getRef().equals(uRL2.getRef()));
    }

    protected boolean hostsEqual(URL uRL, URL uRL2) {
        InetAddress inetAddress = this.getHostAddress(uRL);
        InetAddress inetAddress2 = this.getHostAddress(uRL2);
        if (inetAddress != null && inetAddress2 != null) {
            return inetAddress.equals(inetAddress2);
        }
        String string = uRL.getHost();
        String string2 = uRL2.getHost();
        if (string != null && string2 != null) {
            return string.equalsIgnoreCase(string2);
        }
        return string == null && string2 == null;
    }

    protected InetAddress getHostAddress(URL uRL) {
        String string = uRL.getHost();
        if (string.equals("")) {
            return null;
        }
        try {
            return InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected int hashCode(URL uRL) {
        return uRL.getProtocol().hashCode() + (uRL.getHost() == null ? 0 : uRL.getHost().hashCode()) + uRL.getFile().hashCode() + uRL.getPort();
    }

    protected String toExternalForm(URL uRL) {
        String string = uRL.getProtocol();
        String string2 = uRL.getAuthority();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = uRL.getFile();
        String string4 = uRL.getRef();
        int n = string.length() + string2.length() + string3.length() + 24;
        StringBuffer stringBuffer = new StringBuffer(n);
        if (string.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        if (string2.length() != 0 || string3.startsWith("//")) {
            stringBuffer.append("//").append(string2).append(string3);
        } else {
            stringBuffer.append(string3);
        }
        if (string4 != null) {
            stringBuffer.append('#').append(string4);
        }
        return stringBuffer.toString();
    }
}

