/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;

public final class AccessControlContext {
    private ProtectionDomain[] protectionDomains;
    private DomainCombiner combiner;

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        int n;
        int n2;
        int n3 = protectionDomainArray.length;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n2 && protectionDomainArray[n] != this.protectionDomains[n2]; ++n) {
            }
            if (n != n2) continue;
            ++n4;
        }
        this.protectionDomains = new ProtectionDomain[n4];
        n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n2 && protectionDomainArray[n] != this.protectionDomains[n2]; ++n) {
            }
            if (n != n2) continue;
            this.protectionDomains[n5++] = protectionDomainArray[n2];
        }
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        this(accessControlContext.protectionDomains);
        this.combiner = domainCombiner;
    }

    public DomainCombiner getDomainCombiner() {
        return this.combiner;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        for (int i = 0; i < this.protectionDomains.length; ++i) {
            if (!this.protectionDomains[i].implies(permission)) continue;
            return;
        }
        throw new AccessControlException("Permission not granted");
    }

    public boolean equals(Object object) {
        if (object instanceof AccessControlContext) {
            AccessControlContext accessControlContext = (AccessControlContext)object;
            if (accessControlContext.protectionDomains.length != this.protectionDomains.length) {
                return false;
            }
            for (int i = 0; i < this.protectionDomains.length; ++i) {
                if (accessControlContext.protectionDomains[i] == this.protectionDomains[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.protectionDomains.length; ++i) {
            n ^= this.protectionDomains[i].hashCode();
        }
        return n;
    }
}

